/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.cache;

import eu.stratosphere.sopremo.cache.FunctionCache;
import eu.stratosphere.sopremo.cache.ISopremoCache;
import eu.stratosphere.sopremo.function.SopremoFunction;
import java.util.IdentityHashMap;
import java.util.Map;

public class FunctionCacheCache
implements ISopremoCache {
    private final transient ThreadLocal<Map<SopremoFunction, FunctionCache>> caches = new ThreadLocal<Map<SopremoFunction, FunctionCache>>(){

        @Override
        protected Map<SopremoFunction, FunctionCache> initialValue() {
            return new IdentityHashMap<SopremoFunction, FunctionCache>();
        }
    };

    public FunctionCacheCache clone() {
        return new FunctionCacheCache();
    }

    public FunctionCache get(SopremoFunction function) {
        FunctionCache cache = this.caches.get().get(function);
        if (cache != null) {
            return cache;
        }
        FunctionCache newCache = new FunctionCache(function);
        this.caches.get().put(function, newCache);
        return newCache;
    }
}

