/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.cache;

import eu.stratosphere.sopremo.cache.ISopremoCache;
import eu.stratosphere.sopremo.function.SopremoFunction;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.SubArrayNode;
import java.util.ArrayList;
import java.util.List;

public class FunctionCache
implements ISopremoCache {
    private final SopremoFunction template;
    private final transient List<SopremoFunction> functions = new ArrayList<SopremoFunction>();
    private final transient IArrayNode<IJsonNode> cachedParams;
    private final transient SubArrayNode<IJsonNode> subParams = new SubArrayNode();

    public FunctionCache(SopremoFunction template) {
        this.template = template;
        this.cachedParams = new ArrayNode<IJsonNode>(template.getMaximumNumberOfParameters());
        this.subParams.init(this.cachedParams, 0);
    }

    public IJsonNode call(int functionIndex, IJsonNode ... params) {
        this.subParams.setSize(params.length);
        for (int index = 0; index < params.length; ++index) {
            this.cachedParams.set(index, params[index]);
        }
        return (IJsonNode)this.get(functionIndex).call(this.cachedParams);
    }

    public FunctionCache clone() {
        return new FunctionCache(this.template.clone());
    }

    public SopremoFunction get(int index) {
        while (index >= this.functions.size()) {
            this.functions.add(this.template.clone());
        }
        return this.functions.get(index);
    }

    public SopremoFunction getTemplate() {
        return this.template;
    }
}

