/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.cache;

import eu.stratosphere.sopremo.cache.ExpressionCache;
import eu.stratosphere.sopremo.cache.ISopremoCache;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import java.util.IdentityHashMap;
import java.util.Map;

public class ExpressionCacheCache<E extends EvaluationExpression>
implements ISopremoCache {
    private final transient ThreadLocal<Map<E, ExpressionCache<E>>> caches = new ThreadLocal<Map<E, ExpressionCache<E>>>(){

        @Override
        protected Map<E, ExpressionCache<E>> initialValue() {
            return new IdentityHashMap();
        }
    };

    public ExpressionCacheCache<E> clone() {
        return new ExpressionCacheCache<E>();
    }

    public ExpressionCache<E> get(E expression) {
        ExpressionCache<E> cache = this.caches.get().get(expression);
        if (cache != null) {
            return cache;
        }
        ExpressionCache<E> newCache = new ExpressionCache<E>(expression);
        this.caches.get().put(expression, newCache);
        return newCache;
    }
}

