/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.cache;

import eu.stratosphere.sopremo.cache.ISopremoCache;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Array;

public class ArrayCache<T>
implements ISopremoCache {
    private final Class<T> type;
    private final transient Int2ObjectMap<T[]> cache = new Int2ObjectArrayMap();

    public ArrayCache(Class<T> type) {
        this.type = type;
    }

    public ArrayCache<T> clone() {
        return new ArrayCache<T>(this.type);
    }

    public T[] getArray(int size) {
        Object[] cachedArray = (Object[])this.cache.get(size);
        if (cachedArray != null) {
            return cachedArray;
        }
        Object[] newArray = (Object[])Array.newInstance(this.type, size);
        this.cache.put(size, (Object)newArray);
        return newArray;
    }
}

