/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.aggregation;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import eu.stratosphere.sopremo.aggregation.Aggregation;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.util.reflect.ReflectUtil;

@DefaultSerializer(value=AssociativeAggregationSerializer.class)
public abstract class AssociativeAggregation<ElementType extends IJsonNode>
extends Aggregation {
    protected final transient ElementType initialAggregate;
    protected transient ElementType aggregator;

    public AssociativeAggregation(ElementType initialAggregate) {
        this.initialAggregate = initialAggregate;
        this.aggregator = initialAggregate.clone();
    }

    @Override
    public void aggregate(IJsonNode element) {
        this.aggregator = this.aggregate(this.aggregator, element);
    }

    @Override
    public IJsonNode getFinalAggregate() {
        return this.aggregator;
    }

    @Override
    public void initialize() {
        if (this.aggregator.getType() != this.initialAggregate.getType()) {
            this.aggregator = this.initialAggregate.clone();
        } else {
            this.aggregator.copyValueFrom((IJsonNode)this.initialAggregate);
        }
    }

    protected abstract ElementType aggregate(ElementType var1, IJsonNode var2);

    public static class AssociativeAggregationSerializer
    extends Serializer<AssociativeAggregation<?>> {
        public AssociativeAggregation<?> copy(Kryo kryo, AssociativeAggregation<?> original) {
            if (original.getClass().isAnonymousClass()) {
                return (AssociativeAggregation)ReflectUtil.newInstance(original.getClass(), (Object[])new Object[]{original.initialAggregate});
            }
            return (AssociativeAggregation)kryo.newInstance(original.getClass());
        }

        public AssociativeAggregation<?> read(Kryo kryo, Input input, Class<AssociativeAggregation<?>> type) {
            if (type.isAnonymousClass()) {
                return (AssociativeAggregation)ReflectUtil.newInstance(type, (Object[])new Object[]{kryo.readClassAndObject(input)});
            }
            return (AssociativeAggregation)kryo.newInstance(type);
        }

        public void write(Kryo kryo, Output output, AssociativeAggregation<?> object) {
            if (object.getClass().isAnonymousClass()) {
                kryo.writeClassAndObject(output, object.initialAggregate);
            }
        }
    }
}

