/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo.aggregation;

import eu.stratosphere.sopremo.aggregation.Aggregation;
import eu.stratosphere.sopremo.type.CachingArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import java.io.IOException;
import javolution.text.TypeFormat;

public class ArrayAccessAsAggregation
extends Aggregation {
    private final int startIndex;
    private final int endIndex;
    private transient int elementsToSkip;
    private transient int remainingElements;
    private final boolean range;
    private final transient CachingArrayNode<IJsonNode> arrayResult = new CachingArrayNode();

    public ArrayAccessAsAggregation(int index) {
        this(index, index, false);
    }

    public ArrayAccessAsAggregation(int startIndex, int endIndex, boolean range) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.range = range;
    }

    ArrayAccessAsAggregation() {
        this(0, 0, false);
    }

    @Override
    public void aggregate(IJsonNode element) {
        if (this.elementsToSkip > 0) {
            --this.elementsToSkip;
        } else if (this.remainingElements > 0) {
            this.arrayResult.addClone(element);
            --this.remainingElements;
        }
    }

    @Override
    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append("@[");
        TypeFormat.format((int)this.startIndex, (Appendable)appendable);
        if (this.startIndex != this.endIndex) {
            appendable.append(':');
            TypeFormat.format((int)this.endIndex, (Appendable)appendable);
        }
        appendable.append(']');
    }

    @Override
    public Aggregation clone() {
        return new ArrayAccessAsAggregation(this.startIndex, this.endIndex, this.range);
    }

    @Override
    public IJsonNode getFinalAggregate() {
        if (this.range) {
            return this.arrayResult;
        }
        return this.arrayResult.get(0);
    }

    @Override
    public void initialize() {
        this.elementsToSkip = this.startIndex;
        this.remainingElements = this.endIndex - this.startIndex + 1;
        this.arrayResult.clear();
    }
}

