/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo;

import eu.stratosphere.api.common.functions.RuntimeContext;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.sopremo.EvaluationContext;
import eu.stratosphere.sopremo.pact.SopremoUtil;

public class SopremoEnvironment {
    private static final ThreadLocal<SopremoEnvironment> INSTANCE = new ThreadLocal<SopremoEnvironment>(){

        @Override
        protected SopremoEnvironment initialValue() {
            return new SopremoEnvironment();
        }
    };
    private EvaluationContext evaluationContext = new EvaluationContext();
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private Configuration configuration;
    private RuntimeContext runtimeContext;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public EvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader must not be null");
        }
        this.classLoader = classLoader;
    }

    public void setConfiguration(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration must not be null");
        }
        this.configuration = configuration;
        this.configuration = configuration;
        this.classLoader = configuration.getClassLoader();
        this.evaluationContext = SopremoUtil.getEvaluationContext(configuration);
    }

    public void setConfigurationAndContext(Configuration parameters, RuntimeContext runtimeContext) {
        this.setConfiguration(parameters);
        this.setRuntimeContext(runtimeContext);
    }

    public void setEvaluationContext(EvaluationContext evaluationContext) {
        if (evaluationContext == null) {
            throw new NullPointerException("evaluationContext must not be null");
        }
        this.evaluationContext = evaluationContext;
    }

    public void setRuntimeContext(RuntimeContext context) {
        if (context == null) {
            throw new NullPointerException("runtimeContext must not be null");
        }
        this.runtimeContext = context;
    }

    public static SopremoEnvironment getInstance() {
        return INSTANCE.get();
    }
}

