/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo;

import eu.stratosphere.sopremo.cache.FunctionCache;
import eu.stratosphere.sopremo.cache.FunctionCacheCache;
import eu.stratosphere.sopremo.cache.NodeCache;
import eu.stratosphere.sopremo.function.FunctionNode;
import eu.stratosphere.sopremo.function.SopremoFunction;
import eu.stratosphere.sopremo.function.SopremoFunction2;
import eu.stratosphere.sopremo.function.SopremoFunction3;
import eu.stratosphere.sopremo.operator.Name;
import eu.stratosphere.sopremo.packages.BuiltinProvider;
import eu.stratosphere.sopremo.pact.SopremoUtil;
import eu.stratosphere.sopremo.type.ArrayNode;
import eu.stratosphere.sopremo.type.BooleanNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.NullNode;

public class SecondOrderFunctions
implements BuiltinProvider {
    @Name(verb={"map"})
    public static final SopremoFunction MAP = new SopremoFunction2<IArrayNode<IJsonNode>, FunctionNode>(){
        private final transient IArrayNode<IJsonNode> result = new ArrayNode<IJsonNode>();
        private final transient IArrayNode<IJsonNode> parameters = new ArrayNode<IJsonNode>(1);
        private final transient FunctionCacheCache caches = new FunctionCacheCache();

        @Override
        protected IJsonNode call(IArrayNode<IJsonNode> input, FunctionNode mapExpression) {
            SopremoUtil.assertArguments(mapExpression.getFunction(), 1);
            this.result.clear();
            FunctionCache calls = this.caches.get(mapExpression.getFunction());
            for (int index = 0; index < input.size(); ++index) {
                this.parameters.set(0, input.get(index));
                this.result.add((IJsonNode)calls.get(index).call(this.parameters));
            }
            return this.result;
        }
    };
    @Name(verb={"filter"})
    public static final SopremoFunction FILTER = new SopremoFunction2<IArrayNode<IJsonNode>, FunctionNode>(){
        private final transient IArrayNode<IJsonNode> result = new ArrayNode<IJsonNode>();
        private final transient IArrayNode<IJsonNode> parameters = new ArrayNode<IJsonNode>(1);

        @Override
        protected IJsonNode call(IArrayNode<IJsonNode> input, FunctionNode filterExpression) {
            SopremoUtil.assertArguments(filterExpression.getFunction(), 1);
            this.result.clear();
            SopremoFunction function = filterExpression.getFunction();
            for (IJsonNode node : input) {
                this.parameters.set(0, node);
                if (function.call(this.parameters) != BooleanNode.TRUE) continue;
                this.result.add(node);
            }
            return this.result;
        }
    };
    @Name(verb={"fold", "reduce"})
    public static final SopremoFunction FOLD = new SopremoFunction3<IArrayNode<IJsonNode>, IJsonNode, FunctionNode>(){
        private final transient NodeCache nodeCache = new NodeCache();
        private final transient IArrayNode<IJsonNode> parameters = new ArrayNode<IJsonNode>();

        @Override
        protected IJsonNode call(IArrayNode<IJsonNode> input, IJsonNode initial, FunctionNode foldExpression) {
            SopremoUtil.assertArguments(foldExpression.getFunction(), 2);
            IJsonNode aggregator = this.nodeCache.clone(initial);
            this.parameters.set(0, aggregator);
            SopremoFunction function = foldExpression.getFunction();
            for (IJsonNode node : input) {
                this.parameters.set(1, node);
                aggregator.copyValueFrom((IJsonNode)function.call(this.parameters));
            }
            return aggregator;
        }
    };
    @Name(verb={"find"})
    public static final SopremoFunction FIND = new SopremoFunction2<IArrayNode<IJsonNode>, FunctionNode>(){
        private final transient IArrayNode<IJsonNode> parameters = new ArrayNode<IJsonNode>(1);

        @Override
        protected IJsonNode call(IArrayNode<IJsonNode> input, FunctionNode filterExpression) {
            SopremoUtil.assertArguments(filterExpression.getFunction(), 1);
            SopremoFunction function = filterExpression.getFunction();
            for (IJsonNode node : input) {
                this.parameters.set(0, node);
                if (function.call(this.parameters) != BooleanNode.TRUE) continue;
                return node;
            }
            return NullNode.getInstance();
        }
    };
}

