/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.sopremo;

import com.esotericsoftware.kryo.Kryo;
import eu.stratosphere.core.fs.Path;
import eu.stratosphere.sopremo.AbstractSopremoType;
import eu.stratosphere.sopremo.ISopremoType;
import eu.stratosphere.sopremo.expressions.EvaluationExpression;
import eu.stratosphere.sopremo.packages.DefaultNameChooserProvider;
import eu.stratosphere.sopremo.packages.DefaultTypeRegistry;
import eu.stratosphere.sopremo.packages.ITypeRegistry;
import eu.stratosphere.sopremo.packages.NameChooserProvider;
import eu.stratosphere.sopremo.type.BooleanNode;
import eu.stratosphere.sopremo.type.IArrayNode;
import eu.stratosphere.sopremo.type.IJsonNode;
import eu.stratosphere.sopremo.type.INumericNode;
import eu.stratosphere.sopremo.type.IObjectNode;
import eu.stratosphere.sopremo.type.MissingNode;
import eu.stratosphere.sopremo.type.NullNode;
import eu.stratosphere.sopremo.type.TextNode;
import eu.stratosphere.sopremo.type.TypeCoercer;
import eu.stratosphere.util.SopremoKryo;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EvaluationContext
extends AbstractSopremoType {
    private String workingPath;
    private String operatorDescription;
    private EvaluationExpression resultProjection = EvaluationExpression.VALUE;
    private final ITypeRegistry typeRegistry;
    private final NameChooserProvider nameChooserProvider;
    private int taskId;
    private final transient Kryo kryo;
    private final transient Kryo dataKryo;
    private final Map<String, Object> contextParameters = new HashMap<String, Object>();

    public EvaluationContext() {
        this(new DefaultTypeRegistry(), new DefaultNameChooserProvider());
    }

    public EvaluationContext(ITypeRegistry typeRegistry, NameChooserProvider nameChooserProvider) {
        this.typeRegistry = typeRegistry;
        this.nameChooserProvider = nameChooserProvider;
        this.workingPath = new Path(new File(".").toURI().toString()).toString();
        this.dataKryo = new Kryo();
        this.dataKryo.setReferences(false);
        for (Class<? extends INumericNode> type : TypeCoercer.NUMERIC_TYPES) {
            this.dataKryo.register(type);
        }
        List<Class> defaultTypes = Arrays.asList(BooleanNode.class, TextNode.class, IObjectNode.class, IArrayNode.class, NullNode.class, MissingNode.class, TreeMap.class, ArrayList.class, BigInteger.class, BigDecimal.class);
        for (Class type : defaultTypes) {
            this.dataKryo.register(type);
        }
        List<Class<? extends IJsonNode>> types = typeRegistry.getTypes();
        for (Class<? extends IJsonNode> type : types) {
            this.dataKryo.register(type);
        }
        this.kryo = new SopremoKryo();
    }

    protected EvaluationContext(EvaluationContext context) {
        this(context.typeRegistry, context.nameChooserProvider);
        this.contextParameters.putAll(context.contextParameters);
        this.copyPropertiesFrom(context);
    }

    public void appendAsString(Appendable appendable) throws IOException {
        appendable.append("Context @ ").append(this.operatorDescription).append("\n");
        appendable.append("\nParameters: ");
        appendable.append(this.contextParameters.toString());
    }

    @Override
    public EvaluationContext clone() {
        return (EvaluationContext)super.clone();
    }

    public void copyPropertiesFrom(ISopremoType original) {
        EvaluationContext context = (EvaluationContext)original;
        this.resultProjection = context.resultProjection.clone();
        this.operatorDescription = context.operatorDescription;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvaluationContext other = (EvaluationContext)obj;
        if (this.contextParameters == null ? other.contextParameters != null : !this.contextParameters.equals(other.contextParameters)) {
            return false;
        }
        if (this.operatorDescription == null ? other.operatorDescription != null : !this.operatorDescription.equals(other.operatorDescription)) {
            return false;
        }
        if (this.resultProjection == null ? other.resultProjection != null : !this.resultProjection.equals(other.resultProjection)) {
            return false;
        }
        if (this.taskId != other.taskId) {
            return false;
        }
        if (this.typeRegistry == null ? other.typeRegistry != null : !this.typeRegistry.equals(other.typeRegistry)) {
            return false;
        }
        return !(this.workingPath == null ? other.workingPath != null : !this.workingPath.equals(other.workingPath));
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    public Kryo getKryoForDataSerialization() {
        return this.dataKryo;
    }

    public NameChooserProvider getNameChooserProvider() {
        return this.nameChooserProvider;
    }

    public String getOperatorDescription() {
        return this.operatorDescription;
    }

    public <Type> Type getParameter(String key, Class<Type> type) {
        Object value = this.contextParameters.get(key);
        return (Type)value;
    }

    public EvaluationExpression getResultProjection() {
        return this.resultProjection;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public ITypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public Path getWorkingPath() {
        return new Path(this.workingPath);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contextParameters == null ? 0 : this.contextParameters.hashCode());
        result = 31 * result + (this.operatorDescription == null ? 0 : this.operatorDescription.hashCode());
        result = 31 * result + (this.resultProjection == null ? 0 : this.resultProjection.hashCode());
        result = 31 * result + this.taskId;
        result = 31 * result + (this.typeRegistry == null ? 0 : this.typeRegistry.hashCode());
        result = 31 * result + (this.workingPath == null ? 0 : this.workingPath.hashCode());
        return result;
    }

    public void putParameter(String key, Object value) {
        this.contextParameters.put(key, value);
    }

    public void setOperatorDescription(String operatorDescription) {
        if (operatorDescription == null) {
            throw new NullPointerException("operatorDescription must not be null");
        }
        this.operatorDescription = operatorDescription;
    }

    public void setResultProjection(EvaluationExpression resultProjection) {
        if (resultProjection == null) {
            throw new NullPointerException("resultProjection must not be null");
        }
        this.resultProjection = resultProjection;
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }

    public void setWorkingPath(Path hdfsPath) {
        if (hdfsPath == null) {
            throw new NullPointerException("hdfsPath must not be null");
        }
        this.workingPath = hdfsPath.toString();
    }

    @Override
    public EvaluationContext shallowClone() {
        return (EvaluationContext)super.shallowClone();
    }
}

