/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.common.plan;

import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.api.common.operators.FileDataSource;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.GenericDataSource;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.util.OperatorUtil;
import eu.stratosphere.pact.common.plan.OneTimeVisitor;
import eu.stratosphere.pact.common.plan.OperatorNavigator;
import eu.stratosphere.util.Visitable;
import eu.stratosphere.util.Visitor;
import eu.stratosphere.util.dag.ConnectionNavigator;
import eu.stratosphere.util.dag.GraphModule;
import eu.stratosphere.util.dag.GraphPrinter;
import eu.stratosphere.util.dag.GraphTraverseListener;
import eu.stratosphere.util.dag.NodePrinter;
import eu.stratosphere.util.dag.OneTimeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class PactModule
extends GraphModule<Operator, GenericDataSource<?>, GenericDataSink>
implements Visitable<Operator> {
    public PactModule(int numberOfInputs, int numberOfOutputs) {
        super(numberOfInputs, numberOfOutputs, (ConnectionNavigator)OperatorNavigator.INSTANCE);
        int index;
        for (index = 0; index < numberOfInputs; ++index) {
            this.setInput(index, new FileDataSource(FileInputFormat.class, String.format("file:///%d", index), "Source " + index));
        }
        for (index = 0; index < numberOfOutputs; ++index) {
            this.setOutput(index, new FileDataSink(FileOutputFormat.class, String.format("file:///%d", index), "Sink " + index));
        }
    }

    public void accept(Visitor<Operator> visitor) {
        OneTimeVisitor<Operator> oneTimeVisitor = new OneTimeVisitor<Operator>(visitor);
        for (Operator output : this.getAllOutputs()) {
            output.accept(oneTimeVisitor);
        }
    }

    public String toString() {
        GraphPrinter dagPrinter = new GraphPrinter();
        dagPrinter.setNodePrinter((NodePrinter)new NodePrinter<Operator>(){

            public String toString(Operator node) {
                int inputIndex = PactModule.this.inputNodes.indexOf(node);
                if (inputIndex != -1) {
                    return String.format("Input %d", inputIndex);
                }
                int outputIndex = PactModule.this.outputNodes.indexOf(node);
                if (outputIndex != -1) {
                    return String.format("Output %d", outputIndex);
                }
                return String.format("%s [%s]", node.getClass().getSimpleName(), node.getName());
            }
        });
        dagPrinter.setWidth(40);
        return dagPrinter.toString((Iterable)this.getAllOutputs(), (ConnectionNavigator)OperatorNavigator.INSTANCE);
    }

    public static PactModule valueOf(Collection<? extends Operator> sinks) {
        final ArrayList inputs = new ArrayList();
        OneTimeTraverser.INSTANCE.traverse(sinks, (ConnectionNavigator)OperatorNavigator.INSTANCE, (GraphTraverseListener)new GraphTraverseListener<Operator>(){

            public void nodeTraversed(Operator node) {
                List contractInputs = OperatorUtil.getInputs((Operator)node);
                if (contractInputs.size() == 0) {
                    inputs.add(node);
                } else {
                    for (List input : contractInputs) {
                        if (input.size() != 0) continue;
                        inputs.add(node);
                    }
                }
            }
        });
        PactModule module = new PactModule(inputs.size(), sinks.size());
        int sinkIndex = 0;
        for (Operator operator : sinks) {
            if (operator instanceof GenericDataSink) {
                module.setOutput(sinkIndex, (GenericDataSink)operator);
            } else {
                ((GenericDataSink)module.getOutput(sinkIndex)).addInput(operator);
            }
            ++sinkIndex;
        }
        int index = 0;
        while (index < inputs.size()) {
            Operator operator = (Operator)inputs.get(index);
            List contractInputs = OperatorUtil.getInputs((Operator)operator);
            if (contractInputs.isEmpty()) {
                module.setInput(index++, (GenericDataSource)operator);
                continue;
            }
            for (int unconnectedIndex = 0; unconnectedIndex < contractInputs.size(); ++unconnectedIndex) {
                if (!((List)contractInputs.get(unconnectedIndex)).isEmpty()) continue;
                ((List)contractInputs.get(unconnectedIndex)).add(module.getInput(index++));
            }
            OperatorUtil.setInputs((Operator)operator, (List)contractInputs);
        }
        return module;
    }

    public static PactModule valueOf(Operator ... sinks) {
        return PactModule.valueOf(Arrays.asList(sinks));
    }
}

