/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.common.plan;

import eu.stratosphere.api.common.operators.BulkIteration;
import eu.stratosphere.api.common.operators.DeltaIteration;
import eu.stratosphere.api.common.operators.IterationOperator;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.common.operators.util.OperatorUtil;
import eu.stratosphere.util.dag.ConnectionNavigator;
import java.util.ArrayList;
import java.util.List;

public class OperatorNavigator
implements ConnectionNavigator<Operator> {
    public static final OperatorNavigator INSTANCE = new OperatorNavigator();

    public List<Operator> getConnectedNodes(Operator node) {
        if (node instanceof IterationOperator) {
            ArrayList<Operator> inputs = new ArrayList<Operator>(OperatorUtil.getFlatInputs((Operator)node));
            if (node instanceof BulkIteration) {
                inputs.add(((BulkIteration)node).getPartialSolution());
                inputs.add(((BulkIteration)node).getTerminationCriterion());
            } else if (node instanceof DeltaIteration) {
                inputs.add(((DeltaIteration)node).getNextWorkset());
                inputs.add(((DeltaIteration)node).getSolutionSetDelta());
            } else {
                throw new IllegalArgumentException("Unknown node");
            }
            return inputs;
        }
        return OperatorUtil.getFlatInputs((Operator)node);
    }
}

