/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.common.plan;

import eu.stratosphere.util.Visitable;
import eu.stratosphere.util.Visitor;
import java.util.IdentityHashMap;
import java.util.Map;

public class OneTimeVisitor<T extends Visitable<T>>
implements Visitor<T> {
    private final Map<T, Object> visitedNodes = new IdentityHashMap<T, Object>();
    private final Visitor<T> visitor;

    public OneTimeVisitor(Visitor<T> visitor) {
        this.visitor = visitor;
    }

    public void postVisit(T visitable) {
        if (this.visitedNodes.get(visitable) == Boolean.TRUE) {
            return;
        }
        this.visitedNodes.put(visitable, Boolean.TRUE);
        this.visitor.postVisit(visitable);
    }

    public boolean preVisit(T visitable) {
        if (this.visitedNodes.containsKey(visitable)) {
            return false;
        }
        this.visitedNodes.put(visitable, Boolean.FALSE);
        this.visitor.preVisit(visitable);
        return true;
    }
}

