/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.rpc;

import java.io.IOException;
import java.io.InputStream;

final class SinglePacketInputStream
extends InputStream {
    private final byte[] buf;
    private final int len;
    private int read;

    SinglePacketInputStream(byte[] buf, int len) {
        this.buf = buf;
        this.read = 0;
        this.len = len;
    }

    @Override
    public int available() {
        return this.len - this.read;
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.read == this.len) {
            return -1;
        }
        return this.buf[this.read++];
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.read == this.len) {
            return -1;
        }
        int r = Math.min(len, this.len - this.read);
        System.arraycopy(this.buf, this.read, b, off, r);
        this.read += r;
        return r;
    }

    @Override
    public void reset() {
        this.read = 0;
    }

    @Override
    public long skip(long n) {
        int dataLeftInBuffer = this.len - this.read;
        if (n > (long)dataLeftInBuffer) {
            this.read = this.len;
            return dataLeftInBuffer;
        }
        this.read += (int)n;
        return n;
    }
}

