/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.rpc;

import com.esotericsoftware.minlog.Log;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class RPCStatistics {
    private final ConcurrentMap<Integer, RetryStatistics> statisticsData = new ConcurrentHashMap<Integer, RetryStatistics>();
    private final RTTStatistics rttStatistics = new RTTStatistics();

    void processCollectedData() {
        Iterator it = this.statisticsData.values().iterator();
        while (it.hasNext()) {
            RetryStatistics data = (RetryStatistics)it.next();
            it.remove();
            data.processCollectedData();
        }
        this.rttStatistics.processCollectedData();
    }

    void reportRTT(String methodName, int rtt) {
        this.rttStatistics.reportRTT(methodName, rtt);
    }

    void reportSuccessfulTransmission(String methodName, int numberOfPackets, int requiredRetries) {
        RetryStatistics oldValue;
        Integer key = numberOfPackets;
        RetryStatistics data = (RetryStatistics)this.statisticsData.get(key);
        if (data == null && (oldValue = this.statisticsData.putIfAbsent(key, data = new RetryStatistics(numberOfPackets))) != null) {
            data = oldValue;
        }
        data.reportNumberOfRequiredRetries(methodName, requiredRetries);
    }

    private static final class RTTStatistics {
        private final AtomicInteger requestCounter = new AtomicInteger(0);
        private final AtomicInteger sumOfRTTs = new AtomicInteger(0);
        private volatile String minMethodName = null;
        private final AtomicInteger minRTT = new AtomicInteger(Integer.MAX_VALUE);
        private volatile String maxMethodName = null;
        private final AtomicInteger maxRTT = new AtomicInteger(Integer.MIN_VALUE);

        private RTTStatistics() {
        }

        private void processCollectedData() {
            int numberOfRequests = this.requestCounter.getAndSet(0);
            if (numberOfRequests == 0) {
                return;
            }
            float avg = (float)this.sumOfRTTs.getAndSet(0) / (float)numberOfRequests;
            int min = this.minRTT.getAndSet(Integer.MAX_VALUE);
            String minMethodName = this.minMethodName;
            this.minMethodName = null;
            int max = this.maxRTT.getAndSet(Integer.MIN_VALUE);
            String maxMethodName = this.maxMethodName;
            this.maxMethodName = null;
            if (Log.DEBUG) {
                StringBuilder sb = new StringBuilder("RTT stats: ");
                sb.append(avg);
                sb.append(" ms avg,\t: ");
                sb.append(min);
                sb.append(" ms min (");
                sb.append(minMethodName);
                sb.append("),\t");
                sb.append(max);
                sb.append(" ms max (");
                sb.append(maxMethodName);
                sb.append(')');
                Log.debug((String)sb.toString());
            }
        }

        private final void reportRTT(String methodName, int rtt) {
            this.requestCounter.incrementAndGet();
            this.sumOfRTTs.addAndGet(rtt);
            this.testAndSetLowestRTT(methodName, rtt);
            this.testAndSetHighestRTT(methodName, rtt);
        }

        private void testAndSetHighestRTT(String methodName, int rtt) {
            int val;
            while (rtt > (val = this.maxRTT.get())) {
                if (!this.maxRTT.compareAndSet(val, rtt)) continue;
                this.maxMethodName = methodName;
                break;
            }
        }

        private void testAndSetLowestRTT(String methodName, int rtt) {
            int val;
            while (rtt < (val = this.minRTT.get())) {
                if (!this.minRTT.compareAndSet(val, rtt)) continue;
                this.minMethodName = methodName;
                break;
            }
        }
    }

    private static final class RetryStatistics {
        private final int numberOfPackets;
        private final AtomicInteger minRetries = new AtomicInteger(Integer.MAX_VALUE);
        private volatile String minMethodName = null;
        private final AtomicInteger maxRetries = new AtomicInteger(Integer.MIN_VALUE);
        private volatile String maxMethodName = null;
        private final AtomicInteger requestCounter = new AtomicInteger(0);
        private final AtomicInteger sumOfRetries = new AtomicInteger(0);

        private RetryStatistics(int numberOfPackets) {
            this.numberOfPackets = numberOfPackets;
        }

        private void processCollectedData() {
            if (Log.DEBUG) {
                int numberOfRequests = this.requestCounter.get();
                if (numberOfRequests == 0) {
                    return;
                }
                float avg = (float)this.sumOfRetries.get() / (float)numberOfRequests;
                StringBuilder sb = new StringBuilder();
                sb.append(this.numberOfPackets);
                sb.append("\t: ");
                sb.append(avg);
                sb.append(" (min ");
                sb.append(this.minMethodName);
                sb.append(' ');
                sb.append(this.minRetries.get());
                sb.append(", max ");
                sb.append(this.maxMethodName);
                sb.append(' ');
                sb.append(this.maxRetries.get());
                sb.append(')');
                Log.debug((String)sb.toString());
            }
        }

        private final void reportNumberOfRequiredRetries(String methodName, int requiredRetries) {
            this.requestCounter.incrementAndGet();
            this.sumOfRetries.addAndGet(requiredRetries);
            this.testAndSetMin(methodName, requiredRetries);
            this.testAndSetMax(methodName, requiredRetries);
        }

        private void testAndSetMax(String methodName, int requiredRetries) {
            int val;
            while (requiredRetries > (val = this.maxRetries.get())) {
                if (!this.maxRetries.compareAndSet(val, requiredRetries)) continue;
                this.maxMethodName = methodName;
                break;
            }
        }

        private void testAndSetMin(String methodName, int requiredRetries) {
            int val;
            while (requiredRetries < (val = this.minRetries.get())) {
                if (!this.minRetries.compareAndSet(val, requiredRetries)) continue;
                this.minMethodName = methodName;
                break;
            }
        }
    }
}

