/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.rpc;

public final class NumberUtils {
    private NumberUtils() {
    }

    public static int byteArrayToInteger(byte[] byteArray, int offset) {
        int integer = 0;
        for (int i = 0; i < 4; ++i) {
            integer |= (byteArray[offset + 3 - i] & 0xFF) << (i << 3);
        }
        return integer;
    }

    public static short byteArrayToShort(byte[] arr, int offset) {
        return (short)(arr[offset] << 8 | arr[offset + 1] & 0xFF);
    }

    public static void integerToByteArray(int integerToSerialize, byte[] byteArray, int offset) {
        for (int i = 0; i < 4; ++i) {
            int shift = i << 3;
            byteArray[offset + 3 - i] = (byte)((integerToSerialize & 255 << shift) >>> shift);
        }
    }

    public static void shortToByteArray(short val, byte[] arr, int offset) {
        arr[offset] = (byte)((val & 0xFF00) >> 8);
        arr[offset + 1] = (byte)(val & 0xFF);
    }
}

