/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.rpc;

import eu.stratosphere.nephele.rpc.NumberUtils;
import eu.stratosphere.nephele.rpc.RPCService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;

final class MultiPacketOutputStream
extends OutputStream {
    private byte[] buf;
    private int totalLen = 0;
    private int lenInPacket = 0;

    MultiPacketOutputStream(int initialBufferSize) {
        this.buf = new byte[initialBufferSize];
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int amountOfDataToWrite;
        int lengthIncludingMetaData = MultiPacketOutputStream.getLengthIncludingMetaData(len);
        while (this.totalLen + lengthIncludingMetaData > this.buf.length) {
            this.resizeBuffer();
        }
        for (int written = 0; written < len; written += amountOfDataToWrite) {
            if (this.lenInPacket == 1016) {
                this.lenInPacket = 0;
                this.totalLen += 8;
            }
            amountOfDataToWrite = Math.min(len - written, 1016 - this.lenInPacket);
            System.arraycopy(b, off + written, this.buf, this.totalLen, amountOfDataToWrite);
            this.lenInPacket += amountOfDataToWrite;
            this.totalLen += amountOfDataToWrite;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.totalLen + 8 == this.buf.length) {
            this.resizeBuffer();
        }
        if (this.lenInPacket == 1016) {
            this.lenInPacket = 0;
            this.totalLen += 8;
        }
        this.buf[this.totalLen++] = (byte)b;
        ++this.lenInPacket;
    }

    DatagramPacket[] createPackets(InetSocketAddress remoteAddress) {
        if (this.totalLen == 0) {
            return new DatagramPacket[0];
        }
        int maximumPacketSize = 1024;
        int numberOfPackets = this.totalLen / 1024 + 1;
        short numberOfPacketsShort = RPCService.encodeInteger(numberOfPackets);
        DatagramPacket[] packets = new DatagramPacket[numberOfPackets];
        int messageID = (int)(-2.147483648E9 + Math.random() * 2.147483647E9 * 2.0);
        for (int i = 0; i < numberOfPackets; ++i) {
            boolean lastPacket = i == numberOfPackets - 1;
            int offset = lastPacket ? (numberOfPackets - 1) * 1024 + this.lenInPacket : (i + 1) * 1024 - 8;
            NumberUtils.shortToByteArray(RPCService.encodeInteger(i), this.buf, offset);
            NumberUtils.shortToByteArray(numberOfPacketsShort, this.buf, offset + 2);
            NumberUtils.integerToByteArray(messageID, this.buf, offset + 4);
            DatagramPacket packet = lastPacket ? new DatagramPacket(this.buf, i * 1024, this.lenInPacket + 8) : new DatagramPacket(this.buf, i * 1024, 1024);
            packet.setSocketAddress(remoteAddress);
            packets[i] = packet;
        }
        return packets;
    }

    void reset() {
        this.lenInPacket = 0;
        this.totalLen = 0;
    }

    private void resizeBuffer() {
        byte[] newBuf = new byte[this.buf.length * 2];
        System.arraycopy(this.buf, 0, newBuf, 0, this.totalLen);
        this.buf = newBuf;
    }

    private static int getLengthIncludingMetaData(int length) {
        int numberOfPackets = (length + 1016 - 1) / 1016;
        return length + numberOfPackets * 8;
    }
}

