/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.rpc;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;

final class MultiPacketInputStream
extends InputStream {
    private final DatagramPacket[] packets;
    private final long creationTime;
    private int nextPacketToAdd = 0;
    private int nextPacketToRead = 0;
    private byte[] currentBuffer = null;
    private int currentLength = 0;
    private int read = 0;

    MultiPacketInputStream(int numberOfPackets) {
        this.packets = new DatagramPacket[numberOfPackets];
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public int available() {
        System.out.println("Available called");
        if (!this.isComplete()) {
            return 0;
        }
        int available = this.currentLength - this.read;
        for (int i = this.nextPacketToRead; i < this.packets.length; ++i) {
            available += this.packets[i].getLength() - 8;
        }
        return available;
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (!this.moreDataAvailable()) {
            return -1;
        }
        return this.currentBuffer[this.read++];
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (!this.moreDataAvailable()) {
            System.out.println("No data available");
            return -1;
        }
        int r = Math.min(len, this.currentLength - this.read);
        System.arraycopy(this.currentBuffer, this.read, b, off, r);
        this.read += r;
        return r;
    }

    @Override
    public void reset() {
        this.read = 0;
    }

    @Override
    public long skip(long n) {
        if (!this.moreDataAvailable()) {
            return 0L;
        }
        int dataLeftInBuffer = this.currentLength - this.read;
        if (n > (long)dataLeftInBuffer) {
            this.read = this.currentLength;
            return dataLeftInBuffer;
        }
        this.read += (int)n;
        return n;
    }

    int addPacket(int packetNumber, DatagramPacket datagramPacket) {
        if (packetNumber != this.nextPacketToAdd) {
            return this.nextPacketToAdd;
        }
        this.packets[packetNumber] = datagramPacket;
        return this.nextPacketToAdd++;
    }

    long getCreationTime() {
        return this.creationTime;
    }

    boolean isComplete() {
        return this.nextPacketToAdd == this.packets.length;
    }

    private boolean moreDataAvailable() {
        while (this.read == this.currentLength) {
            if (this.nextPacketToRead == this.packets.length) {
                return false;
            }
            DatagramPacket dp = this.packets[this.nextPacketToRead++];
            this.currentBuffer = dp.getData();
            this.currentLength = dp.getLength() - 8;
            this.read = 0;
        }
        return true;
    }
}

