/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.hbase;

import eu.stratosphere.core.io.LocatableInputSplit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TableInputSplit
extends LocatableInputSplit {
    private byte[] tableName;
    private byte[] startRow;
    private byte[] endRow;

    TableInputSplit(int splitNumber, String[] hostnames, byte[] tableName, byte[] startRow, byte[] endRow) {
        super(splitNumber, hostnames);
        this.tableName = tableName;
        this.startRow = startRow;
        this.endRow = endRow;
    }

    public TableInputSplit() {
        this.tableName = null;
        this.startRow = null;
        this.endRow = null;
    }

    public byte[] getTableName() {
        return this.tableName;
    }

    public byte[] getStartRow() {
        return this.startRow;
    }

    public byte[] getEndRow() {
        return this.endRow;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        if (this.tableName == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.tableName.length);
            out.write(this.tableName);
        }
        if (this.startRow == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.startRow.length);
            out.write(this.startRow);
        }
        if (this.endRow == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.endRow.length);
            out.write(this.endRow);
        }
    }

    public void read(DataInput in) throws IOException {
        super.read(in);
        int len = in.readInt();
        if (len >= 0) {
            this.tableName = new byte[len];
            in.readFully(this.tableName);
        }
        if ((len = in.readInt()) >= 0) {
            this.startRow = new byte[len];
            in.readFully(this.startRow);
        }
        if ((len = in.readInt()) >= 0) {
            this.endRow = new byte[len];
            in.readFully(this.endRow);
        }
    }
}

