/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.hbase;

import eu.stratosphere.addons.hbase.TableInputSplit;
import eu.stratosphere.addons.hbase.common.HBaseKey;
import eu.stratosphere.addons.hbase.common.HBaseResult;
import eu.stratosphere.addons.hbase.common.HBaseUtil;
import eu.stratosphere.api.common.io.InputFormat;
import eu.stratosphere.api.common.io.statistics.BaseStatistics;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.OperatingSystem;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.StringUtils;

public class TableInputFormat
implements InputFormat<Record, TableInputSplit> {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(TableInputFormat.class);
    private HTable table;
    private Scan scan;
    private TableRecordReader tableRecordReader;
    private boolean endReached = false;
    public static final String INPUT_TABLE = "hbase.inputtable";
    public static final String CONFIG_LOCATION = "hbase.config.location";
    public static final String SCAN = "hbase.scan";
    public static final String SCAN_COLUMN_FAMILY = "hbase.scan.column.family";
    public static final String SCAN_COLUMNS = "hbase.scan.columns";
    public static final String SCAN_TIMESTAMP = "hbase.scan.timestamp";
    public static final String SCAN_TIMERANGE_START = "hbase.scan.timerange.start";
    public static final String SCAN_TIMERANGE_END = "hbase.scan.timerange.end";
    public static final String SCAN_MAXVERSIONS = "hbase.scan.maxversions";
    public static final String SCAN_CACHEBLOCKS = "hbase.scan.cacheblocks";
    public static final String SCAN_CACHEDROWS = "hbase.scan.cachedrows";
    protected HBaseKey hbaseKey;
    protected HBaseResult hbaseResult;
    private org.apache.hadoop.conf.Configuration hConf;

    public void configure(Configuration parameters) {
        HTable table = this.createTable(parameters);
        this.setTable(table);
        Scan scan = this.createScanner(parameters);
        this.setScan(scan);
    }

    protected Scan createScanner(Configuration parameters) {
        Scan scan = null;
        if (parameters.getString(SCAN, null) != null) {
            try {
                scan = HBaseUtil.convertStringToScan(parameters.getString(SCAN, null));
            }
            catch (IOException e) {
                LOG.error((Object)"An error occurred.", (Throwable)e);
            }
        } else {
            try {
                scan = new Scan();
                if (parameters.getString(SCAN_COLUMN_FAMILY, null) != null) {
                    scan.addFamily(Bytes.toBytes((String)parameters.getString(SCAN_COLUMN_FAMILY, null)));
                }
                if (parameters.getString(SCAN_TIMESTAMP, null) != null) {
                    scan.setTimeStamp(Long.parseLong(parameters.getString(SCAN_TIMESTAMP, null)));
                }
                if (parameters.getString(SCAN_TIMERANGE_START, null) != null && parameters.getString(SCAN_TIMERANGE_END, null) != null) {
                    scan.setTimeRange(Long.parseLong(parameters.getString(SCAN_TIMERANGE_START, null)), Long.parseLong(parameters.getString(SCAN_TIMERANGE_END, null)));
                }
                if (parameters.getString(SCAN_MAXVERSIONS, null) != null) {
                    scan.setMaxVersions(Integer.parseInt(parameters.getString(SCAN_MAXVERSIONS, null)));
                }
                if (parameters.getString(SCAN_CACHEDROWS, null) != null) {
                    scan.setCaching(Integer.parseInt(parameters.getString(SCAN_CACHEDROWS, null)));
                }
                scan.setCacheBlocks(parameters.getBoolean(SCAN_CACHEBLOCKS, false));
            }
            catch (Exception e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            }
        }
        return scan;
    }

    protected HTable createTable(Configuration parameters) {
        String configLocation = parameters.getString(CONFIG_LOCATION, null);
        LOG.info((Object)("Got config location: " + configLocation));
        if (configLocation != null) {
            org.apache.hadoop.conf.Configuration dummyConf = new org.apache.hadoop.conf.Configuration();
            if (OperatingSystem.isWindows()) {
                dummyConf.addResource(new Path("file:/" + configLocation));
            } else {
                dummyConf.addResource(new Path("file://" + configLocation));
            }
            this.hConf = HBaseConfiguration.create((org.apache.hadoop.conf.Configuration)dummyConf);
            LOG.info((Object)("hbase master: " + this.hConf.get("hbase.master")));
            LOG.info((Object)("zookeeper quorum: " + this.hConf.get("hbase.zookeeper.quorum")));
        }
        String tableName = parameters.getString(INPUT_TABLE, "");
        try {
            return new HTable(this.hConf, tableName);
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            return null;
        }
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) {
        return null;
    }

    public boolean reachedEnd() throws IOException {
        return this.endReached;
    }

    protected boolean nextResult() throws IOException {
        if (this.tableRecordReader == null) {
            throw new IOException("No table record reader provided!");
        }
        try {
            if (!this.tableRecordReader.nextKeyValue()) {
                this.endReached = true;
                return false;
            }
            ImmutableBytesWritable currentKey = this.tableRecordReader.getCurrentKey();
            Result currentValue = this.tableRecordReader.getCurrentValue();
            this.hbaseKey.setWritable(currentKey);
            this.hbaseResult.setResult(currentValue);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Table reader has been interrupted", (Throwable)e);
            throw new IOException(e);
        }
        return true;
    }

    public Record nextRecord(Record record) throws IOException {
        if (this.nextResult()) {
            this.mapResultToRecord(record, this.hbaseKey, this.hbaseResult);
            return record;
        }
        return null;
    }

    public void mapResultToRecord(Record record, HBaseKey key, HBaseResult result) {
        record.setField(0, (Value)key);
        record.setField(1, (Value)result);
    }

    public void close() throws IOException {
        this.tableRecordReader.close();
    }

    public void open(TableInputSplit split) throws IOException {
        if (split == null) {
            throw new IOException("Input split is null!");
        }
        if (this.table == null) {
            throw new IOException("No HTable provided!");
        }
        if (this.scan == null) {
            throw new IOException("No Scan instance provided");
        }
        this.tableRecordReader = new TableRecordReader();
        this.tableRecordReader.setHTable(this.table);
        Scan sc = new Scan(this.scan);
        sc.setStartRow(split.getStartRow());
        LOG.info((Object)("split start row: " + new String(split.getStartRow())));
        sc.setStopRow(split.getEndRow());
        LOG.info((Object)("split end row: " + new String(split.getEndRow())));
        this.tableRecordReader.setScan(sc);
        this.tableRecordReader.restart(split.getStartRow());
        this.hbaseKey = new HBaseKey();
        this.hbaseResult = new HBaseResult();
        this.endReached = false;
    }

    public TableInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        if (this.table == null) {
            throw new IOException("No table was provided.");
        }
        Pair keys = this.table.getStartEndKeys();
        if (keys == null || keys.getFirst() == null || ((byte[][])keys.getFirst()).length == 0) {
            throw new IOException("Expecting at least one region.");
        }
        int count = 0;
        ArrayList<TableInputSplit> splits = new ArrayList<TableInputSplit>(((byte[][])keys.getFirst()).length);
        for (int i = 0; i < ((byte[][])keys.getFirst()).length; ++i) {
            if (!TableInputFormat.includeRegionInSplit(((byte[][])keys.getFirst())[i], ((byte[][])keys.getSecond())[i])) continue;
            String regionLocation = this.table.getRegionLocation(((byte[][])keys.getFirst())[i], false).getHostnamePort();
            byte[] startRow = this.scan.getStartRow();
            byte[] stopRow = this.scan.getStopRow();
            if (startRow.length != 0 && ((byte[][])keys.getSecond())[i].length != 0 && Bytes.compareTo((byte[])startRow, (byte[])((byte[][])keys.getSecond())[i]) >= 0 || stopRow.length != 0 && Bytes.compareTo((byte[])stopRow, (byte[])((byte[][])keys.getFirst())[i]) <= 0) continue;
            byte[] splitStart = startRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getFirst())[i], (byte[])startRow) >= 0 ? ((byte[][])keys.getFirst())[i] : startRow;
            byte[] splitStop = (stopRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getSecond())[i], (byte[])stopRow) <= 0) && ((byte[][])keys.getSecond())[i].length > 0 ? ((byte[][])keys.getSecond())[i] : stopRow;
            TableInputSplit split = new TableInputSplit(splits.size(), new String[]{regionLocation}, this.table.getTableName(), splitStart, splitStop);
            splits.add(split);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("getSplits: split -> " + count++ + " -> " + (Object)((Object)split)));
        }
        return splits.toArray(new TableInputSplit[0]);
    }

    private static boolean includeRegionInSplit(byte[] startKey, byte[] endKey) {
        return true;
    }

    public Class<TableInputSplit> getInputSplitType() {
        return TableInputSplit.class;
    }

    public void setTable(HTable table) {
        this.table = table;
    }

    public HTable getTable() {
        return this.table;
    }

    public void setScan(Scan scan) {
        this.scan = scan;
    }

    public Scan getScan() {
        return this.scan;
    }
}

