/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.addons.hbase;

import eu.stratosphere.api.common.io.OutputFormat;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.types.Record;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;

public abstract class GenericTableOutputFormat
implements OutputFormat<Record> {
    private static final long serialVersionUID = 1L;
    public static final String JT_ID_KEY = "pact.hbase.jtkey";
    public static final String JOB_ID_KEY = "pact.job.id";
    private RecordWriter<ImmutableBytesWritable, KeyValue> writer;
    private Configuration config;
    private org.apache.hadoop.conf.Configuration hadoopConfig;
    private TaskAttemptContext context;
    private String jtID;
    private int jobId;

    public void configure(Configuration parameters) {
        this.config = parameters;
        this.jtID = parameters.getString(JT_ID_KEY, null);
        if (this.jtID == null) {
            throw new RuntimeException("Missing JT_ID entry in hbase config.");
        }
        this.jobId = parameters.getInteger(JOB_ID_KEY, -1);
        if (this.jobId < 0) {
            throw new RuntimeException("Missing or invalid job id in input config.");
        }
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        this.hadoopConfig = this.getHadoopConfig(this.config);
        TaskAttemptID attemptId = new TaskAttemptID(this.jtID, this.jobId, TaskType.MAP, taskNumber - 1, 0);
        this.context = new TaskAttemptContextImpl(this.hadoopConfig, attemptId);
        HFileOutputFormat outFormat = new HFileOutputFormat();
        try {
            this.writer = outFormat.getRecordWriter(this.context);
        }
        catch (InterruptedException iex) {
            throw new IOException("Opening the writer was interrupted.", iex);
        }
    }

    public void close() throws IOException {
        RecordWriter<ImmutableBytesWritable, KeyValue> writer = this.writer;
        this.writer = null;
        if (writer != null) {
            try {
                writer.close(this.context);
            }
            catch (InterruptedException iex) {
                throw new IOException("Closing was interrupted.", iex);
            }
        }
    }

    public void collectKeyValue(KeyValue kv) throws IOException {
        try {
            this.writer.write(null, (Object)kv);
        }
        catch (InterruptedException iex) {
            throw new IOException("Write request was interrupted.", iex);
        }
    }

    public abstract org.apache.hadoop.conf.Configuration getHadoopConfig(Configuration var1);
}

