/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.hadoopcompatibility.datatypes;

import eu.stratosphere.types.Value;
import eu.stratosphere.util.InstantiationUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class WritableWrapper<T extends Writable>
implements Value {
    private static final long serialVersionUID = 2L;
    private T wrapped;
    private String wrappedType;
    private ClassLoader cl;

    public WritableWrapper() {
    }

    public WritableWrapper(T toWrap) {
        this.wrapped = toWrap;
        this.wrappedType = toWrap.getClass().getCanonicalName();
    }

    public T value() {
        return this.wrapped;
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.wrappedType);
        this.wrapped.write(out);
    }

    public void read(DataInput in) throws IOException {
        if (this.cl == null) {
            this.cl = Thread.currentThread().getContextClassLoader();
        }
        this.wrappedType = in.readUTF();
        try {
            Class<Writable> wrClass = Class.forName(this.wrappedType, true, this.cl).asSubclass(Writable.class);
            this.wrapped = (Writable)InstantiationUtil.instantiate(wrClass, Writable.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error creating the WritableWrapper", e);
        }
        this.wrapped.readFields(in);
    }
}

