/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.hadoopcompatibility.datatypes;

import eu.stratosphere.hadoopcompatibility.datatypes.HadoopTypeConverter;
import eu.stratosphere.types.BooleanValue;
import eu.stratosphere.types.ByteValue;
import eu.stratosphere.types.DoubleValue;
import eu.stratosphere.types.FloatValue;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.LongValue;
import eu.stratosphere.types.NullValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;

public class DefaultHadoopTypeConverter<K, V>
implements HadoopTypeConverter<K, V> {
    private static final long serialVersionUID = 1L;

    @Override
    public void convert(Record stratosphereRecord, K hadoopKey, V hadoopValue) {
        stratosphereRecord.setField(0, this.convert(hadoopKey));
        stratosphereRecord.setField(1, this.convert(hadoopValue));
    }

    protected Value convert(Object hadoopType) {
        if (hadoopType instanceof LongWritable) {
            return new LongValue(((LongWritable)hadoopType).get());
        }
        if (hadoopType instanceof Text) {
            return new StringValue((CharSequence)((Text)hadoopType).toString());
        }
        if (hadoopType instanceof IntWritable) {
            return new IntValue(((IntWritable)hadoopType).get());
        }
        if (hadoopType instanceof FloatWritable) {
            return new FloatValue(((FloatWritable)hadoopType).get());
        }
        if (hadoopType instanceof DoubleWritable) {
            return new DoubleValue(((DoubleWritable)hadoopType).get());
        }
        if (hadoopType instanceof BooleanWritable) {
            return new BooleanValue(((BooleanWritable)hadoopType).get());
        }
        if (hadoopType instanceof ByteWritable) {
            return new ByteValue(((ByteWritable)hadoopType).get());
        }
        if (hadoopType instanceof NullWritable) {
            return NullValue.getInstance();
        }
        throw new RuntimeException("Unable to convert Hadoop type (" + hadoopType.getClass().getCanonicalName() + ") to Stratosphere.");
    }
}

