/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.hadoopcompatibility;

import eu.stratosphere.core.io.InputSplit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.mapred.JobConf;

public class HadoopInputSplitWrapper
implements InputSplit {
    public transient org.apache.hadoop.mapred.InputSplit hadoopInputSplit;
    public JobConf jobConf;
    private int splitNumber;
    private String hadoopInputSplitTypeName;

    public org.apache.hadoop.mapred.InputSplit getHadoopInputSplit() {
        return this.hadoopInputSplit;
    }

    public HadoopInputSplitWrapper() {
    }

    public HadoopInputSplitWrapper(org.apache.hadoop.mapred.InputSplit hInputSplit, JobConf jobconf) {
        this.hadoopInputSplit = hInputSplit;
        this.hadoopInputSplitTypeName = hInputSplit.getClass().getName();
        this.jobConf = jobconf;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.splitNumber);
        out.writeUTF(this.hadoopInputSplitTypeName);
        this.hadoopInputSplit.write(out);
    }

    public void read(DataInput in) throws IOException {
        this.splitNumber = in.readInt();
        this.hadoopInputSplitTypeName = in.readUTF();
        if (this.hadoopInputSplit == null) {
            try {
                Class<Writable> inputSplit = Class.forName(this.hadoopInputSplitTypeName).asSubclass(Writable.class);
                this.hadoopInputSplit = (org.apache.hadoop.mapred.InputSplit)WritableFactories.newInstance(inputSplit);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create InputSplit", e);
            }
        }
        this.hadoopInputSplit.readFields(in);
    }

    public int getSplitNumber() {
        return this.splitNumber;
    }

    public void setSplitNumber(int splitNumber) {
        this.splitNumber = splitNumber;
    }

    public void setHadoopInputSplit(org.apache.hadoop.mapred.InputSplit hadoopInputSplit) {
        this.hadoopInputSplit = hadoopInputSplit;
    }
}

