/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.hadoopcompatibility.datatypes;

import eu.stratosphere.hadoopcompatibility.datatypes.StratosphereTypeConverter;
import eu.stratosphere.types.BooleanValue;
import eu.stratosphere.types.ByteValue;
import eu.stratosphere.types.DoubleValue;
import eu.stratosphere.types.FloatValue;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.LongValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class DefaultStratosphereTypeConverter<K, V>
implements StratosphereTypeConverter<K, V> {
    private static final long serialVersionUID = 1L;
    private Class<K> keyClass;
    private Class<V> valueClass;

    public DefaultStratosphereTypeConverter(Class<K> keyClass, Class<V> valueClass) {
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    @Override
    public K convertKey(Record stratosphereRecord) {
        if (stratosphereRecord.getNumFields() > 0) {
            return this.convert(stratosphereRecord, 0, this.keyClass);
        }
        return null;
    }

    @Override
    public V convertValue(Record stratosphereRecord) {
        if (stratosphereRecord.getNumFields() > 1) {
            return this.convert(stratosphereRecord, 1, this.valueClass);
        }
        return null;
    }

    private <T> T convert(Record stratosphereType, int pos, Class<T> hadoopType) {
        if (hadoopType == LongWritable.class) {
            return (T)new LongWritable(((LongValue)stratosphereType.getField(pos, LongValue.class)).getValue());
        }
        if (hadoopType == Text.class) {
            return (T)new Text(((StringValue)stratosphereType.getField(pos, StringValue.class)).getValue());
        }
        if (hadoopType == IntWritable.class) {
            return (T)new IntWritable(((IntValue)stratosphereType.getField(pos, IntValue.class)).getValue());
        }
        if (hadoopType == FloatWritable.class) {
            return (T)new FloatWritable(((FloatValue)stratosphereType.getField(pos, FloatValue.class)).getValue());
        }
        if (hadoopType == DoubleWritable.class) {
            return (T)new DoubleWritable(((DoubleValue)stratosphereType.getField(pos, DoubleValue.class)).getValue());
        }
        if (hadoopType == BooleanWritable.class) {
            return (T)new BooleanWritable(((BooleanValue)stratosphereType.getField(pos, BooleanValue.class)).getValue());
        }
        if (hadoopType == ByteWritable.class) {
            return (T)new ByteWritable(((ByteValue)stratosphereType.getField(pos, ByteValue.class)).getValue());
        }
        throw new RuntimeException("Unable to convert Stratosphere type (" + stratosphereType.getClass().getCanonicalName() + ") to Hadoop.");
    }
}

