/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.hadoopcompatibility;

import eu.stratosphere.api.common.io.OutputFormat;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.hadoopcompatibility.DummyHadoopProgressable;
import eu.stratosphere.hadoopcompatibility.DummyHadoopReporter;
import eu.stratosphere.hadoopcompatibility.FileOutputCommitterWrapper;
import eu.stratosphere.hadoopcompatibility.HadoopConfiguration;
import eu.stratosphere.hadoopcompatibility.datatypes.StratosphereTypeConverter;
import eu.stratosphere.types.Record;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class HadoopOutputFormatWrapper<K, V>
implements OutputFormat<Record> {
    private static final long serialVersionUID = 1L;
    public JobConf jobConf;
    public org.apache.hadoop.mapred.OutputFormat<K, V> hadoopOutputFormat;
    private String hadoopOutputFormatName;
    public RecordWriter<K, V> recordWriter;
    public StratosphereTypeConverter<K, V> converter;
    public FileOutputCommitterWrapper fileOutputCommitterWrapper;

    public HadoopOutputFormatWrapper(org.apache.hadoop.mapred.OutputFormat<K, V> hadoopFormat, JobConf job, StratosphereTypeConverter<K, V> conv) {
        this.hadoopOutputFormat = hadoopFormat;
        this.hadoopOutputFormatName = hadoopFormat.getClass().getName();
        this.converter = conv;
        this.fileOutputCommitterWrapper = new FileOutputCommitterWrapper();
        HadoopConfiguration.mergeHadoopConf(job);
        this.jobConf = job;
    }

    public void configure(Configuration parameters) {
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        this.fileOutputCommitterWrapper.setupJob(this.jobConf);
        if (Integer.toString(taskNumber + 1).length() > 6) {
            throw new IOException("task id too large");
        }
        this.jobConf.set("mapred.task.id", "attempt__0000_r_" + String.format("%" + (6 - Integer.toString(taskNumber + 1).length()) + "s", " ").replace(" ", "0") + Integer.toString(taskNumber + 1) + "_0");
        this.jobConf.set("mapreduce.task.output.dir", this.fileOutputCommitterWrapper.getTempTaskOutputPath(this.jobConf, TaskAttemptID.forName((String)this.jobConf.get("mapred.task.id"))).toString());
        this.recordWriter = this.hadoopOutputFormat.getRecordWriter(null, this.jobConf, Integer.toString(taskNumber + 1), (Progressable)new DummyHadoopProgressable());
    }

    public void writeRecord(Record record) throws IOException {
        K key = this.converter.convertKey(record);
        V value = this.converter.convertValue(record);
        this.recordWriter.write(key, value);
    }

    public void close() throws IOException {
        this.recordWriter.close((Reporter)new DummyHadoopReporter());
        if (this.fileOutputCommitterWrapper.needsTaskCommit(this.jobConf, TaskAttemptID.forName((String)this.jobConf.get("mapred.task.id")))) {
            this.fileOutputCommitterWrapper.commitTask(this.jobConf, TaskAttemptID.forName((String)this.jobConf.get("mapred.task.id")));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.hadoopOutputFormatName);
        this.jobConf.write((DataOutput)out);
        out.writeObject(this.converter);
        out.writeObject(this.fileOutputCommitterWrapper);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.hadoopOutputFormatName = in.readUTF();
        if (this.jobConf == null) {
            this.jobConf = new JobConf();
        }
        this.jobConf.readFields((DataInput)in);
        try {
            this.hadoopOutputFormat = (org.apache.hadoop.mapred.OutputFormat)Class.forName(this.hadoopOutputFormatName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate the hadoop output format", e);
        }
        ReflectionUtils.setConf(this.hadoopOutputFormat, (org.apache.hadoop.conf.Configuration)this.jobConf);
        this.converter = (StratosphereTypeConverter)in.readObject();
        this.fileOutputCommitterWrapper = (FileOutputCommitterWrapper)in.readObject();
    }

    public void setJobConf(JobConf job) {
        this.jobConf = job;
    }

    public JobConf getJobConf() {
        return this.jobConf;
    }

    public org.apache.hadoop.mapred.OutputFormat<K, V> getHadoopOutputFormat() {
        return this.hadoopOutputFormat;
    }

    public void setHadoopOutputFormat(org.apache.hadoop.mapred.OutputFormat<K, V> hadoopOutputFormat) {
        this.hadoopOutputFormat = hadoopOutputFormat;
    }
}

