/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.hadoopcompatibility;

import com.google.common.base.Preconditions;
import eu.stratosphere.api.common.operators.GenericDataSource;
import eu.stratosphere.hadoopcompatibility.HadoopInputFormatWrapper;
import eu.stratosphere.hadoopcompatibility.datatypes.DefaultHadoopTypeConverter;
import eu.stratosphere.hadoopcompatibility.datatypes.HadoopTypeConverter;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;

public class HadoopDataSource<K, V>
extends GenericDataSource<HadoopInputFormatWrapper<K, V>> {
    private static String DEFAULT_NAME = "<Unnamed Hadoop Data Source>";
    private JobConf jobConf;

    public HadoopDataSource(InputFormat<K, V> hadoopFormat, JobConf jobConf, String name, HadoopTypeConverter<K, V> conv) {
        super(new HadoopInputFormatWrapper<K, V>(hadoopFormat, jobConf, conv), name);
        Preconditions.checkNotNull(hadoopFormat);
        Preconditions.checkNotNull((Object)jobConf);
        Preconditions.checkNotNull(conv);
        this.name = name;
        this.jobConf = jobConf;
    }

    public HadoopDataSource(InputFormat<K, V> hadoopFormat, JobConf jobConf, String name) {
        this(hadoopFormat, jobConf, name, new DefaultHadoopTypeConverter());
    }

    public HadoopDataSource(InputFormat<K, V> hadoopFormat, JobConf jobConf) {
        this(hadoopFormat, jobConf, DEFAULT_NAME);
    }

    public HadoopDataSource(InputFormat<K, V> hadoopFormat) {
        this(hadoopFormat, new JobConf(), DEFAULT_NAME);
    }

    public JobConf getJobConf() {
        return this.jobConf;
    }
}

