/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.hadoopcompatibility;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.compiler.contextcheck.Validatable;
import eu.stratosphere.hadoopcompatibility.HadoopOutputFormatWrapper;
import eu.stratosphere.hadoopcompatibility.datatypes.DefaultStratosphereTypeConverter;
import eu.stratosphere.hadoopcompatibility.datatypes.StratosphereTypeConverter;
import java.util.List;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;

public class HadoopDataSink<K, V>
extends GenericDataSink
implements Validatable {
    private static String DEFAULT_NAME = "<Unnamed Hadoop Data Sink>";
    private JobConf jobConf;

    public HadoopDataSink(OutputFormat<K, V> hadoopFormat, JobConf jobConf, String name, Operator input, StratosphereTypeConverter<K, V> conv, Class<K> keyClass, Class<V> valueClass) {
        this(hadoopFormat, jobConf, name, (List<Operator>)ImmutableList.of((Object)input), conv, keyClass, valueClass);
    }

    public HadoopDataSink(OutputFormat<K, V> hadoopFormat, JobConf jobConf, String name, Operator input, Class<K> keyClass, Class<V> valueClass) {
        this(hadoopFormat, jobConf, name, input, new DefaultStratosphereTypeConverter<K, V>(keyClass, valueClass), keyClass, valueClass);
    }

    public HadoopDataSink(OutputFormat<K, V> hadoopFormat, JobConf jobConf, Operator input, Class<K> keyClass, Class<V> valueClass) {
        this(hadoopFormat, jobConf, DEFAULT_NAME, input, new DefaultStratosphereTypeConverter<K, V>(keyClass, valueClass), keyClass, valueClass);
    }

    public HadoopDataSink(OutputFormat<K, V> hadoopFormat, Operator input, Class<K> keyClass, Class<V> valueClass) {
        this(hadoopFormat, new JobConf(), DEFAULT_NAME, input, new DefaultStratosphereTypeConverter<K, V>(keyClass, valueClass), keyClass, valueClass);
    }

    public HadoopDataSink(OutputFormat<K, V> hadoopFormat, JobConf jobConf, String name, List<Operator> input, StratosphereTypeConverter<K, V> conv, Class<K> keyClass, Class<V> valueClass) {
        super(new HadoopOutputFormatWrapper<K, V>(hadoopFormat, jobConf, conv), input, name);
        Preconditions.checkNotNull(hadoopFormat);
        Preconditions.checkNotNull((Object)jobConf);
        this.name = name;
        this.jobConf = jobConf;
        jobConf.setOutputKeyClass(keyClass);
        jobConf.setOutputValueClass(valueClass);
    }

    public HadoopDataSink(OutputFormat<K, V> hadoopFormat, JobConf jobConf, String name, List<Operator> input, Class<K> keyClass, Class<V> valueClass) {
        this(hadoopFormat, jobConf, name, input, new DefaultStratosphereTypeConverter<K, V>(keyClass, valueClass), keyClass, valueClass);
    }

    public HadoopDataSink(OutputFormat<K, V> hadoopFormat, JobConf jobConf, List<Operator> input, Class<K> keyClass, Class<V> valueClass) {
        this(hadoopFormat, jobConf, DEFAULT_NAME, input, new DefaultStratosphereTypeConverter<K, V>(keyClass, valueClass), keyClass, valueClass);
    }

    public HadoopDataSink(OutputFormat<K, V> hadoopFormat, List<Operator> input, Class<K> keyClass, Class<V> valueClass) {
        this(hadoopFormat, new JobConf(), DEFAULT_NAME, input, new DefaultStratosphereTypeConverter<K, V>(keyClass, valueClass), keyClass, valueClass);
    }

    public JobConf getJobConf() {
        return this.jobConf;
    }

    public void check() {
        Preconditions.checkNotNull((Object)FileOutputFormat.getOutputPath((JobConf)this.jobConf), (Object)"The HadoopDataSink currently expects a correct outputPath.");
    }
}

