/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.hadoopcompatibility;

import eu.stratosphere.api.common.io.InputFormat;
import eu.stratosphere.api.common.io.statistics.BaseStatistics;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.hadoopcompatibility.DummyHadoopReporter;
import eu.stratosphere.hadoopcompatibility.HadoopConfiguration;
import eu.stratosphere.hadoopcompatibility.HadoopInputSplitWrapper;
import eu.stratosphere.hadoopcompatibility.datatypes.HadoopTypeConverter;
import eu.stratosphere.types.Record;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

public class HadoopInputFormatWrapper<K, V>
implements InputFormat<Record, HadoopInputSplitWrapper> {
    private static final long serialVersionUID = 1L;
    public org.apache.hadoop.mapred.InputFormat<K, V> hadoopInputFormat;
    public HadoopTypeConverter<K, V> converter;
    private String hadoopInputFormatName;
    public JobConf jobConf;
    public transient K key;
    public transient V value;
    public RecordReader<K, V> recordReader;
    private boolean fetched = false;
    private boolean hasNext;

    public HadoopInputFormatWrapper() {
    }

    public HadoopInputFormatWrapper(org.apache.hadoop.mapred.InputFormat<K, V> hadoopInputFormat, JobConf job, HadoopTypeConverter<K, V> conv) {
        this.hadoopInputFormat = hadoopInputFormat;
        this.hadoopInputFormatName = hadoopInputFormat.getClass().getName();
        this.converter = conv;
        HadoopConfiguration.mergeHadoopConf(job);
        this.jobConf = job;
    }

    public void configure(Configuration parameters) {
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) throws IOException {
        return null;
    }

    public HadoopInputSplitWrapper[] createInputSplits(int minNumSplits) throws IOException {
        InputSplit[] splitArray = this.hadoopInputFormat.getSplits(this.jobConf, minNumSplits);
        HadoopInputSplitWrapper[] hiSplit = new HadoopInputSplitWrapper[splitArray.length];
        for (int i = 0; i < splitArray.length; ++i) {
            hiSplit[i] = new HadoopInputSplitWrapper(splitArray[i], this.jobConf);
        }
        return hiSplit;
    }

    public Class<? extends HadoopInputSplitWrapper> getInputSplitType() {
        return HadoopInputSplitWrapper.class;
    }

    public void open(HadoopInputSplitWrapper split) throws IOException {
        this.recordReader = this.hadoopInputFormat.getRecordReader(split.getHadoopInputSplit(), this.jobConf, (Reporter)new DummyHadoopReporter());
        this.key = this.recordReader.createKey();
        this.value = this.recordReader.createValue();
        this.fetched = false;
    }

    private void fetchNext() throws IOException {
        this.hasNext = this.recordReader.next(this.key, this.value);
        this.fetched = true;
    }

    public boolean reachedEnd() throws IOException {
        if (!this.fetched) {
            this.fetchNext();
        }
        return !this.hasNext;
    }

    public Record nextRecord(Record record) throws IOException {
        if (!this.fetched) {
            this.fetchNext();
        }
        if (!this.hasNext) {
            return null;
        }
        this.converter.convert(record, this.key, this.value);
        this.fetched = false;
        return record;
    }

    public void close() throws IOException {
        this.recordReader.close();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.hadoopInputFormatName);
        this.jobConf.write((DataOutput)out);
        out.writeObject(this.converter);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.hadoopInputFormatName = in.readUTF();
        if (this.jobConf == null) {
            this.jobConf = new JobConf();
        }
        this.jobConf.readFields((DataInput)in);
        try {
            this.hadoopInputFormat = (org.apache.hadoop.mapred.InputFormat)Class.forName(this.hadoopInputFormatName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate the hadoop input format", e);
        }
        ReflectionUtils.setConf(this.hadoopInputFormat, (org.apache.hadoop.conf.Configuration)this.jobConf);
        this.converter = (HadoopTypeConverter)in.readObject();
    }

    public void setJobConf(JobConf job) {
        this.jobConf = job;
    }

    public org.apache.hadoop.mapred.InputFormat<K, V> getHadoopInputFormat() {
        return this.hadoopInputFormat;
    }

    public void setHadoopInputFormat(org.apache.hadoop.mapred.InputFormat<K, V> hadoopInputFormat) {
        this.hadoopInputFormat = hadoopInputFormat;
    }

    public JobConf getJobConf() {
        return this.jobConf;
    }
}

