/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.hadoopcompatibility;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.util.StringUtils;

public class FileOutputCommitterWrapper
extends FileOutputCommitter
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String SUCCESSFUL_JOB_OUTPUT_DIR_MARKER = "mapreduce.fileoutputcommitter.marksuccessfuljobs";

    public void setupJob(JobConf conf) throws IOException {
        Path tmpDir;
        FileSystem fileSys;
        Path outputPath = FileOutputFormat.getOutputPath((JobConf)conf);
        if (outputPath != null && !(fileSys = (tmpDir = new Path(outputPath, "_temporary")).getFileSystem((Configuration)conf)).mkdirs(tmpDir)) {
            LOG.error((Object)("Mkdirs failed to create " + tmpDir.toString()));
        }
    }

    private static boolean getOutputDirMarking(JobConf conf) {
        return conf.getBoolean(SUCCESSFUL_JOB_OUTPUT_DIR_MARKER, true);
    }

    private void markSuccessfulOutputDir(JobConf conf) throws IOException {
        FileSystem fileSys;
        Path outputPath = FileOutputFormat.getOutputPath((JobConf)conf);
        if (outputPath != null && (fileSys = outputPath.getFileSystem((Configuration)conf)).exists(outputPath)) {
            Path filePath = new Path(outputPath, "_SUCCESS");
            fileSys.create(filePath).close();
        }
    }

    private Path getFinalPath(Path jobOutputDir, Path taskOutput, Path taskOutputPath) throws IOException {
        URI relativePath;
        URI taskOutputUri = taskOutput.toUri();
        if (taskOutputUri == (relativePath = taskOutputPath.toUri().relativize(taskOutputUri))) {
            throw new IOException("Can not get the relative path: base = " + taskOutputPath + " child = " + taskOutput);
        }
        if (relativePath.getPath().length() > 0) {
            return new Path(jobOutputDir, relativePath.getPath());
        }
        return jobOutputDir;
    }

    private void moveTaskOutputs(JobConf conf, TaskAttemptID taskAttemptID, FileSystem fs, Path jobOutputDir, Path taskOutput) throws IOException {
        if (fs.isFile(taskOutput)) {
            Path finalOutputPath = this.getFinalPath(jobOutputDir, taskOutput, this.getTempTaskOutputPath(conf, taskAttemptID));
            if (!fs.rename(taskOutput, finalOutputPath)) {
                if (!fs.delete(finalOutputPath, true)) {
                    throw new IOException("Failed to delete earlier output of task: " + taskAttemptID);
                }
                if (!fs.rename(taskOutput, finalOutputPath)) {
                    throw new IOException("Failed to save output of task: " + taskAttemptID);
                }
            }
            LOG.debug((Object)("Moved " + taskOutput + " to " + finalOutputPath));
        } else if (fs.getFileStatus(taskOutput).isDir()) {
            FileStatus[] paths = fs.listStatus(taskOutput);
            Path finalOutputPath = this.getFinalPath(jobOutputDir, taskOutput, this.getTempTaskOutputPath(conf, taskAttemptID));
            fs.mkdirs(finalOutputPath);
            if (paths != null) {
                for (FileStatus path : paths) {
                    this.moveTaskOutputs(conf, taskAttemptID, fs, jobOutputDir, path.getPath());
                }
            }
        }
    }

    public void commitTask(JobConf conf, TaskAttemptID taskAttemptID) throws IOException {
        FileSystem fs;
        Path taskOutputPath = this.getTempTaskOutputPath(conf, taskAttemptID);
        if (taskOutputPath != null && (fs = taskOutputPath.getFileSystem((Configuration)conf)).exists(taskOutputPath)) {
            Path jobOutputPath = taskOutputPath.getParent().getParent();
            this.moveTaskOutputs(conf, taskAttemptID, fs, jobOutputPath, taskOutputPath);
            if (!fs.delete(taskOutputPath, true)) {
                LOG.info((Object)("Failed to delete the temporary output directory of task: " + taskAttemptID + " - " + taskOutputPath));
            }
            LOG.info((Object)("Saved output of task '" + taskAttemptID + "' to " + jobOutputPath));
        }
    }

    public boolean needsTaskCommit(JobConf conf, TaskAttemptID taskAttemptID) throws IOException {
        FileSystem fs;
        Path taskOutputPath = this.getTempTaskOutputPath(conf, taskAttemptID);
        if (taskOutputPath != null && (fs = taskOutputPath.getFileSystem((Configuration)conf)).exists(taskOutputPath)) {
            return true;
        }
        return false;
    }

    public Path getTempTaskOutputPath(JobConf conf, TaskAttemptID taskAttemptID) {
        Path outputPath = FileOutputFormat.getOutputPath((JobConf)conf);
        if (outputPath != null) {
            Path p = new Path(outputPath, "_temporary/_" + taskAttemptID.toString());
            try {
                FileSystem fs = p.getFileSystem((Configuration)conf);
                return p.makeQualified(fs);
            }
            catch (IOException ie) {
                LOG.warn((Object)StringUtils.stringifyException((Throwable)ie));
                return p;
            }
        }
        return null;
    }

    public void cleanupJob(JobConf conf) throws IOException {
        Path outputPath = FileOutputFormat.getOutputPath((JobConf)conf);
        if (outputPath != null) {
            Path tmpDir = new Path(outputPath, "_temporary");
            FileSystem fileSys = tmpDir.getFileSystem((Configuration)conf);
            if (fileSys.exists(tmpDir)) {
                fileSys.delete(tmpDir, true);
            }
        } else {
            LOG.warn((Object)"Output path is null in cleanup");
        }
    }

    public void commitJob(JobConf conf) throws IOException {
        this.cleanupJob(conf);
        if (FileOutputCommitterWrapper.getOutputDirMarking(conf)) {
            this.markSuccessfulOutputDir(conf);
        }
    }
}

