/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.api.java.record.io.avro;

import eu.stratosphere.api.avro.FSDataInputStreamWrapper;
import eu.stratosphere.api.java.record.io.FileInputFormat;
import eu.stratosphere.core.fs.FileInputSplit;
import eu.stratosphere.core.fs.FileStatus;
import eu.stratosphere.core.fs.FileSystem;
import eu.stratosphere.core.fs.Path;
import eu.stratosphere.types.BooleanValue;
import eu.stratosphere.types.DoubleValue;
import eu.stratosphere.types.FloatValue;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.ListValue;
import eu.stratosphere.types.LongValue;
import eu.stratosphere.types.MapValue;
import eu.stratosphere.types.NullValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AvroRecordInputFormat
extends FileInputFormat {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(AvroRecordInputFormat.class);
    private FileReader<GenericRecord> dataFileReader;
    private GenericRecord reuseAvroRecord = null;
    private StringValue sString = new StringValue();
    private IntValue sInt = new IntValue();
    private BooleanValue sBool = new BooleanValue();
    private DoubleValue sDouble = new DoubleValue();
    private FloatValue sFloat = new FloatValue();
    private LongValue sLong = new LongValue();

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        GenericDatumReader datumReader = new GenericDatumReader();
        FSDataInputStreamWrapper in = new FSDataInputStreamWrapper(this.stream, (int)split.getLength());
        LOG.info((Object)("Opening split " + split));
        this.dataFileReader = DataFileReader.openReader((SeekableInput)in, (DatumReader)datumReader);
        this.dataFileReader.sync(split.getStart());
    }

    public boolean reachedEnd() throws IOException {
        return !this.dataFileReader.hasNext();
    }

    public Record nextRecord(Record record) throws IOException {
        if (!this.dataFileReader.hasNext()) {
            return null;
        }
        if (record == null) {
            throw new IllegalArgumentException("Empty PactRecord given");
        }
        this.reuseAvroRecord = (GenericRecord)this.dataFileReader.next((Object)this.reuseAvroRecord);
        List fields = this.reuseAvroRecord.getSchema().getFields();
        for (Schema.Field field : fields) {
            Value value = this.convertAvroToPactValue(field, this.reuseAvroRecord.get(field.pos()));
            record.setField(field.pos(), value);
            record.updateBinaryRepresenation();
        }
        return record;
    }

    private final Value convertAvroToPactValue(Schema.Field field, Object avroRecord) {
        if (avroRecord == null) {
            return null;
        }
        Schema.Type type = this.checkTypeConstraintsAndGetType(field.schema());
        switch (type) {
            case ARRAY: {
                Schema.Type elementType = field.schema().getElementType().getType();
                List avroList = (List)avroRecord;
                return this.convertAvroArrayToListValue(elementType, avroList);
            }
            case ENUM: {
                List symbols = field.schema().getEnumSymbols();
                String avroRecordString = avroRecord.toString();
                if (!symbols.contains(avroRecordString)) {
                    throw new RuntimeException("The given Avro file contains field with a invalid enum symbol");
                }
                this.sString.setValue((CharSequence)avroRecordString);
                return this.sString;
            }
            case MAP: {
                Schema.Type valueType = field.schema().getValueType().getType();
                Map avroMap = (Map)avroRecord;
                return this.convertAvroMapToMapValue(valueType, avroMap);
            }
        }
        return this.convertAvroPrimitiveToValue(type, avroRecord);
    }

    private final ListValue<?> convertAvroArrayToListValue(Schema.Type elementType, List<?> avroList) {
        switch (elementType) {
            case STRING: {
                StringListValue sl = new StringListValue();
                for (Object item : avroList) {
                    sl.add((Value)new StringValue((CharSequence)item));
                }
                return sl;
            }
            case INT: {
                IntListValue il = new IntListValue();
                for (Object item : avroList) {
                    il.add((Value)new IntValue(((Integer)item).intValue()));
                }
                return il;
            }
            case BOOLEAN: {
                BooleanListValue bl = new BooleanListValue();
                for (Object item : avroList) {
                    bl.add((Value)new BooleanValue(((Boolean)item).booleanValue()));
                }
                return bl;
            }
            case DOUBLE: {
                DoubleListValue dl = new DoubleListValue();
                for (Object item : avroList) {
                    dl.add((Value)new DoubleValue(((Double)item).doubleValue()));
                }
                return dl;
            }
            case FLOAT: {
                FloatListValue fl = new FloatListValue();
                for (Object item : avroList) {
                    fl.add((Value)new FloatValue(((Float)item).floatValue()));
                }
                return fl;
            }
            case LONG: {
                LongListValue ll = new LongListValue();
                for (Object item : avroList) {
                    ll.add((Value)new LongValue(((Long)item).longValue()));
                }
                return ll;
            }
        }
        throw new RuntimeException("Elements of type " + elementType + " are not supported for Avro arrays.");
    }

    private final MapValue<StringValue, ?> convertAvroMapToMapValue(Schema.Type mapValueType, Map<CharSequence, ?> avroMap) {
        switch (mapValueType) {
            case STRING: {
                StringMapValue sm = new StringMapValue();
                for (Map.Entry<CharSequence, ?> entry : avroMap.entrySet()) {
                    sm.put((Value)new StringValue(entry.getKey()), (Value)new StringValue((CharSequence)((String)entry.getValue())));
                }
                return sm;
            }
            case INT: {
                IntMapValue im = new IntMapValue();
                for (Map.Entry<CharSequence, ?> entry : avroMap.entrySet()) {
                    im.put((Value)new StringValue(entry.getKey()), (Value)new IntValue(((Integer)entry.getValue()).intValue()));
                }
                return im;
            }
            case BOOLEAN: {
                BooleanMapValue bm = new BooleanMapValue();
                for (Map.Entry<CharSequence, ?> entry : avroMap.entrySet()) {
                    bm.put((Value)new StringValue(entry.getKey()), (Value)new BooleanValue(((Boolean)entry.getValue()).booleanValue()));
                }
                return bm;
            }
            case DOUBLE: {
                DoubleMapValue dm = new DoubleMapValue();
                for (Map.Entry<CharSequence, ?> entry : avroMap.entrySet()) {
                    dm.put((Value)new StringValue(entry.getKey()), (Value)new DoubleValue(((Double)entry.getValue()).doubleValue()));
                }
                return dm;
            }
            case FLOAT: {
                FloatMapValue fm = new FloatMapValue();
                for (Map.Entry<CharSequence, ?> entry : avroMap.entrySet()) {
                    fm.put((Value)new StringValue(entry.getKey()), (Value)new FloatValue(((Float)entry.getValue()).floatValue()));
                }
                return fm;
            }
            case LONG: {
                LongMapValue lm = new LongMapValue();
                for (Map.Entry<CharSequence, ?> entry : avroMap.entrySet()) {
                    lm.put((Value)new StringValue(entry.getKey()), (Value)new LongValue(((Long)entry.getValue()).longValue()));
                }
                return lm;
            }
        }
        throw new RuntimeException("Map values of type " + mapValueType + " are not supported for Avro map.");
    }

    private final Value convertAvroPrimitiveToValue(Schema.Type type, Object avroRecord) {
        switch (type) {
            case STRING: {
                this.sString.setValue((CharSequence)avroRecord);
                return this.sString;
            }
            case INT: {
                this.sInt.setValue(((Integer)avroRecord).intValue());
                return this.sInt;
            }
            case BOOLEAN: {
                this.sBool.setValue(((Boolean)avroRecord).booleanValue());
                return this.sBool;
            }
            case DOUBLE: {
                this.sDouble.setValue(((Double)avroRecord).doubleValue());
                return this.sDouble;
            }
            case FLOAT: {
                this.sFloat.setValue(((Float)avroRecord).floatValue());
                return this.sFloat;
            }
            case LONG: {
                this.sLong.setValue(((Long)avroRecord).longValue());
                return this.sLong;
            }
            case NULL: {
                return NullValue.getInstance();
            }
        }
        throw new RuntimeException("Type " + type + " for AvroInputFormat is not implemented. Open an issue on GitHub.");
    }

    private final Schema.Type checkTypeConstraintsAndGetType(Schema schema) {
        Schema.Type type = schema.getType();
        if (type == Schema.Type.RECORD) {
            throw new RuntimeException("The given Avro file contains complex data types which are not supported right now");
        }
        if (type == Schema.Type.UNION) {
            List types = schema.getTypes();
            if (types.size() > 2) {
                throw new RuntimeException("The given Avro file contains a union that has more than two elements");
            }
            if (types.size() == 1 && ((Schema)types.get(0)).getType() != Schema.Type.UNION) {
                return ((Schema)types.get(0)).getType();
            }
            if (((Schema)types.get(0)).getType() == Schema.Type.UNION || ((Schema)types.get(1)).getType() == Schema.Type.UNION) {
                throw new RuntimeException("The given Avro file contains a nested union");
            }
            if (((Schema)types.get(0)).getType() == Schema.Type.NULL) {
                return ((Schema)types.get(1)).getType();
            }
            if (((Schema)types.get(1)).getType() != Schema.Type.NULL) {
                throw new RuntimeException("The given Avro file is contains a union with two non-null types.");
            }
            return ((Schema)types.get(0)).getType();
        }
        return type;
    }

    public FileInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        int numAvroFiles = 0;
        Path path = this.filePath;
        FileSystem fs = path.getFileSystem();
        FileStatus pathFile = fs.getFileStatus(path);
        if (!this.acceptFile(pathFile)) {
            throw new IOException("The given file does not pass the file-filter");
        }
        if (pathFile.isDir()) {
            FileStatus[] dir = fs.listStatus(path);
            for (int i = 0; i < dir.length; ++i) {
                if (dir[i].isDir() || !this.acceptFile(dir[i])) continue;
                ++numAvroFiles;
            }
        } else {
            numAvroFiles = 1;
        }
        return super.createInputSplits(numAvroFiles);
    }

    public static class LongMapValue
    extends MapValue<StringValue, LongValue> {
        private static final long serialVersionUID = 1L;
    }

    public static class FloatMapValue
    extends MapValue<StringValue, FloatValue> {
        private static final long serialVersionUID = 1L;
    }

    public static class DoubleMapValue
    extends MapValue<StringValue, DoubleValue> {
        private static final long serialVersionUID = 1L;
    }

    public static class BooleanMapValue
    extends MapValue<StringValue, BooleanValue> {
        private static final long serialVersionUID = 1L;
    }

    public static class IntMapValue
    extends MapValue<StringValue, IntValue> {
        private static final long serialVersionUID = 1L;
    }

    public static class StringMapValue
    extends MapValue<StringValue, StringValue> {
        private static final long serialVersionUID = 1L;
    }

    public static class LongListValue
    extends ListValue<LongValue> {
        private static final long serialVersionUID = 1L;
    }

    public static class FloatListValue
    extends ListValue<FloatValue> {
        private static final long serialVersionUID = 1L;
    }

    public static class DoubleListValue
    extends ListValue<DoubleValue> {
        private static final long serialVersionUID = 1L;
    }

    public static class BooleanListValue
    extends ListValue<BooleanValue> {
        private static final long serialVersionUID = 1L;
    }

    public static class IntListValue
    extends ListValue<IntValue> {
        private static final long serialVersionUID = 1L;
    }

    public static class StringListValue
    extends ListValue<StringValue> {
        private static final long serialVersionUID = 1L;
    }
}

