/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.api.java.record.io.avro;

import eu.stratosphere.api.avro.AvroBaseValue;
import eu.stratosphere.api.avro.FSDataInputStreamWrapper;
import eu.stratosphere.api.java.record.io.FileInputFormat;
import eu.stratosphere.core.fs.FileInputSplit;
import eu.stratosphere.types.Record;
import eu.stratosphere.util.InstantiationUtil;
import eu.stratosphere.util.ReflectionUtil;
import java.io.IOException;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AvroInputFormat<E>
extends FileInputFormat {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(AvroInputFormat.class);
    private final Class<? extends AvroBaseValue<E>> avroWrapperTypeClass;
    private final Class<E> avroValueType;
    private transient FileReader<E> dataFileReader;
    private transient E reuseAvroValue;
    private transient AvroBaseValue<E> wrapper;

    public AvroInputFormat(Class<? extends AvroBaseValue<E>> wrapperClass) {
        this.avroWrapperTypeClass = wrapperClass;
        this.avroValueType = ReflectionUtil.getTemplateType1(wrapperClass);
        this.unsplittable = true;
    }

    public AvroInputFormat(Class<? extends AvroBaseValue<E>> wrapperClass, Class<E> avroType) {
        this.avroValueType = avroType;
        this.avroWrapperTypeClass = wrapperClass;
        this.unsplittable = true;
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        this.wrapper = (AvroBaseValue)((Object)InstantiationUtil.instantiate(this.avroWrapperTypeClass, AvroBaseValue.class));
        Object datumReader = SpecificRecordBase.class.isAssignableFrom(this.avroValueType) ? new SpecificDatumReader(this.avroValueType) : new ReflectDatumReader(this.avroValueType);
        LOG.info((Object)("Opening split " + split));
        FSDataInputStreamWrapper in = new FSDataInputStreamWrapper(this.stream, (int)split.getLength());
        this.dataFileReader = DataFileReader.openReader((SeekableInput)in, (DatumReader)datumReader);
        this.dataFileReader.sync(split.getStart());
        this.reuseAvroValue = null;
    }

    public boolean reachedEnd() throws IOException {
        return !this.dataFileReader.hasNext();
    }

    public Record nextRecord(Record record) throws IOException {
        if (!this.dataFileReader.hasNext()) {
            return null;
        }
        this.reuseAvroValue = this.dataFileReader.next(this.reuseAvroValue);
        this.wrapper.datum(this.reuseAvroValue);
        record.setField(0, this.wrapper);
        return record;
    }
}

