/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.api.avro;

import eu.stratosphere.api.avro.DataInputDecoder;
import eu.stratosphere.api.avro.DataOutputEncoder;
import eu.stratosphere.types.Key;
import eu.stratosphere.util.ReflectionUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;

public abstract class AvroBaseValue<T>
extends AvroValue<T>
implements Key<AvroBaseValue<T>> {
    private static final long serialVersionUID = 1L;
    private ReflectDatumWriter<T> writer;
    private ReflectDatumReader<T> reader;
    private DataOutputEncoder encoder;
    private DataInputDecoder decoder;

    public AvroBaseValue() {
    }

    public AvroBaseValue(T datum) {
        super(datum);
    }

    public void write(DataOutput out) throws IOException {
        if (this.datum() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            DataOutputEncoder encoder = this.getEncoder();
            encoder.setOut(out);
            this.getWriter().write(this.datum(), (Encoder)encoder);
        }
    }

    public void read(DataInput in) throws IOException {
        if (in.readBoolean()) {
            DataInputDecoder decoder = this.getDecoder();
            decoder.setIn(in);
            this.datum(this.getReader().read(this.datum(), (Decoder)decoder));
        }
    }

    private ReflectDatumWriter<T> getWriter() {
        if (this.writer == null) {
            Class<?> clazz = this.datum().getClass();
            this.writer = new ReflectDatumWriter(clazz);
        }
        return this.writer;
    }

    private ReflectDatumReader<T> getReader() {
        if (this.reader == null) {
            Class datumClass = ReflectionUtil.getTemplateType1(((Object)((Object)this)).getClass());
            this.reader = new ReflectDatumReader(datumClass);
        }
        return this.reader;
    }

    private DataOutputEncoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = new DataOutputEncoder();
        }
        return this.encoder;
    }

    private DataInputDecoder getDecoder() {
        if (this.decoder == null) {
            this.decoder = new DataInputDecoder();
        }
        return this.decoder;
    }

    public int hashCode() {
        return this.datum() == null ? 0 : this.datum().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == ((Object)((Object)this)).getClass()) {
            Object otherDatum = ((AvroBaseValue)((Object)obj)).datum();
            Object thisDatum = this.datum();
            if (thisDatum == null) {
                return otherDatum == null;
            }
            return thisDatum.equals(otherDatum);
        }
        return false;
    }

    public String toString() {
        return "AvroBaseValue (" + this.datum() + ")";
    }

    public int compareTo(AvroBaseValue<T> o) {
        Object otherDatum = o.datum();
        Object thisDatum = this.datum();
        if (thisDatum == null) {
            return otherDatum == null ? 0 : -1;
        }
        return otherDatum == null ? 1 : ((Comparable)thisDatum).compareTo(otherDatum);
    }
}

