/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.api.avro;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.avro.io.Encoder;
import org.apache.avro.util.Utf8;

public final class DataOutputEncoder
extends Encoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DataOutput out;

    public void setOut(DataOutput out) {
        this.out = out;
    }

    public void flush() throws IOException {
    }

    public void writeNull() {
    }

    public void writeBoolean(boolean b) throws IOException {
        this.out.writeBoolean(b);
    }

    public void writeInt(int n) throws IOException {
        this.out.writeInt(n);
    }

    public void writeLong(long n) throws IOException {
        this.out.writeLong(n);
    }

    public void writeFloat(float f) throws IOException {
        this.out.writeFloat(f);
    }

    public void writeDouble(double d) throws IOException {
        this.out.writeDouble(d);
    }

    public void writeEnum(int e) throws IOException {
        this.out.writeInt(e);
    }

    public void writeFixed(byte[] bytes, int start, int len) throws IOException {
        this.out.write(bytes, start, len);
    }

    public void writeBytes(byte[] bytes, int start, int len) throws IOException {
        this.out.writeInt(len);
        if (len > 0) {
            this.out.write(bytes, start, len);
        }
    }

    public void writeBytes(ByteBuffer bytes) throws IOException {
        int num = bytes.remaining();
        this.out.writeInt(num);
        if (num > 0) {
            this.writeFixed(bytes);
        }
    }

    public void writeString(String str) throws IOException {
        byte[] bytes = Utf8.getBytesFor((String)str);
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeString(Utf8 utf8) throws IOException {
        this.writeBytes(utf8.getBytes(), 0, utf8.getByteLength());
    }

    public void writeArrayStart() {
    }

    public void setItemCount(long itemCount) throws IOException {
        if (itemCount > 0L) {
            DataOutputEncoder.writeVarLongCount(this.out, itemCount);
        }
    }

    public void startItem() {
    }

    public void writeArrayEnd() throws IOException {
        this.out.write(0);
    }

    public void writeMapStart() {
    }

    public void writeMapEnd() throws IOException {
        this.out.write(0);
    }

    public void writeIndex(int unionIndex) throws IOException {
        this.out.writeInt(unionIndex);
    }

    public static final void writeVarLongCount(DataOutput out, long val) throws IOException {
        if (val < 0L) {
            throw new IOException("Illegal count (must be non-negative): " + val);
        }
        while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.write((int)val | 0x80);
            val >>>= 7;
        }
        out.write((int)val);
    }
}

