/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.api.java.record.io.avro.example;

import eu.stratosphere.api.common.Plan;
import eu.stratosphere.api.common.io.OutputFormat;
import eu.stratosphere.api.common.operators.GenericDataSink;
import eu.stratosphere.api.common.operators.GenericDataSource;
import eu.stratosphere.api.common.operators.Operator;
import eu.stratosphere.api.java.record.functions.MapFunction;
import eu.stratosphere.api.java.record.functions.ReduceFunction;
import eu.stratosphere.api.java.record.io.GenericInputFormat;
import eu.stratosphere.api.java.record.io.avro.example.SUser;
import eu.stratosphere.api.java.record.io.avro.example.User;
import eu.stratosphere.api.java.record.operators.MapOperator;
import eu.stratosphere.api.java.record.operators.ReduceOperator;
import eu.stratosphere.client.LocalExecutor;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.types.IntValue;
import eu.stratosphere.types.Record;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.Collector;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Random;

public class ReflectiveAvroTypeExample {
    public static void main(String[] args) throws Exception {
        GenericDataSource source = new GenericDataSource(UserGeneratingInputFormat.class);
        MapOperator mapper = MapOperator.builder((MapFunction)new NumberExtractingMapper()).input(new Operator[]{source}).name("le mapper").build();
        ReduceOperator reducer = ReduceOperator.builder((ReduceFunction)new ConcatenatingReducer(), IntValue.class, (int)1).input(new Operator[]{mapper}).name("le reducer").build();
        GenericDataSink sink = new GenericDataSink(PrintingOutputFormat.class, (Operator)reducer);
        Plan p = new Plan(sink);
        p.setDefaultParallelism(4);
        LocalExecutor.execute((Plan)p);
    }

    public static final class PrintingOutputFormat
    implements OutputFormat<Record> {
        private static final long serialVersionUID = 1L;

        public void configure(Configuration parameters) {
        }

        public void open(int taskNumber, int numTasks) throws IOException {
        }

        public void writeRecord(Record record) throws IOException {
            int color = ((IntValue)record.getField(0, IntValue.class)).getValue();
            String names = ((StringValue)record.getField(1, StringValue.class)).getValue();
            System.out.println(color + ": " + names);
        }

        public void close() throws IOException {
        }
    }

    public static final class UserGeneratingInputFormat
    extends GenericInputFormat {
        private static final long serialVersionUID = 1L;
        private static final int NUM = 100;
        private final Random rnd = new Random(32498562304986L);
        private static final String[] NAMES = new String[]{"Peter", "Bob", "Liddy", "Alexander", "Stan"};
        private static final String[] COLORS = new String[]{"mauve", "crimson", "copper", "sky", "grass"};
        private int count;

        public boolean reachedEnd() throws IOException {
            return this.count >= 100;
        }

        public Record nextRecord(Record record) throws IOException {
            ++this.count;
            User u = new User();
            u.setName(NAMES[this.rnd.nextInt(NAMES.length)]);
            u.setFavoriteColor(COLORS[this.rnd.nextInt(COLORS.length)]);
            u.setFavoriteNumber(this.rnd.nextInt(87));
            SUser su = new SUser();
            su.datum((Object)u);
            record.setField(0, (Value)su);
            return record;
        }
    }

    public static final class ConcatenatingReducer
    extends ReduceFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Record result = new Record(2);

        public void reduce(Iterator<Record> records, Collector<Record> out) throws Exception {
            Record r = records.next();
            int num = ((IntValue)r.getField(1, IntValue.class)).getValue();
            String names = ((User)((Object)((SUser)r.getField(0, SUser.class)).datum())).getFavoriteColor().toString();
            while (records.hasNext()) {
                r = records.next();
                names = names + " - " + ((User)((Object)((SUser)r.getField(0, SUser.class)).datum())).getFavoriteColor().toString();
            }
            this.result.setField(0, (Value)new IntValue(num));
            this.result.setField(1, (Value)new StringValue((CharSequence)names));
            out.collect((Object)this.result);
        }
    }

    public static final class NumberExtractingMapper
    extends MapFunction
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void map(Record record, Collector<Record> out) throws Exception {
            User u = (User)((Object)((SUser)record.getField(0, SUser.class)).datum());
            record.setField(1, (Value)new IntValue(u.getFavoriteNumber().intValue()));
            out.collect((Object)record);
        }
    }
}

