/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.api.java.io;

import eu.stratosphere.api.avro.FSDataInputStreamWrapper;
import eu.stratosphere.api.common.io.FileInputFormat;
import eu.stratosphere.api.java.typeutils.ResultTypeQueryable;
import eu.stratosphere.api.java.typeutils.TypeExtractor;
import eu.stratosphere.api.java.typeutils.TypeInformation;
import eu.stratosphere.core.fs.FileInputSplit;
import eu.stratosphere.core.fs.Path;
import eu.stratosphere.util.InstantiationUtil;
import java.io.IOException;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AvroInputFormat<E>
extends FileInputFormat<E>
implements ResultTypeQueryable<E> {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(AvroInputFormat.class);
    private final Class<E> avroValueType;
    private boolean reuseAvroValue = true;
    private transient FileReader<E> dataFileReader;

    public AvroInputFormat(Path filePath, Class<E> type) {
        super(filePath);
        this.avroValueType = type;
        this.unsplittable = true;
    }

    public void setReuseAvroValue(boolean reuseAvroValue) {
        this.reuseAvroValue = reuseAvroValue;
    }

    public TypeInformation<E> getProducedType() {
        return TypeExtractor.getForClass(this.avroValueType);
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        Object datumReader = SpecificRecordBase.class.isAssignableFrom(this.avroValueType) ? new SpecificDatumReader(this.avroValueType) : new ReflectDatumReader(this.avroValueType);
        LOG.info((Object)("Opening split " + split));
        FSDataInputStreamWrapper in = new FSDataInputStreamWrapper(this.stream, (int)split.getLength());
        this.dataFileReader = DataFileReader.openReader((SeekableInput)in, (DatumReader)datumReader);
        this.dataFileReader.sync(split.getStart());
    }

    public boolean reachedEnd() throws IOException {
        return !this.dataFileReader.hasNext();
    }

    public E nextRecord(E reuseValue) throws IOException {
        if (!this.dataFileReader.hasNext()) {
            return null;
        }
        if (!this.reuseAvroValue) {
            reuseValue = InstantiationUtil.instantiate(this.avroValueType, Object.class);
        }
        reuseValue = this.dataFileReader.next(reuseValue);
        return reuseValue;
    }
}

