/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.arraymodel.io;

import eu.stratosphere.api.common.io.FileOutputFormat;
import eu.stratosphere.api.common.operators.FileDataSink;
import eu.stratosphere.arraymodel.io.ArrayModelOutputFormat;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.types.Value;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public abstract class ArrayOutputFormat
extends FileOutputFormat<Value[]>
implements ArrayModelOutputFormat {
    private static final long serialVersionUID = 1L;
    private static final String RECORD_DELIMITER_PARAMETER = "arraymodel.output.delimiter";
    private static final String FIELD_DELIMITER_PARAMETER = "arraymodel.outout.field-delimiter";
    private static final String ENCODING_PARAMETER = "arraymodel.output.encoding";
    private static final String LENIENT_PARSING = "arraymodel.output.lenient";
    private OutputStreamWriter wrt;
    private String fieldDelimiter;
    private String recordDelimiter;
    private String charsetName;
    private boolean lenient;

    public void configure(Configuration parameters) {
        super.configure(parameters);
        this.recordDelimiter = parameters.getString(RECORD_DELIMITER_PARAMETER, "\n");
        if (this.recordDelimiter == null) {
            throw new IllegalArgumentException("The delimiter in the DelimitedOutputFormat must not be null.");
        }
        this.charsetName = parameters.getString(ENCODING_PARAMETER, null);
        this.fieldDelimiter = parameters.getString(FIELD_DELIMITER_PARAMETER, "|");
        this.lenient = parameters.getBoolean(LENIENT_PARSING, false);
    }

    public void open(int taskNumber) throws IOException {
        super.open(taskNumber);
        this.wrt = this.charsetName == null ? new OutputStreamWriter(new BufferedOutputStream((OutputStream)this.stream, 4096)) : new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)this.stream, 4096), this.charsetName);
    }

    public void close() throws IOException {
        if (this.wrt != null) {
            this.wrt.close();
        }
        super.close();
    }

    public void writeRecord(Value[] record) throws IOException {
        for (int i = 0; i < record.length; ++i) {
            Value v = record[i];
            if (v != null) {
                if (i != 0) {
                    this.wrt.write(this.fieldDelimiter);
                }
                this.wrt.write(v.toString());
                continue;
            }
            if (this.lenient) {
                if (i == 0) continue;
                this.wrt.write(this.fieldDelimiter);
                continue;
            }
            throw new RuntimeException("Cannot serialize record with <null> value at position: " + i);
        }
        this.wrt.write(this.recordDelimiter);
    }

    public static ConfigBuilder configureArrayFormat(FileDataSink target) {
        return new ConfigBuilder(target.getParameters());
    }

    public static final class ConfigBuilder
    extends AbstractConfigBuilder<ConfigBuilder> {
        protected ConfigBuilder(Configuration targetConfig) {
            super(targetConfig);
        }
    }

    protected static abstract class AbstractConfigBuilder<T>
    extends FileOutputFormat.AbstractConfigBuilder<T> {
        private static final String NEWLINE_DELIMITER = "\n";

        protected AbstractConfigBuilder(Configuration config) {
            super(config);
        }

        public T recordDelimiter(char delimiter) {
            if (delimiter == '\n') {
                this.config.setString(ArrayOutputFormat.RECORD_DELIMITER_PARAMETER, NEWLINE_DELIMITER);
            } else {
                this.config.setString(ArrayOutputFormat.RECORD_DELIMITER_PARAMETER, String.valueOf(delimiter));
            }
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }

        public T recordDelimiter(String delimiter) {
            this.config.setString(ArrayOutputFormat.RECORD_DELIMITER_PARAMETER, delimiter);
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }

        public T encoding(String charsetName) {
            this.config.setString(ArrayOutputFormat.ENCODING_PARAMETER, charsetName);
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }

        public T fieldDelimiter(char delimiter) {
            this.config.setString(ArrayOutputFormat.FIELD_DELIMITER_PARAMETER, String.valueOf(delimiter));
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }

        public T lenient(boolean lenient) {
            this.config.setBoolean(ArrayOutputFormat.LENIENT_PARSING, lenient);
            AbstractConfigBuilder ret = this;
            return (T)((Object)ret);
        }
    }
}

