/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.arraymodel.io;

import eu.stratosphere.api.common.io.DelimitedInputFormat;
import eu.stratosphere.configuration.Configuration;
import eu.stratosphere.types.StringValue;
import eu.stratosphere.types.Value;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringInputFormat
extends DelimitedInputFormat<Value[]> {
    private static final long serialVersionUID = 1L;
    public static final String CHARSET_NAME = "textformat.charset";
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private static final Log LOG = LogFactory.getLog(StringInputFormat.class);
    protected final StringValue theString = new StringValue();
    protected CharsetDecoder decoder;
    protected ByteBuffer byteWrapper;
    protected boolean ascii;

    public void configure(Configuration parameters) {
        super.configure(parameters);
        String charsetName = parameters.getString(CHARSET_NAME, DEFAULT_CHARSET_NAME);
        if (charsetName == null || !Charset.isSupported(charsetName)) {
            throw new RuntimeException("Unsupported charset: " + charsetName);
        }
        if (charsetName.equals("ISO-8859-1") || charsetName.equalsIgnoreCase("ASCII")) {
            this.ascii = true;
        } else {
            this.decoder = Charset.forName(charsetName).newDecoder();
            this.byteWrapper = ByteBuffer.allocate(1);
        }
    }

    public boolean readRecord(Value[] target, byte[] bytes, int offset, int numBytes) {
        StringValue str = this.theString;
        if (this.ascii) {
            str.setValueAscii(bytes, offset, numBytes);
        } else {
            ByteBuffer byteWrapper = this.byteWrapper;
            if (bytes != byteWrapper.array()) {
                this.byteWrapper = byteWrapper = ByteBuffer.wrap(bytes, 0, bytes.length);
            }
            byteWrapper.clear();
            byteWrapper.position(offset);
            byteWrapper.limit(offset + numBytes);
            try {
                CharBuffer result = this.decoder.decode(byteWrapper);
                str.setValue(result);
            }
            catch (CharacterCodingException e) {
                byte[] copy = new byte[numBytes];
                System.arraycopy(bytes, offset, copy, 0, numBytes);
                LOG.warn((Object)("Line could not be encoded: " + Arrays.toString(copy)), (Throwable)e);
                return false;
            }
        }
        target[0] = str;
        return true;
    }
}

