/***********************************************************************************************************************
 * Copyright (C) 2010-2013 by the Stratosphere project (http://stratosphere.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 **********************************************************************************************************************/
package eu.stratosphere.arraymodel;

import java.util.Collection;

import eu.stratosphere.api.common.operators.GenericDataSink;


public class ArrayModelPlan extends eu.stratosphere.api.common.Plan {

	public ArrayModelPlan(Collection<GenericDataSink> sinks, String jobName) {
		super(sinks, jobName);
	}

	public ArrayModelPlan(Collection<GenericDataSink> sinks) {
		super(sinks);
	}

	public ArrayModelPlan(GenericDataSink sink, String jobName) {
		super(sink, jobName);
	}

	public ArrayModelPlan(GenericDataSink sink) {
		super(sink);
	}

	@Override
	public String getPostPassClassName() {
		return "eu.stratosphere.arraymodel.optimizer.ArrayRecordOptimizerPostPass";
	}
}
