/*
 * Decompiled with CFR 0.152.
 */
package eu.shiftforward.apso.io;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import eu.shiftforward.apso.io.FileDescriptorCredentials;
import eu.shiftforward.apso.io.SftpFileDescriptor;
import eu.shiftforward.apso.io.config.Credentials;
import io.github.andrebeat.pool.Lease;
import io.github.andrebeat.pool.Pool;
import io.github.andrebeat.pool.Pool$;
import io.github.andrebeat.pool.ReferenceType;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple7;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import scala.util.matching.Regex;

public final class SftpFileDescriptor$
implements scala.Serializable {
    public static SftpFileDescriptor$ MODULE$;
    private final Config fdConf;
    private final int maxConnections;
    private final FiniteDuration maxIdleTime;
    private final ConcurrentHashMap<String, Pool<SftpFileDescriptor.SftpClient>> connectionPools;
    private final Regex idRegex;
    private final FileDescriptorCredentials<Credentials.Sftp.Entry, Tuple3<String, String, Either<Tuple2<File, Option<String>>, String>>> credentials;

    static {
        new SftpFileDescriptor$();
    }

    public Option<FileAttributes> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public SFTPClient sftpClientToSFTPClient(SftpFileDescriptor.SftpClient c) {
        return c.sftpClient();
    }

    private SSHClient sshClient(String host, int port, String username, Option<String> password, Option<Tuple2<File, Option<String>>> identity) {
        Some some;
        Tuple2 tuple2;
        Option option;
        Option option2;
        SSHClient sshClient = new SSHClient();
        sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        sshClient.useCompression();
        sshClient.connect(host, port);
        Tuple2 tuple22 = new Tuple2(password, identity);
        if (tuple22 != null && (option2 = (Option)tuple22._1()) instanceof Some) {
            sshClient.authPassword(username, (String)password.get());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (tuple22 != null && (option = (Option)tuple22._2()) instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            KeyProvider keyProvider;
            File f = (File)tuple2._1();
            Option p = (Option)tuple2._2();
            Option option3 = p;
            if (option3 instanceof Some) {
                Some some2 = (Some)option3;
                String passphrase = (String)some2.value();
                keyProvider = sshClient.loadKeys(f.getAbsolutePath(), passphrase);
            } else if (None$.MODULE$.equals(option3)) {
                keyProvider = sshClient.loadKeys(f.getAbsolutePath());
            } else {
                throw new MatchError((Object)option3);
            }
            KeyProvider keyProvider2 = keyProvider;
            sshClient.authPublickey(username, new KeyProvider[]{keyProvider2});
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException("Either a password or pub-priv key identity must be provided");
        }
        return sshClient;
    }

    public Lease<SftpFileDescriptor.SftpClient> eu$shiftforward$apso$io$SftpFileDescriptor$$acquireConnection(String host, int port, String username, Option<String> password, Option<Tuple2<File, Option<String>>> identity) {
        Pool pool;
        Pool p = this.connectionPools.get(host);
        if (p == null) {
            SftpFileDescriptor$ sftpFileDescriptor$ = this;
            synchronized (sftpFileDescriptor$) {
                int x$17 = this.maxConnections;
                Function0 & Serializable & scala.Serializable x$18 = (Function0 & Serializable & scala.Serializable)() -> new SftpFileDescriptor.SftpClient(MODULE$.sshClient(host, port, username, password, identity));
                Function1 & Serializable & scala.Serializable x$19 = (Function1 & Serializable & scala.Serializable)c -> {
                    c.close();
                    return BoxedUnit.UNIT;
                };
                FiniteDuration x$20 = this.maxIdleTime;
                ReferenceType x$21 = Pool$.MODULE$.apply$default$3();
                Function1 x$22 = Pool$.MODULE$.apply$default$5();
                Function1 x$23 = Pool$.MODULE$.apply$default$7();
                Pool pool2 = Pool$.MODULE$.apply(x$17, (Function0)x$18, x$21, (Duration)x$20, x$22, (Function1)x$19, x$23);
                this.connectionPools.put(host, (Pool<SftpFileDescriptor.SftpClient>)pool2);
                Pool pool3 = pool2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var8_7
                pool = pool3;
            }
        } else {
            pool = p;
        }
        Pool pool4 = pool;
        return pool4.acquire();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple3<String, Object, String> eu$shiftforward$apso$io$SftpFileDescriptor$$splitMeta(String url) {
        Option option;
        String string = url;
        Option option2 = this.idRegex.unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(4) == 0) {
            String id = (String)((LinearSeqOptimized)option2.get()).apply(1);
            String string2 = (String)((LinearSeqOptimized)option2.get()).apply(2);
            String path = (String)((LinearSeqOptimized)option2.get()).apply(3);
            if (string2 == null) {
                return new Tuple3((Object)id, (Object)BoxesRunTime.boxToInteger((int)22), (Object)path);
            }
        }
        if ((option = this.idRegex.unapplySeq((CharSequence)string)).isEmpty()) throw new IllegalArgumentException("Error parsing SFTP URI.");
        if (option.get() == null) throw new IllegalArgumentException("Error parsing SFTP URI.");
        if (((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) throw new IllegalArgumentException("Error parsing SFTP URI.");
        String id = (String)((LinearSeqOptimized)option.get()).apply(1);
        String port = (String)((LinearSeqOptimized)option.get()).apply(2);
        String path = (String)((LinearSeqOptimized)option.get()).apply(3);
        return new Tuple3((Object)id, (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(port)).drop(1))).toInt()), (Object)path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SftpFileDescriptor apply(String host, int port, String url, String username, Option<String> password, Option<Tuple2<File, Option<String>>> identity, Predef.DummyImplicit d) {
        Nil$ nil$;
        String path;
        Tuple3<String, Object, String> tuple3 = this.eu$shiftforward$apso$io$SftpFileDescriptor$$splitMeta(url);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String string = path = (String)tuple3._3();
        String path2 = string;
        List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path2.split("/"))).toList();
        if (Nil$.MODULE$.equals(list)) {
            nil$ = Nil$.MODULE$;
        } else {
            if (!(list instanceof .colon.colon)) throw new IllegalArgumentException("Error parsing SFTP URI. Only absolute paths are supported.");
            .colon.colon colon2 = (.colon.colon)list;
            String string2 = (String)colon2.head();
            List list2 = colon2.tl$access$1();
            if (!"".equals(string2) || !(list2 instanceof .colon.colon)) throw new IllegalArgumentException("Error parsing SFTP URI. Only absolute paths are supported.");
            .colon.colon colon3 = (.colon.colon)list2;
            String hd = (String)colon3.head();
            List tail = colon3.tl$access$1();
            String string3 = hd;
            nil$ = tail.$colon$colon((Object)string3);
        }
        Nil$ elements = nil$;
        return new SftpFileDescriptor(host, port, username, password, (List<String>)elements, identity, this.apply$default$7());
    }

    public SftpFileDescriptor apply(String host, int port, String url, String username, Option<String> password, Predef.DummyImplicit d) {
        return this.apply(host, port, url, username, password, (Option<Tuple2<File, Option<String>>>)None$.MODULE$, d);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SftpFileDescriptor apply(String url, Option<Tuple3<String, String, Either<Tuple2<File, Option<String>>, String>>> credentials) {
        int port;
        Tuple3 creds = (Tuple3)credentials.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No credentials found."})).s((Seq)Nil$.MODULE$));
        });
        Tuple3<String, Object, String> tuple3 = this.eu$shiftforward$apso$io$SftpFileDescriptor$$splitMeta(url);
        if (tuple3 == null) throw new MatchError(tuple3);
        int n = port = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int port2 = n;
        Tuple3 tuple32 = creds;
        if (tuple32 != null) {
            String host = (String)tuple32._1();
            String username = (String)tuple32._2();
            Either either = (Either)tuple32._3();
            if (either instanceof Left) {
                Left left = (Left)either;
                Tuple2 identity = (Tuple2)left.value();
                return this.apply(host, port2, url, username, (Option<String>)None$.MODULE$, (Option<Tuple2<File, Option<String>>>)new Some((Object)identity), Predef.DummyImplicit$.MODULE$.dummyImplicit());
            }
        }
        if (tuple32 == null) throw new MatchError((Object)tuple32);
        String host = (String)tuple32._1();
        String username = (String)tuple32._2();
        Either either = (Either)tuple32._3();
        if (!(either instanceof Right)) throw new MatchError((Object)tuple32);
        Right right = (Right)either;
        String password = (String)right.value();
        return this.apply(host, port2, url, username, (Option<String>)new Some((Object)password), (Option<Tuple2<File, Option<String>>>)None$.MODULE$, Predef.DummyImplicit$.MODULE$.dummyImplicit());
    }

    public SftpFileDescriptor apply(String path, Credentials.Sftp credentialsConfig) {
        return this.apply(path, this.credentials.read(credentialsConfig, path));
    }

    public Option<FileAttributes> apply$default$7() {
        return None$.MODULE$;
    }

    public SftpFileDescriptor apply(String host, int port, String username, Option<String> password, List<String> elements, Option<Tuple2<File, Option<String>>> identity, Option<FileAttributes> _fileAttributes) {
        return new SftpFileDescriptor(host, port, username, password, elements, identity, _fileAttributes);
    }

    public Option<Tuple7<String, Object, String, Option<String>, List<String>, Option<Tuple2<File, Option<String>>>, Option<FileAttributes>>> unapply(SftpFileDescriptor x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.host(), (Object)BoxesRunTime.boxToInteger((int)x$0.port()), (Object)x$0.username(), x$0.password(), x$0.elements(), x$0.identity(), x$0.eu$shiftforward$apso$io$SftpFileDescriptor$$_fileAttributes()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SftpFileDescriptor$() {
        MODULE$ = this;
        this.fdConf = ConfigFactory.load();
        this.maxConnections = this.fdConf.getInt("apso.io.file-descriptor.sftp.max-connections-per-host");
        this.maxIdleTime = Duration$.MODULE$.fromNanos(this.fdConf.getDuration("apso.io.file-descriptor.sftp.max-idle-time").toNanos());
        this.connectionPools = new ConcurrentHashMap();
        this.idRegex = new StringOps(Predef$.MODULE$.augmentString("(.*@)?([\\-|\\d|\\w|\\.]+)(:\\d+)?(\\/.*)")).r();
        this.credentials = new FileDescriptorCredentials<Credentials.Sftp.Entry, Tuple3<String, String, Either<Tuple2<File, Option<String>>, String>>>(){

            public Option<Tuple3<String, String, Either<Tuple2<File, Option<String>>, String>>> read(Credentials.Protocol<Credentials.Sftp.Entry> conf, String path) {
                return FileDescriptorCredentials.read$(this, conf, path);
            }

            public String id(String path) {
                return (String)SftpFileDescriptor$.MODULE$.eu$shiftforward$apso$io$SftpFileDescriptor$$splitMeta(path)._1();
            }

            public Tuple3<String, String, Either<Tuple2<File, Option<String>>, String>> createCredentials(String hostname, Credentials.Sftp.Entry sftpConfig) {
                Tuple3 tuple3;
                Credentials.Sftp.Entry entry = sftpConfig;
                if (entry instanceof Credentials.Sftp.Entry.Basic) {
                    Credentials.Sftp.Entry.Basic basic = (Credentials.Sftp.Entry.Basic)entry;
                    String username = basic.username();
                    String password = basic.password();
                    tuple3 = new Tuple3((Object)hostname, (Object)username, (Object)package$.MODULE$.Right().apply((Object)password));
                } else if (entry instanceof Credentials.Sftp.Entry.PublicKey) {
                    Credentials.Sftp.Entry.PublicKey publicKey = (Credentials.Sftp.Entry.PublicKey)entry;
                    String username = publicKey.username();
                    String keypairFile = publicKey.keypairFile();
                    Option<String> passphrase = publicKey.passphrase();
                    tuple3 = new Tuple3((Object)hostname, (Object)username, (Object)package$.MODULE$.Left().apply((Object)new Tuple2((Object)new File(Properties$.MODULE$.userHome() + "/.ssh/" + keypairFile), passphrase)));
                } else {
                    throw new MatchError((Object)entry);
                }
                return tuple3;
            }
            {
                FileDescriptorCredentials.$init$(this);
            }
        };
    }
}

