/*
 * Decompiled with CFR 0.152.
 */
package eu.shiftforward.apso.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.ExecutorFactory;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import eu.shiftforward.apso.Logging;
import eu.shiftforward.apso.aws.S3Bucket$;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tUe\u0001B\u0001\u0003\u0001-\u0011\u0001bU\u001aCk\u000e\\W\r\u001e\u0006\u0003\u0007\u0011\t1!Y<t\u0015\t)a!\u0001\u0003baN|'BA\u0004\t\u00031\u0019\b.\u001b4uM>\u0014x/\u0019:e\u0015\u0005I\u0011AA3v\u0007\u0001\u0019B\u0001\u0001\u0007\u0013-A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003\u000f1{wmZ5oOB\u0011QbF\u0005\u000319\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\u0007\u0001\u0003\u0006\u0004%\taG\u0001\u000bEV\u001c7.\u001a;OC6,W#\u0001\u000f\u0011\u0005u!cB\u0001\u0010#!\tyb\"D\u0001!\u0015\t\t#\"\u0001\u0004=e>|GOP\u0005\u0003G9\ta\u0001\u0015:fI\u00164\u0017BA\u0013'\u0005\u0019\u0019FO]5oO*\u00111E\u0004\u0005\tQ\u0001\u0011\t\u0011)A\u00059\u0005Y!-^2lKRt\u0015-\\3!\u0011!Q\u0003A!b\u0001\n\u0013Y\u0013aE2sK\u0012,g\u000e^5bYN\u0004&o\u001c<jI\u0016\u0014X#\u0001\u0017\u0011\u00075is&\u0003\u0002/\u001d\tIa)\u001e8di&|g\u000e\r\t\u0003a]j\u0011!\r\u0006\u0003eM\nA!Y;uQ*\u0011A'N\u0001\nC6\f'p\u001c8boNT\u0011AN\u0001\u0004G>l\u0017B\u0001\u001d2\u0005Y\tukU\"sK\u0012,g\u000e^5bYN\u0004&o\u001c<jI\u0016\u0014\b\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002)\r\u0014X\rZ3oi&\fGn\u001d)s_ZLG-\u001a:!\u0011\u0015a\u0004\u0001\"\u0001>\u0003\u0019a\u0014N\\5u}Q\u0019a\bQ!\u0011\u0005}\u0002Q\"\u0001\u0002\t\u000biY\u0004\u0019\u0001\u000f\t\u000f)Z\u0004\u0013!a\u0001Y!A1\t\u0001ECB\u0013%A)\u0001\u0004d_:4\u0017nZ\u000b\u0002\u000bB\u0011aIS\u0007\u0002\u000f*\u00111\t\u0013\u0006\u0003\u0013V\n\u0001\u0002^=qKN\fg-Z\u0005\u0003\u0017\u001e\u0013aaQ8oM&<\u0007\u0002C'\u0001\u0011\u000b\u0007K\u0011\u0002(\u0002\u0019\r|gNZ5h!J,g-\u001b=\u0016\u0003=\u0003\"\u0001U+\u000e\u0003ES!AU*\u0002\t1\fgn\u001a\u0006\u0002)\u0006!!.\u0019<b\u0013\t)\u0013\u000b\u0003\u0005X\u0001!\u0015\r\u0015\"\u0003Y\u0003\u0019\u0011XmZ5p]V\t\u0011\fE\u0002[;>k\u0011a\u0017\u0006\u00039:\tA!\u001e;jY&\u0011al\u0017\u0002\u0004)JL\b\"\u00031\u0001\u0001\u0004\u0005\t\u0015)\u0003b\u0003\ry6o\r\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\f!a]\u001a\u000b\u0005\u0019\u001c\u0014\u0001C:feZL7-Z:\n\u0005!\u001c'\u0001C!nCj|gnU\u001a)\u0005}S\u0007CA\u0007l\u0013\tagBA\u0005ue\u0006t7/[3oi\"1A\r\u0001Q\u0005\n9,\u0012!\u0019\u0005\na\u0002\u0001\r\u0011!Q!\nE\f\u0001c\u0018;sC:\u001ch-\u001a:NC:\fw-\u001a:\u0011\u0005I,X\"A:\u000b\u0005Q\u001c\u0017\u0001\u0003;sC:\u001ch-\u001a:\n\u0005Y\u001c(a\u0004+sC:\u001ch-\u001a:NC:\fw-\u001a:)\u0005=T\u0007BB=\u0001A\u0013%!0A\bue\u0006t7OZ3s\u001b\u0006t\u0017mZ3s+\u0005\t\bB\u0002?\u0001A\u0013%Q0\u0001\u0005ta2LGoS3z)\rq\u00181\u0001\t\u0006\u001b}|ujT\u0005\u0004\u0003\u0003q!A\u0002+va2,7\u0007\u0003\u0004\u0002\u0006m\u0004\r\u0001H\u0001\u0004W\u0016L\b\u0002CA\u0005\u0001\u0001&I!a\u0003\u0002\u0017M\fg.\u001b;ju\u0016\\U-\u001f\u000b\u00049\u00055\u0001bBA\u0003\u0003\u000f\u0001\r\u0001\b\u0005\b\u0003#\u0001A\u0011AA\n\u0003\u0011\u0019\u0018N_3\u0015\t\u0005U\u00111\u0004\t\u0004\u001b\u0005]\u0011bAA\r\u001d\t!Aj\u001c8h\u0011\u001d\t)!a\u0004A\u0002qAq!a\b\u0001\t\u0003\t\t#\u0001\u000fhKR|%M[3diN<\u0016\u000e\u001e5NCR\u001c\u0007.\u001b8h!J,g-\u001b=\u0015\r\u0005\r\u0012\u0011IA#!\u0019\t)#a\f\u000269!\u0011qEA\u0016\u001d\ry\u0012\u0011F\u0005\u0002\u001f%\u0019\u0011Q\u0006\b\u0002\u000fA\f7m[1hK&!\u0011\u0011GA\u001a\u0005!IE/\u001a:bi>\u0014(bAA\u0017\u001dA!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<\r\fQ!\\8eK2LA!a\u0010\u0002:\ty1kM(cU\u0016\u001cGoU;n[\u0006\u0014\u0018\u0010C\u0004\u0002D\u0005u\u0001\u0019\u0001\u000f\u0002\rA\u0014XMZ5y\u0011)\t9%!\b\u0011\u0002\u0003\u0007\u0011\u0011J\u0001\u0013S:\u001cG.\u001e3f\t&\u0014Xm\u0019;pe&,7\u000fE\u0002\u000e\u0003\u0017J1!!\u0014\u000f\u0005\u001d\u0011un\u001c7fC:Dq!!\u0015\u0001\t\u0003\t\u0019&\u0001\u000ehKR4\u0015\u000e\\3t/&$\b.T1uG\"Lgn\u001a)sK\u001aL\u0007\u0010\u0006\u0004\u0002V\u0005]\u0013\u0011\f\t\u0006\u0003K\ty\u0003\b\u0005\b\u0003\u0007\ny\u00051\u0001\u001d\u0011)\t9%a\u0014\u0011\u0002\u0003\u0007\u0011\u0011\n\u0005\b\u0003;\u0002A\u0011AA0\u0003\u0011\u0001Xo\u001d5\u0015\r\u0005%\u0013\u0011MA2\u0011\u001d\t)!a\u0017A\u0002qA\u0001\"!\u001a\u0002\\\u0001\u0007\u0011qM\u0001\u0005M&dW\r\u0005\u0003\u0002j\u0005=TBAA6\u0015\r\tigU\u0001\u0003S>LA!!\u001d\u0002l\t!a)\u001b7f\u0011\u001d\ti\u0006\u0001C\u0001\u0003k\"\u0002\"!\u0013\u0002x\u0005e\u00141\u0011\u0005\b\u0003\u000b\t\u0019\b1\u0001\u001d\u0011!\tY(a\u001dA\u0002\u0005u\u0014aC5oaV$8\u000b\u001e:fC6\u0004B!!\u001b\u0002\u0000%!\u0011\u0011QA6\u0005-Ie\u000e];u'R\u0014X-Y7\t\u0011\u0005\u0015\u00151\u000fa\u0001\u0003\u000f\u000ba\u0001\\3oORD\u0007#B\u0007\u0002\n\u0006U\u0011bAAF\u001d\t1q\n\u001d;j_:Dq!a$\u0001\t\u0003\t\t*\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003\u0013\n\u0019\nC\u0004\u0002\u0006\u00055\u0005\u0019\u0001\u000f\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\u00061Q\r_5tiN$B!!\u0013\u0002\u001c\"9\u0011QAAK\u0001\u0004a\u0002bBAP\u0001\u0011\u0005\u0011\u0011U\u0001\fSN$\u0015N]3di>\u0014\u0018\u0010\u0006\u0003\u0002J\u0005\r\u0006bBA\u0003\u0003;\u0003\r\u0001\b\u0005\b\u0003O\u0003A\u0011AAU\u0003\u0019\u0019X\r^!dYR1\u00111VAY\u0003g\u00032!DAW\u0013\r\tyK\u0004\u0002\u0005+:LG\u000fC\u0004\u0002\u0006\u0005\u0015\u0006\u0019\u0001\u000f\t\u0011\u0005U\u0016Q\u0015a\u0001\u0003o\u000b1!Y2m!\u0011\t9$!/\n\t\u0005m\u0016\u0011\b\u0002\u0018\u0007\u0006tg.\u001a3BG\u000e,7o]\"p]R\u0014x\u000e\u001c'jgRDq!a0\u0001\t\u0003\t\t-A\bde\u0016\fG/\u001a#je\u0016\u001cGo\u001c:z)\u0011\tI%a1\t\u000f\u0005\u0015\u0011Q\u0018a\u00019!9\u0011q\u0019\u0001\u0005\u0002\u0005%\u0017A\u00022bG.,\b\u000f\u0006\u0003\u0002J\u0005-\u0007bBA\u0003\u0003\u000b\u0004\r\u0001\b\u0005\b\u0003\u001f\u0004A\u0011AAi\u0003\u0011\u0001X\u000f\u001c7\u0015\r\u0005%\u00131[Ak\u0011\u001d\t)!!4A\u0002qAq!a6\u0002N\u0002\u0007A$A\u0006eKN$\u0018N\\1uS>t\u0007bBAn\u0001\u0011\u0005\u0011Q\\\u0001\u0007gR\u0014X-Y7\u0015\r\u0005u\u0014q\\Aq\u0011\u001d\t)!!7A\u0002qA!\"a9\u0002ZB\u0005\t\u0019AA\u000b\u0003\u0019ygMZ:fi\"A\u0011q\u001d\u0001!\n\u0013\tI/A\u0004iC:$G.\u001a:\u0016\u0005\u0005-\bcB\u0007\u0002n\u0006E\u0018\u0011J\u0005\u0004\u0003_t!a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\u0011\t\u0005\u0015\u00121_\u0005\u0005\u0003k\f\u0019DA\u0005UQJ|w/\u00192mK\"A\u0011\u0011 \u0001!\n\u0013\tY0A\u0003sKR\u0014\u00180\u0006\u0003\u0002~\n\u0015A\u0003CA\u0000\u0005/\u0011\tCa\u000b\u0011\u000b5\tII!\u0001\u0011\t\t\r!Q\u0001\u0007\u0001\t!\u00119!a>C\u0002\t%!!\u0001+\u0012\t\t-!\u0011\u0003\t\u0004\u001b\t5\u0011b\u0001B\b\u001d\t9aj\u001c;iS:<\u0007cA\u0007\u0003\u0014%\u0019!Q\u0003\b\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003\u001a\u0005]H\u00111\u0001\u0003\u001c\u0005\ta\rE\u0003\u000e\u0005;\u0011\t!C\u0002\u0003 9\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\u000b\u0005G\t9\u0010%AA\u0002\t\u0015\u0012!\u0002;sS\u0016\u001c\bcA\u0007\u0003(%\u0019!\u0011\u0006\b\u0003\u0007%sG\u000f\u0003\u0006\u0003.\u0005]\b\u0013!a\u0001\u0005K\t\u0011b\u001d7fKB$\u0016.\\3\t\u000f\tE\u0002\u0001\"\u0011\u00034\u00051Q-];bYN$B!!\u0013\u00036!A!q\u0007B\u0018\u0001\u0004\u0011\t\"A\u0002pE*D\u0011Ba\u000f\u0001#\u0003%IA!\u0010\u0002\u001fI,GO]=%I\u00164\u0017-\u001e7uII*BAa\u0010\u0003VU\u0011!\u0011\t\u0016\u0005\u0005K\u0011\u0019e\u000b\u0002\u0003FA!!q\tB)\u001b\t\u0011IE\u0003\u0003\u0003L\t5\u0013!C;oG\",7m[3e\u0015\r\u0011yED\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B*\u0005\u0013\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t!\u00119A!\u000fC\u0002\t%\u0001\"\u0003B-\u0001E\u0005I\u0011\u0002B.\u0003=\u0011X\r\u001e:zI\u0011,g-Y;mi\u0012\u001aT\u0003\u0002B \u0005;\"\u0001Ba\u0002\u0003X\t\u0007!\u0011\u0002\u0005\n\u0005C\u0002\u0011\u0013!C\u0001\u0005G\naeZ3u\u001f\nTWm\u0019;t/&$\b.T1uG\"Lgn\u001a)sK\u001aL\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)G\u000b\u0003\u0002J\t\r\u0003\"\u0003B5\u0001E\u0005I\u0011\u0001B2\u0003\u0011:W\r\u001e$jY\u0016\u001cx+\u001b;i\u001b\u0006$8\r[5oOB\u0013XMZ5yI\u0011,g-Y;mi\u0012\u0012\u0004\"\u0003B7\u0001E\u0005I\u0011\u0001B8\u0003A\u0019HO]3b[\u0012\"WMZ1vYR$#'\u0006\u0002\u0003r)\"\u0011Q\u0003B\"\u000f%\u0011)HAA\u0001\u0012\u0003\u00119(\u0001\u0005Tg\t+8m[3u!\ry$\u0011\u0010\u0004\t\u0003\t\t\t\u0011#\u0001\u0003|M!!\u0011\u0010\u0007\u0017\u0011\u001da$\u0011\u0010C\u0001\u0005\u007f\"\"Aa\u001e\t\u0015\t\r%\u0011PI\u0001\n\u0003\u0011))A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0005\u000fS3\u0001\fB\"\u0011)\u0011YI!\u001f\u0002\u0002\u0013%!QR\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0010B\u0019\u0001K!%\n\u0007\tM\u0015K\u0001\u0004PE*,7\r\u001e")
public class S3Bucket
implements Logging,
scala.Serializable {
    private Config config;
    private String configPrefix;
    private Try<String> region;
    private final String bucketName;
    private final Function0<AWSCredentialsProvider> credentialsProvider;
    private transient AmazonS3 _s3;
    private transient TransferManager _transferManager;
    private Logger log;
    private volatile byte bitmap$0;

    public static Function0<AWSCredentialsProvider> $lessinit$greater$default$2() {
        return S3Bucket$.MODULE$.$lessinit$greater$default$2();
    }

    private Logger log$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.log = Logging.log$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.log$lzycompute() : this.log;
    }

    public String bucketName() {
        return this.bucketName;
    }

    private Function0<AWSCredentialsProvider> credentialsProvider() {
        return this.credentialsProvider;
    }

    private Config config$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.config = ConfigFactory.load();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.config;
    }

    private Config config() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.config$lzycompute() : this.config;
    }

    private String configPrefix$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.configPrefix = "aws.s3";
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.configPrefix;
    }

    private String configPrefix() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.configPrefix$lzycompute() : this.configPrefix;
    }

    private Try<String> region$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.region = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.config().getString(this.configPrefix() + ".region"));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.region;
    }

    private Try<String> region() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.region$lzycompute() : this.region;
    }

    private AmazonS3 s3() {
        Object object;
        if (this._s3 == null) {
            ClientConfiguration defaultConfig = new ClientConfiguration().withTcpKeepAlive(true);
            this._s3 = (AmazonS3)((AmazonS3Builder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)this.credentialsProvider().apply()).withClientConfiguration(defaultConfig)).withForceGlobalBucketAccessEnabled(Predef$.MODULE$.boolean2Boolean(true)).build();
            object = !this._s3.doesBucketExistV2(this.bucketName()) ? this._s3.createBucket(new CreateBucketRequest(this.bucketName(), (Region)this.region().map((Function1 & Serializable & scala.Serializable)x$1 -> Region.fromValue((String)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Region.US_Standard))) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return this._s3;
    }

    private TransferManager transferManager() {
        block0: {
            if (this._transferManager != null) break block0;
            ExecutorService executor = Executors.newFixedThreadPool(10, new ThreadFactory(null){
                private int threadCount;

                private int threadCount() {
                    return this.threadCount;
                }

                private void threadCount_$eq(int x$1) {
                    this.threadCount = x$1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Thread newThread(Runnable r) {
                    void var2_2;
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s3-transfer-manager-worker-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.threadCount())})));
                    this.threadCount_$eq(this.threadCount() + 1);
                    return var2_2;
                }
                {
                    this.threadCount = 1;
                }
            });
            ExecutorFactory executorFactory = new ExecutorFactory(null, executor){
                private final ExecutorService executor$1;

                public ExecutorService newExecutor() {
                    return this.executor$1;
                }
                {
                    this.executor$1 = executor$1;
                }
            };
            this._transferManager = TransferManagerBuilder.standard().withS3Client(this.s3()).withExecutorFactory(executorFactory).build();
        }
        return this._transferManager;
    }

    private Tuple3<String, String, String> splitKey(String key) {
        int iExtensionPoint = key.lastIndexOf(46);
        int iSlash = key.lastIndexOf(47);
        String mainKey = iSlash != -1 ? key.substring(0, iSlash) : "";
        String extension = iExtensionPoint != -1 ? key.substring(iExtensionPoint) : "";
        String name = iExtensionPoint != -1 ? key.substring(0, iExtensionPoint) : key;
        return new Tuple3((Object)mainKey, (Object)name, (Object)extension);
    }

    private String sanitizeKey(String key) {
        return key.startsWith("./") ? (String)new StringOps(Predef$.MODULE$.augmentString(key)).drop(2) : key;
    }

    public long size(String key) {
        return BoxesRunTime.unboxToLong((Object)this.retry((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.s3().getObjectMetadata(this.bucketName(), key).getContentLength(), this.retry$default$2(), this.retry$default$3()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public Iterator<S3ObjectSummary> getObjectsWithMatchingPrefix(String prefix, boolean includeDirectories) {
        this.log().info("Finding files matching prefix '{}'...", new Object[]{prefix});
        Iterator listings = package$.MODULE$.Iterator().iterate((Object)this.s3().listObjects(this.bucketName(), this.sanitizeKey(prefix)), (Function1 & Serializable & scala.Serializable)listing -> {
            ObjectListing objectListing;
            if (listing.isTruncated()) {
                this.log().debug("Asking for another batch of objects...");
                objectListing = this.s3().listNextBatchOfObjects(listing);
            } else {
                objectListing = null;
            }
            return objectListing;
        });
        Iterator objects = listings.takeWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)S3Bucket.$anonfun$getObjectsWithMatchingPrefix$2(x$1))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$2.getObjectSummaries()).asScala());
        return includeDirectories ? objects : objects.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)S3Bucket.$anonfun$getObjectsWithMatchingPrefix$4(x$3)));
    }

    public boolean getObjectsWithMatchingPrefix$default$2() {
        return false;
    }

    public Iterator<String> getFilesWithMatchingPrefix(String prefix, boolean includeDirectories) {
        return this.getObjectsWithMatchingPrefix(prefix, includeDirectories).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getKey());
    }

    public boolean getFilesWithMatchingPrefix$default$2() {
        return false;
    }

    public boolean push(String key, File file) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> {
            this.log().info("Pushing '{}' to 's3://{}/{}'", new Object[]{file.getPath(), this.bucketName(), key});
            return this.transferManager().upload(new PutObjectRequest(this.bucketName(), this.sanitizeKey(key), file)).waitForUploadResult();
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean push(String key, InputStream inputStream, Option<Object> length) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> {
            this.log().info("Pushing to 's3://{}/{}'", (Object)this.bucketName(), (Object)key);
            ObjectMetadata metadata = new ObjectMetadata();
            length.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$1 -> metadata.setContentLength(x$1));
            return this.transferManager().upload(new PutObjectRequest(this.bucketName(), this.sanitizeKey(key), inputStream, metadata)).waitForUploadResult();
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean delete(String key) {
        return this.retry((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.s3().deleteObject(this.bucketName(), this.sanitizeKey(key)), this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean exists(String key) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> this.s3().getObjectMetadata(this.bucketName(), key), this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean isDirectory(String key) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.s3().listObjects(new ListObjectsRequest().withBucketName(this.bucketName()).withMaxKeys(Predef$.MODULE$.int2Integer(2)).withPrefix(key)).getObjectSummaries()).asScala(), this.retry$default$2(), this.retry$default$3()).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)S3Bucket.$anonfun$isDirectory$3(key$6, x$6)))));
    }

    public void setAcl(String key, CannedAccessControlList acl) {
        this.log().info("Setting 's3://{}/{}' permissions to '{}'", new Object[]{this.bucketName(), key, acl});
        this.s3().setObjectAcl(this.bucketName(), key, acl);
    }

    public boolean createDirectory(String key) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> {
            this.log().info("Creating directory in 's3://{}/{}'", new Object[]{this.bucketName(), key, null});
            ByteArrayInputStream emptyContent = new ByteArrayInputStream((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(0L);
            return this.s3().putObject(new PutObjectRequest(this.bucketName(), this.sanitizeKey(key) + "/", (InputStream)emptyContent, metadata));
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean backup(String key) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> {
            String sanitizedKey = this.sanitizeKey(key);
            Tuple3<String, String, String> tuple3 = this.splitKey(sanitizedKey);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String mainKey = (String)tuple3._1();
            String name = (String)tuple3._2();
            String extension = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)mainKey, (Object)name, (Object)extension);
            Tuple3 tuple33 = tuple32;
            String mainKey2 = (String)tuple33._1();
            String name2 = (String)tuple33._2();
            String extension2 = (String)tuple33._3();
            return this.s3().copyObject(new CopyObjectRequest(this.bucketName(), sanitizedKey, this.bucketName(), mainKey2 + "/backup/" + name2.substring(mainKey2.length() + 1) + extension2));
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean pull(String key, String destination) {
        return this.retry((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.log().info("Pulling 's3://{}/{}' to '{}'", new Object[]{this.bucketName(), key, destination});
            S3Object s3Object = this.s3().getObject(new GetObjectRequest(this.bucketName(), this.sanitizeKey(key)));
            S3ObjectInputStream inputStream = s3Object.getObjectContent();
            File f = new File(destination).getCanonicalFile();
            f.getParentFile().mkdirs();
            FileOutputStream outputStream = new FileOutputStream(f);
            int read = 0;
            byte[] bytes = new byte[1024];
            read = inputStream.read(bytes);
            while (read != -1) {
                outputStream.write(bytes, 0, read);
                read = inputStream.read(bytes);
            }
            this.log().info("Downloaded 's3://{}/{}' to '{}'. Closing files.", new Object[]{this.bucketName(), key, destination});
            inputStream.close();
            outputStream.flush();
            outputStream.close();
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public InputStream stream(String key, long offset) {
        this.log().info("Streaming 's3://{}/{}' starting at {}", new Object[]{this.bucketName(), key, ((Object)BoxesRunTime.boxToLong((long)offset)).toString()});
        GetObjectRequest req = offset > 0L ? new GetObjectRequest(this.bucketName(), this.sanitizeKey(key)).withRange(offset) : new GetObjectRequest(this.bucketName(), this.sanitizeKey(key));
        return this.s3().getObject(req).getObjectContent();
    }

    public long stream$default$2() {
        return 0L;
    }

    private PartialFunction<Throwable, Object> handler() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                AmazonClientException amazonClientException = null;
                A1 A1 = x1;
                if (A1 instanceof AmazonS3Exception) {
                    Boolean bl2;
                    AmazonS3Exception amazonS3Exception = (AmazonS3Exception)A1;
                    int n = amazonS3Exception.getStatusCode();
                    switch (n) {
                        case 404: {
                            this.$outer.log().error("The specified file does not exist", (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                            break;
                        }
                        case 403: {
                            this.$outer.log().error("No permission to access the file", (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                            break;
                        }
                        default: {
                            this.$outer.log().error(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|S3 service error: ", ". Extended request id: ", "\n                      |Additional details: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{amazonS3Exception.getMessage(), amazonS3Exception.getExtendedRequestId(), amazonS3Exception.getAdditionalDetails()})))).stripMargin(), (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)false);
                            break;
                        }
                    }
                    object = bl2;
                    return (B1)object;
                }
                if (A1 instanceof AmazonServiceException) {
                    AmazonServiceException amazonServiceException = (AmazonServiceException)A1;
                    this.$outer.log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Service error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{amazonServiceException.getMessage()})), (Throwable)amazonServiceException);
                    object = BoxesRunTime.boxToBoolean((boolean)amazonServiceException.isRetryable());
                    return (B1)object;
                }
                if (A1 instanceof AmazonClientException) {
                    bl = true;
                    amazonClientException = (AmazonClientException)A1;
                    String string = amazonClientException.getMessage();
                    String string2 = "Unable to load AWS credentials from any provider in the chain";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.$outer.log().error("Unable to load AWS credentials", (Throwable)amazonClientException);
                        object = BoxesRunTime.boxToBoolean((boolean)true);
                        return (B1)object;
                    }
                }
                if (bl) {
                    this.$outer.log().error("Client error pulling file", (Throwable)amazonClientException);
                    object = BoxesRunTime.boxToBoolean((boolean)amazonClientException.isRetryable());
                    return (B1)object;
                }
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.log().error("An error occurred", (Throwable)exception);
                    object = BoxesRunTime.boxToBoolean((boolean)false);
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Throwable x1) {
                boolean bl = false;
                AmazonClientException amazonClientException = null;
                Throwable throwable = x1;
                if (throwable instanceof AmazonS3Exception) {
                    return true;
                }
                if (throwable instanceof AmazonServiceException) {
                    return true;
                }
                if (throwable instanceof AmazonClientException) {
                    bl = true;
                    amazonClientException = (AmazonClientException)throwable;
                    String string = amazonClientException.getMessage();
                    String string2 = "Unable to load AWS credentials from any provider in the chain";
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) {
                        return true;
                    }
                }
                if (bl) {
                    return true;
                }
                if (!(throwable instanceof Exception)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private <T> Option<T> retry(Function0<T> f, int tries, int sleepTime) {
        None$ none$;
        block4: {
            None$ none$2;
            block5: {
                while (true) {
                    if (tries == 0) {
                        this.log().error("Max retries reached. Aborting S3 operation");
                        none$ = None$.MODULE$;
                        break block4;
                    }
                    Try try_ = Try$.MODULE$.apply(f);
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        Object res = success.value();
                        none$2 = new Some(res);
                        break block5;
                    }
                    if (!(try_ instanceof Failure)) break;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (BoxesRunTime.unboxToBoolean((Object)this.handler().apply((Object)e))) break;
                    if (tries > 1) {
                        this.log().warn("Error during S3 operation. Retrying in {}ms ({} more times)", (Object)BoxesRunTime.boxToInteger((int)sleepTime), (Object)BoxesRunTime.boxToInteger((int)(tries - 1)));
                        Thread.sleep(sleepTime);
                    }
                    --tries;
                }
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        return none$;
    }

    private <T> int retry$default$2() {
        return 3;
    }

    private <T> int retry$default$3() {
        return 5000;
    }

    public boolean equals(Object obj) {
        boolean bl;
        Object object = obj;
        if (object instanceof S3Bucket) {
            S3Bucket s3Bucket = (S3Bucket)object;
            String string = s3Bucket.bucketName();
            String string2 = this.bucketName();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getObjectsWithMatchingPrefix$2(ObjectListing x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getObjectsWithMatchingPrefix$4(S3ObjectSummary x$3) {
        return x$3.getKey().endsWith("/");
    }

    public static final /* synthetic */ boolean $anonfun$isDirectory$3(String key$6, S3ObjectSummary x$6) {
        return x$6.getKey().startsWith(key$6 + "/");
    }

    public S3Bucket(String bucketName, Function0<AWSCredentialsProvider> credentialsProvider) {
        this.bucketName = bucketName;
        this.credentialsProvider = credentialsProvider;
        Logging.$init$(this);
    }
}

