/*
 * Decompiled with CFR 0.152.
 */
package eu.shiftforward.apso.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsSyncClientBuilder;
import com.amazonaws.client.builder.ExecutorFactory;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import eu.shiftforward.apso.Logging;
import eu.shiftforward.apso.aws.S3Bucket$;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tmd\u0001B\u0001\u0003\u0001-\u0011\u0001bU\u001aCk\u000e\\W\r\u001e\u0006\u0003\u0007\u0011\t1!Y<t\u0015\t)a!\u0001\u0003baN|'BA\u0004\t\u00031\u0019\b.\u001b4uM>\u0014x/\u0019:e\u0015\u0005I\u0011AA3v\u0007\u0001\u0019B\u0001\u0001\u0007\u0013-A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003\u000f1{wmZ5oOB\u0011QbF\u0005\u000319\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\u0007\u0001\u0003\u0006\u0004%\taG\u0001\u000bEV\u001c7.\u001a;OC6,W#\u0001\u000f\u0011\u0005u!cB\u0001\u0010#!\tyb\"D\u0001!\u0015\t\t#\"\u0001\u0004=e>|GOP\u0005\u0003G9\ta\u0001\u0015:fI\u00164\u0017BA\u0013'\u0005\u0019\u0019FO]5oO*\u00111E\u0004\u0005\tQ\u0001\u0011\t\u0011)A\u00059\u0005Y!-^2lKRt\u0015-\\3!\u0011!Q\u0003A!b\u0001\n\u0013Y\u0013aE2sK\u0012,g\u000e^5bYN\u0004&o\u001c<jI\u0016\u0014X#\u0001\u0017\u0011\u00075is&\u0003\u0002/\u001d\tIa)\u001e8di&|g\u000e\r\t\u0003a]j\u0011!\r\u0006\u0003eM\nA!Y;uQ*\u0011A'N\u0001\nC6\f'p\u001c8boNT\u0011AN\u0001\u0004G>l\u0017B\u0001\u001d2\u0005Y\tukU\"sK\u0012,g\u000e^5bYN\u0004&o\u001c<jI\u0016\u0014\b\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002)\r\u0014X\rZ3oi&\fGn\u001d)s_ZLG-\u001a:!\u0011\u0015a\u0004\u0001\"\u0001>\u0003\u0019a\u0014N\\5u}Q\u0019a\bQ!\u0011\u0005}\u0002Q\"\u0001\u0002\t\u000biY\u0004\u0019\u0001\u000f\t\u000f)Z\u0004\u0013!a\u0001Y!A1\t\u0001ECB\u0013%A)\u0001\u0004d_:4\u0017nZ\u000b\u0002\u000bB\u0011aIS\u0007\u0002\u000f*\u00111\t\u0013\u0006\u0003\u0013V\n\u0001\u0002^=qKN\fg-Z\u0005\u0003\u0017\u001e\u0013aaQ8oM&<\u0007\u0002C'\u0001\u0011\u000b\u0007K\u0011\u0002(\u0002\u0019\r|gNZ5h!J,g-\u001b=\u0016\u0003=\u0003\"\u0001U+\u000e\u0003ES!AU*\u0002\t1\fgn\u001a\u0006\u0002)\u0006!!.\u0019<b\u0013\t)\u0013\u000b\u0003\u0005X\u0001!\u0015\r\u0015\"\u0003O\u0003!)g\u000e\u001a9pS:$\b\"C-\u0001\u0001\u0004\u0005\t\u0015)\u0003[\u0003\ry6o\r\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000b!a]\u001a\u000b\u0005}\u001b\u0014\u0001C:feZL7-Z:\n\u0005\u0005d&\u0001C!nCj|gnU\u001a)\u0005a\u001b\u0007CA\u0007e\u0013\t)gBA\u0005ue\u0006t7/[3oi\"1Q\f\u0001Q\u0005\n\u001d,\u0012A\u0017\u0005\nS\u0002\u0001\r\u0011!Q!\n)\f\u0001c\u0018;sC:\u001ch-\u001a:NC:\fw-\u001a:\u0011\u0005-tW\"\u00017\u000b\u00055d\u0016\u0001\u0003;sC:\u001ch-\u001a:\n\u0005=d'a\u0004+sC:\u001ch-\u001a:NC:\fw-\u001a:)\u0005!\u001c\u0007B\u0002:\u0001A\u0013%1/A\bue\u0006t7OZ3s\u001b\u0006t\u0017mZ3s+\u0005Q\u0007BB;\u0001A\u0013%a/\u0001\u0005ta2LGoS3z)\t9(\u0010E\u0003\u000eq>{u*\u0003\u0002z\u001d\t1A+\u001e9mKNBQa\u001f;A\u0002q\t1a[3z\u0011\u0019i\b\u0001)C\u0005}\u0006Y1/\u00198ji&TXmS3z)\tar\u0010C\u0003|y\u0002\u0007A\u0004C\u0004\u0002\u0004\u0001!\t!!\u0002\u0002\tML'0\u001a\u000b\u0005\u0003\u000f\ti\u0001E\u0002\u000e\u0003\u0013I1!a\u0003\u000f\u0005\u0011auN\\4\t\rm\f\t\u00011\u0001\u001d\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\tAdZ3u\u001f\nTWm\u0019;t/&$\b.T1uG\"Lgn\u001a)sK\u001aL\u0007\u0010\u0006\u0004\u0002\u0016\u0005M\u0012q\u0007\t\u0007\u0003/\t\t#a\n\u000f\t\u0005e\u0011Q\u0004\b\u0004?\u0005m\u0011\"A\b\n\u0007\u0005}a\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0012Q\u0005\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011q\u0004\b\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f]\u0003\u0015iw\u000eZ3m\u0013\u0011\t\t$a\u000b\u0003\u001fM\u001btJ\u00196fGR\u001cV/\\7befDq!!\u000e\u0002\u0010\u0001\u0007A$\u0001\u0004qe\u00164\u0017\u000e\u001f\u0005\u000b\u0003s\ty\u0001%AA\u0002\u0005m\u0012AE5oG2,H-\u001a#je\u0016\u001cGo\u001c:jKN\u00042!DA\u001f\u0013\r\tyD\u0004\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000b\n!dZ3u\r&dWm],ji\"l\u0015\r^2iS:<\u0007K]3gSb$b!a\u0012\u0002J\u0005-\u0003#BA\f\u0003Ca\u0002bBA\u001b\u0003\u0003\u0002\r\u0001\b\u0005\u000b\u0003s\t\t\u0005%AA\u0002\u0005m\u0002bBA(\u0001\u0011\u0005\u0011\u0011K\u0001\u0005aV\u001c\b\u000e\u0006\u0004\u0002<\u0005M\u0013Q\u000b\u0005\u0007w\u00065\u0003\u0019\u0001\u000f\t\u0011\u0005]\u0013Q\na\u0001\u00033\nAAZ5mKB!\u00111LA1\u001b\t\tiFC\u0002\u0002`M\u000b!![8\n\t\u0005\r\u0014Q\f\u0002\u0005\r&dW\rC\u0004\u0002P\u0001!\t!a\u001a\u0015\u0011\u0005m\u0012\u0011NA6\u0003kBaa_A3\u0001\u0004a\u0002\u0002CA7\u0003K\u0002\r!a\u001c\u0002\u0017%t\u0007/\u001e;TiJ,\u0017-\u001c\t\u0005\u00037\n\t(\u0003\u0003\u0002t\u0005u#aC%oaV$8\u000b\u001e:fC6D\u0001\"a\u001e\u0002f\u0001\u0007\u0011\u0011P\u0001\u0007Y\u0016tw\r\u001e5\u0011\u000b5\tY(a\u0002\n\u0007\u0005udB\u0001\u0004PaRLwN\u001c\u0005\b\u0003\u0003\u0003A\u0011AAB\u0003\u0019!W\r\\3uKR!\u00111HAC\u0011\u0019Y\u0018q\u0010a\u00019!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0015AB3ySN$8\u000f\u0006\u0003\u0002<\u00055\u0005BB>\u0002\b\u0002\u0007A\u0004C\u0004\u0002\u0012\u0002!\t!a%\u0002\u0017%\u001cH)\u001b:fGR|'/\u001f\u000b\u0005\u0003w\t)\n\u0003\u0004|\u0003\u001f\u0003\r\u0001\b\u0005\b\u00033\u0003A\u0011AAN\u0003\u0019\u0019X\r^!dYR1\u0011QTAR\u0003K\u00032!DAP\u0013\r\t\tK\u0004\u0002\u0005+:LG\u000f\u0003\u0004|\u0003/\u0003\r\u0001\b\u0005\t\u0003O\u000b9\n1\u0001\u0002*\u0006\u0019\u0011m\u00197\u0011\t\u0005%\u00121V\u0005\u0005\u0003[\u000bYCA\fDC:tW\rZ!dG\u0016\u001c8oQ8oiJ|G\u000eT5ti\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0016aD2sK\u0006$X\rR5sK\u000e$xN]=\u0015\t\u0005m\u0012Q\u0017\u0005\u0007w\u0006=\u0006\u0019\u0001\u000f\t\u000f\u0005e\u0006\u0001\"\u0001\u0002<\u00061!-Y2lkB$B!a\u000f\u0002>\"110a.A\u0002qAq!!1\u0001\t\u0003\t\u0019-\u0001\u0003qk2dGCBA\u001e\u0003\u000b\f9\r\u0003\u0004|\u0003\u007f\u0003\r\u0001\b\u0005\b\u0003\u0013\fy\f1\u0001\u001d\u0003-!Wm\u001d;j]\u0006$\u0018n\u001c8\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\u000611\u000f\u001e:fC6$B!a\u001c\u0002R\"110a3A\u0002qA\u0001\"!6\u0001A\u0013%\u0011q[\u0001\bQ\u0006tG\r\\3s+\t\tI\u000eE\u0004\u000e\u00037\fy.a\u000f\n\u0007\u0005ugBA\bQCJ$\u0018.\u00197Gk:\u001cG/[8o!\u0011\t9\"!9\n\t\u0005\r\u0018Q\u0005\u0002\n)\"\u0014xn^1cY\u0016D\u0001\"a:\u0001A\u0013%\u0011\u0011^\u0001\u0006e\u0016$(/_\u000b\u0005\u0003W\f\u0019\u0010\u0006\u0005\u0002n\n\u0015!q\u0002B\r!\u0015i\u00111PAx!\u0011\t\t0a=\r\u0001\u0011A\u0011Q_As\u0005\u0004\t9PA\u0001U#\u0011\tI0a@\u0011\u00075\tY0C\u0002\u0002~:\u0011qAT8uQ&tw\rE\u0002\u000e\u0005\u0003I1Aa\u0001\u000f\u0005\r\te.\u001f\u0005\n\u0005\u000f\t)\u000f\"a\u0001\u0005\u0013\t\u0011A\u001a\t\u0006\u001b\t-\u0011q^\u0005\u0004\u0005\u001bq!\u0001\u0003\u001fcs:\fW.\u001a \t\u0015\tE\u0011Q\u001dI\u0001\u0002\u0004\u0011\u0019\"A\u0003ue&,7\u000fE\u0002\u000e\u0005+I1Aa\u0006\u000f\u0005\rIe\u000e\u001e\u0005\u000b\u00057\t)\u000f%AA\u0002\tM\u0011!C:mK\u0016\u0004H+[7f\u0011\u001d\u0011y\u0002\u0001C!\u0005C\ta!Z9vC2\u001cH\u0003BA\u001e\u0005GA\u0001B!\n\u0003\u001e\u0001\u0007\u0011q`\u0001\u0004_\nT\u0007\"\u0003B\u0015\u0001E\u0005I\u0011\u0002B\u0016\u0003=\u0011X\r\u001e:zI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002B\u0017\u0005\u0007*\"Aa\f+\t\tM!\u0011G\u0016\u0003\u0005g\u0001BA!\u000e\u0003@5\u0011!q\u0007\u0006\u0005\u0005s\u0011Y$A\u0005v]\u000eDWmY6fI*\u0019!Q\b\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003B\t]\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012A\u0011Q\u001fB\u0014\u0005\u0004\t9\u0010C\u0005\u0003H\u0001\t\n\u0011\"\u0003\u0003J\u0005y!/\u001a;ss\u0012\"WMZ1vYR$3'\u0006\u0003\u0003.\t-C\u0001CA{\u0005\u000b\u0012\r!a>\t\u0013\t=\u0003!%A\u0005\u0002\tE\u0013AJ4fi>\u0013'.Z2ug^KG\u000f['bi\u000eD\u0017N\\4Qe\u00164\u0017\u000e\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u000b\u0016\u0005\u0003w\u0011\t\u0004C\u0005\u0003X\u0001\t\n\u0011\"\u0001\u0003R\u0005!s-\u001a;GS2,7oV5uQ6\u000bGo\u00195j]\u001e\u0004&/\u001a4jq\u0012\"WMZ1vYR$#gB\u0005\u0003\\\t\t\t\u0011#\u0001\u0003^\u0005A1k\r\"vG.,G\u000fE\u0002@\u0005?2\u0001\"\u0001\u0002\u0002\u0002#\u0005!\u0011M\n\u0005\u0005?ba\u0003C\u0004=\u0005?\"\tA!\u001a\u0015\u0005\tu\u0003B\u0003B5\u0005?\n\n\u0011\"\u0001\u0003l\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"A!\u001c+\u00071\u0012\t\u0004\u0003\u0006\u0003r\t}\u0013\u0011!C\u0005\u0005g\n1B]3bIJ+7o\u001c7wKR\u0011!Q\u000f\t\u0004!\n]\u0014b\u0001B=#\n1qJ\u00196fGR\u0004")
public class S3Bucket
implements Logging,
scala.Serializable {
    private Config config;
    private String configPrefix;
    private String endpoint;
    private final String bucketName;
    private final Function0<AWSCredentialsProvider> credentialsProvider;
    private transient AmazonS3 _s3;
    private transient TransferManager _transferManager;
    private Logger log;
    private volatile byte bitmap$0;

    public static Function0<AWSCredentialsProvider> $lessinit$greater$default$2() {
        return S3Bucket$.MODULE$.$lessinit$greater$default$2();
    }

    private Logger log$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.log = Logging.log$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.log$lzycompute() : this.log;
    }

    public String bucketName() {
        return this.bucketName;
    }

    private Function0<AWSCredentialsProvider> credentialsProvider() {
        return this.credentialsProvider;
    }

    private Config config$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.config = ConfigFactory.load();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.config;
    }

    private Config config() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.config$lzycompute() : this.config;
    }

    private String configPrefix$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.configPrefix = "aws.s3";
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.configPrefix;
    }

    private String configPrefix() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.configPrefix$lzycompute() : this.configPrefix;
    }

    private String endpoint$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.endpoint = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.config().getString(this.configPrefix() + ".endpoint")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "s3.amazonaws.com");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.endpoint;
    }

    private String endpoint() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.endpoint$lzycompute() : this.endpoint;
    }

    private AmazonS3 s3() {
        Object object;
        if (this._s3 == null) {
            ClientConfiguration defaultConfig = new ClientConfiguration().withTcpKeepAlive(true);
            this._s3 = (AmazonS3)((AwsSyncClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)this.credentialsProvider().apply()).withClientConfiguration(defaultConfig)).build();
            this._s3.setEndpoint(this.endpoint());
            object = !this._s3.doesBucketExistV2(this.bucketName()) ? this._s3.createBucket(this.bucketName()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return this._s3;
    }

    private TransferManager transferManager() {
        block0: {
            if (this._transferManager != null) break block0;
            ExecutorService executor = Executors.newFixedThreadPool(10, new ThreadFactory(null){
                private int threadCount;

                private int threadCount() {
                    return this.threadCount;
                }

                private void threadCount_$eq(int x$1) {
                    this.threadCount = x$1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Thread newThread(Runnable r) {
                    void var2_2;
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s3-transfer-manager-worker-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.threadCount())})));
                    this.threadCount_$eq(this.threadCount() + 1);
                    return var2_2;
                }
                {
                    this.threadCount = 1;
                }
            });
            ExecutorFactory executorFactory = new ExecutorFactory(null, executor){
                private final ExecutorService executor$1;

                public ExecutorService newExecutor() {
                    return this.executor$1;
                }
                {
                    this.executor$1 = executor$1;
                }
            };
            this._transferManager = TransferManagerBuilder.standard().withS3Client(this.s3()).withExecutorFactory(executorFactory).build();
        }
        return this._transferManager;
    }

    private Tuple3<String, String, String> splitKey(String key) {
        int iExtensionPoint = key.lastIndexOf(46);
        int iSlash = key.lastIndexOf(47);
        String mainKey = iSlash != -1 ? key.substring(0, iSlash) : "";
        String extension = iExtensionPoint != -1 ? key.substring(iExtensionPoint) : "";
        String name = iExtensionPoint != -1 ? key.substring(0, iExtensionPoint) : key;
        return new Tuple3((Object)mainKey, (Object)name, (Object)extension);
    }

    private String sanitizeKey(String key) {
        return key.startsWith("./") ? (String)new StringOps(Predef$.MODULE$.augmentString(key)).drop(2) : key;
    }

    public long size(String key) {
        return BoxesRunTime.unboxToLong((Object)this.retry((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.s3().getObjectMetadata(this.bucketName(), key).getContentLength(), this.retry$default$2(), this.retry$default$3()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public Iterator<S3ObjectSummary> getObjectsWithMatchingPrefix(String prefix, boolean includeDirectories) {
        this.log().info("Finding files matching prefix '{}'...", new Object[]{prefix});
        Iterator listings = package$.MODULE$.Iterator().iterate((Object)this.s3().listObjects(this.bucketName(), this.sanitizeKey(prefix)), (Function1 & Serializable & scala.Serializable)listing -> {
            ObjectListing objectListing;
            if (listing.isTruncated()) {
                this.log().debug("Asking for another batch of objects...");
                objectListing = this.s3().listNextBatchOfObjects(listing);
            } else {
                objectListing = null;
            }
            return objectListing;
        });
        Iterator objects = listings.takeWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)S3Bucket.$anonfun$getObjectsWithMatchingPrefix$2(x$1))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$2.getObjectSummaries()).asScala());
        return includeDirectories ? objects : objects.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)S3Bucket.$anonfun$getObjectsWithMatchingPrefix$4(x$3)));
    }

    public boolean getObjectsWithMatchingPrefix$default$2() {
        return false;
    }

    public Iterator<String> getFilesWithMatchingPrefix(String prefix, boolean includeDirectories) {
        return this.getObjectsWithMatchingPrefix(prefix, includeDirectories).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getKey());
    }

    public boolean getFilesWithMatchingPrefix$default$2() {
        return false;
    }

    public boolean push(String key, File file) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> {
            this.log().info("Pushing '{}' to 's3://{}/{}'", new Object[]{file.getPath(), this.bucketName(), key});
            return this.transferManager().upload(new PutObjectRequest(this.bucketName(), this.sanitizeKey(key), file)).waitForUploadResult();
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean push(String key, InputStream inputStream, Option<Object> length) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> {
            this.log().info("Pushing to 's3://{}/{}'", (Object)this.bucketName(), (Object)key);
            ObjectMetadata metadata = new ObjectMetadata();
            length.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$1 -> metadata.setContentLength(x$1));
            return this.transferManager().upload(new PutObjectRequest(this.bucketName(), this.sanitizeKey(key), inputStream, metadata)).waitForUploadResult();
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean delete(String key) {
        return this.retry((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.s3().deleteObject(this.bucketName(), this.sanitizeKey(key)), this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean exists(String key) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> this.s3().getObjectMetadata(this.bucketName(), key), this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean isDirectory(String key) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.s3().listObjects(new ListObjectsRequest().withBucketName(this.bucketName()).withMaxKeys(Predef$.MODULE$.int2Integer(2)).withPrefix(key)).getObjectSummaries()).asScala(), this.retry$default$2(), this.retry$default$3()).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)S3Bucket.$anonfun$isDirectory$3(key$6, x$6)))));
    }

    public void setAcl(String key, CannedAccessControlList acl) {
        this.log().info("Setting 's3://{}/{}' permissions to '{}'", new Object[]{this.bucketName(), key, acl});
        this.s3().setObjectAcl(this.bucketName(), key, acl);
    }

    public boolean createDirectory(String key) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> {
            this.log().info("Creating directory in 's3://{}/{}'", new Object[]{this.bucketName(), key, null});
            ByteArrayInputStream emptyContent = new ByteArrayInputStream((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(0L);
            return this.s3().putObject(new PutObjectRequest(this.bucketName(), this.sanitizeKey(key) + "/", (InputStream)emptyContent, metadata));
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean backup(String key) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> {
            String sanitizedKey = this.sanitizeKey(key);
            Tuple3<String, String, String> tuple3 = this.splitKey(sanitizedKey);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String mainKey = (String)tuple3._1();
            String name = (String)tuple3._2();
            String extension = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)mainKey, (Object)name, (Object)extension);
            Tuple3 tuple33 = tuple32;
            String mainKey2 = (String)tuple33._1();
            String name2 = (String)tuple33._2();
            String extension2 = (String)tuple33._3();
            return this.s3().copyObject(new CopyObjectRequest(this.bucketName(), sanitizedKey, this.bucketName(), mainKey2 + "/backup/" + name2.substring(mainKey2.length() + 1) + extension2));
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean pull(String key, String destination) {
        return this.retry((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.log().info("Pulling 's3://{}/{}' to '{}'", new Object[]{this.bucketName(), key, destination});
            S3Object s3Object = this.s3().getObject(new GetObjectRequest(this.bucketName(), this.sanitizeKey(key)));
            S3ObjectInputStream inputStream = s3Object.getObjectContent();
            File f = new File(destination).getCanonicalFile();
            f.getParentFile().mkdirs();
            FileOutputStream outputStream = new FileOutputStream(f);
            int read = 0;
            byte[] bytes = new byte[1024];
            read = inputStream.read(bytes);
            while (read != -1) {
                outputStream.write(bytes, 0, read);
                read = inputStream.read(bytes);
            }
            this.log().info("Downloaded 's3://{}/{}' to '{}'. Closing files.", new Object[]{this.bucketName(), key, destination});
            inputStream.close();
            outputStream.flush();
            outputStream.close();
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public InputStream stream(String key) {
        this.log().info("Streaming 's3://{}/{}'", (Object)this.bucketName(), (Object)key);
        return this.s3().getObject(new GetObjectRequest(this.bucketName(), this.sanitizeKey(key))).getObjectContent();
    }

    private PartialFunction<Throwable, Object> handler() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                AmazonClientException amazonClientException = null;
                A1 A1 = x1;
                if (A1 instanceof AmazonS3Exception) {
                    Boolean bl2;
                    AmazonS3Exception amazonS3Exception = (AmazonS3Exception)A1;
                    int n = amazonS3Exception.getStatusCode();
                    switch (n) {
                        case 404: {
                            this.$outer.log().error("The specified file does not exist", (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                            break;
                        }
                        case 403: {
                            this.$outer.log().error("No permission to access the file", (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                            break;
                        }
                        default: {
                            this.$outer.log().error(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|S3 service error: ", ". Extended request id: ", "\n                      |Additional details: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{amazonS3Exception.getMessage(), amazonS3Exception.getExtendedRequestId(), amazonS3Exception.getAdditionalDetails()})))).stripMargin(), (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)false);
                            break;
                        }
                    }
                    object = bl2;
                    return (B1)object;
                }
                if (A1 instanceof AmazonServiceException) {
                    AmazonServiceException amazonServiceException = (AmazonServiceException)A1;
                    this.$outer.log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Service error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{amazonServiceException.getMessage()})), (Throwable)amazonServiceException);
                    object = BoxesRunTime.boxToBoolean((boolean)amazonServiceException.isRetryable());
                    return (B1)object;
                }
                if (A1 instanceof AmazonClientException) {
                    bl = true;
                    amazonClientException = (AmazonClientException)A1;
                    String string = amazonClientException.getMessage();
                    String string2 = "Unable to load AWS credentials from any provider in the chain";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.$outer.log().error("Unable to load AWS credentials", (Throwable)amazonClientException);
                        object = BoxesRunTime.boxToBoolean((boolean)true);
                        return (B1)object;
                    }
                }
                if (bl) {
                    this.$outer.log().error("Client error pulling file", (Throwable)amazonClientException);
                    object = BoxesRunTime.boxToBoolean((boolean)amazonClientException.isRetryable());
                    return (B1)object;
                }
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.log().error("An error occurred", (Throwable)exception);
                    object = BoxesRunTime.boxToBoolean((boolean)false);
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Throwable x1) {
                boolean bl = false;
                AmazonClientException amazonClientException = null;
                Throwable throwable = x1;
                if (throwable instanceof AmazonS3Exception) {
                    return true;
                }
                if (throwable instanceof AmazonServiceException) {
                    return true;
                }
                if (throwable instanceof AmazonClientException) {
                    bl = true;
                    amazonClientException = (AmazonClientException)throwable;
                    String string = amazonClientException.getMessage();
                    String string2 = "Unable to load AWS credentials from any provider in the chain";
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) {
                        return true;
                    }
                }
                if (bl) {
                    return true;
                }
                if (!(throwable instanceof Exception)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private <T> Option<T> retry(Function0<T> f, int tries, int sleepTime) {
        None$ none$;
        block4: {
            None$ none$2;
            block5: {
                while (true) {
                    if (tries == 0) {
                        this.log().error("Max retries reached. Aborting S3 operation");
                        none$ = None$.MODULE$;
                        break block4;
                    }
                    Try try_ = Try$.MODULE$.apply(f);
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        Object res = success.value();
                        none$2 = new Some(res);
                        break block5;
                    }
                    if (!(try_ instanceof Failure)) break;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (BoxesRunTime.unboxToBoolean((Object)this.handler().apply((Object)e))) break;
                    if (tries > 1) {
                        this.log().warn("Error during S3 operation. Retrying in {}ms ({} more times)", (Object)BoxesRunTime.boxToInteger((int)sleepTime), (Object)BoxesRunTime.boxToInteger((int)(tries - 1)));
                        Thread.sleep(sleepTime);
                    }
                    --tries;
                }
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        return none$;
    }

    private <T> int retry$default$2() {
        return 3;
    }

    private <T> int retry$default$3() {
        return 5000;
    }

    public boolean equals(Object obj) {
        boolean bl;
        Object object = obj;
        if (object instanceof S3Bucket) {
            S3Bucket s3Bucket = (S3Bucket)object;
            String string = s3Bucket.bucketName();
            String string2 = this.bucketName();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getObjectsWithMatchingPrefix$2(ObjectListing x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getObjectsWithMatchingPrefix$4(S3ObjectSummary x$3) {
        return x$3.getKey().endsWith("/");
    }

    public static final /* synthetic */ boolean $anonfun$isDirectory$3(String key$6, S3ObjectSummary x$6) {
        return x$6.getKey().startsWith(key$6 + "/");
    }

    public S3Bucket(String bucketName, Function0<AWSCredentialsProvider> credentialsProvider) {
        this.bucketName = bucketName;
        this.credentialsProvider = credentialsProvider;
        Logging.$init$(this);
    }
}

