/*
 * Decompiled with CFR 0.152.
 */
package eu.shiftforward.apso.hashing;

import java.nio.charset.Charset;

public class MurmurHash3 {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    static long getblock(byte[] byArray, int n) {
        return (long)byArray[n + 0] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    static void bmix(State state) {
        state.k1 *= state.c1;
        state.k1 = state.k1 << 23 | state.k1 >>> 41;
        state.k1 *= state.c2;
        state.h1 ^= state.k1;
        state.h1 += state.h2;
        state.h2 = state.h2 << 41 | state.h2 >>> 23;
        state.k2 *= state.c2;
        state.k2 = state.k2 << 23 | state.k2 >>> 41;
        state.k2 *= state.c1;
        state.h2 ^= state.k2;
        state.h2 += state.h1;
        state.h1 = state.h1 * 3L + 1390208809L;
        state.h2 = state.h2 * 3L + 944331445L;
        state.c1 = state.c1 * 5L + 2071795100L;
        state.c2 = state.c2 * 5L + 1808688022L;
    }

    static long fmix(long l) {
        l ^= l >>> 33;
        l *= -49064778989728563L;
        l ^= l >>> 33;
        l *= -4265267296055464877L;
        l ^= l >>> 33;
        return l;
    }

    public static long[] MurmurHash3_x64_128(byte[] byArray, int n) {
        int n2;
        State state = new State();
        state.h1 = 0x9368E53C2F6AF274L ^ (long)n;
        state.h2 = 0x586DCD208F7CD3FDL ^ (long)n;
        state.c1 = -8663945395140668459L;
        state.c2 = 5545529020109919103L;
        for (n2 = 0; n2 < byArray.length / 16; ++n2) {
            state.k1 = MurmurHash3.getblock(byArray, n2 * 2 * 8);
            state.k2 = MurmurHash3.getblock(byArray, (n2 * 2 + 1) * 8);
            MurmurHash3.bmix(state);
        }
        state.k1 = 0L;
        state.k2 = 0L;
        n2 = byArray.length >>> 4 << 4;
        switch (byArray.length & 0xF) {
            case 15: {
                state.k2 ^= (long)byArray[n2 + 14] << 48;
            }
            case 14: {
                state.k2 ^= (long)byArray[n2 + 13] << 40;
            }
            case 13: {
                state.k2 ^= (long)byArray[n2 + 12] << 32;
            }
            case 12: {
                state.k2 ^= (long)byArray[n2 + 11] << 24;
            }
            case 11: {
                state.k2 ^= (long)byArray[n2 + 10] << 16;
            }
            case 10: {
                state.k2 ^= (long)byArray[n2 + 9] << 8;
            }
            case 9: {
                state.k2 ^= (long)byArray[n2 + 8];
            }
            case 8: {
                state.k1 ^= (long)byArray[n2 + 7] << 56;
            }
            case 7: {
                state.k1 ^= (long)byArray[n2 + 6] << 48;
            }
            case 6: {
                state.k1 ^= (long)byArray[n2 + 5] << 40;
            }
            case 5: {
                state.k1 ^= (long)byArray[n2 + 4] << 32;
            }
            case 4: {
                state.k1 ^= (long)byArray[n2 + 3] << 24;
            }
            case 3: {
                state.k1 ^= (long)byArray[n2 + 2] << 16;
            }
            case 2: {
                state.k1 ^= (long)byArray[n2 + 1] << 8;
            }
            case 1: {
                state.k1 ^= (long)byArray[n2 + 0];
                MurmurHash3.bmix(state);
            }
        }
        state.h2 ^= (long)byArray.length;
        state.h1 += state.h2;
        state.h2 += state.h1;
        state.h1 = MurmurHash3.fmix(state.h1);
        state.h2 = MurmurHash3.fmix(state.h2);
        state.h1 += state.h2;
        state.h2 += state.h1;
        return new long[]{state.h1, state.h2};
    }

    public static long MurmurHash3_x64_64(byte[] byArray, int n) {
        int n2;
        State state = new State();
        state.h1 = 0x9368E53C2F6AF274L ^ (long)n;
        state.h2 = 0x586DCD208F7CD3FDL ^ (long)n;
        state.c1 = -8663945395140668459L;
        state.c2 = 5545529020109919103L;
        for (n2 = 0; n2 < byArray.length / 16; ++n2) {
            state.k1 = MurmurHash3.getblock(byArray, n2 * 2 * 8);
            state.k2 = MurmurHash3.getblock(byArray, (n2 * 2 + 1) * 8);
            MurmurHash3.bmix(state);
        }
        state.k1 = 0L;
        state.k2 = 0L;
        n2 = byArray.length >>> 4 << 4;
        switch (byArray.length & 0xF) {
            case 15: {
                state.k2 ^= (long)byArray[n2 + 14] << 48;
            }
            case 14: {
                state.k2 ^= (long)byArray[n2 + 13] << 40;
            }
            case 13: {
                state.k2 ^= (long)byArray[n2 + 12] << 32;
            }
            case 12: {
                state.k2 ^= (long)byArray[n2 + 11] << 24;
            }
            case 11: {
                state.k2 ^= (long)byArray[n2 + 10] << 16;
            }
            case 10: {
                state.k2 ^= (long)byArray[n2 + 9] << 8;
            }
            case 9: {
                state.k2 ^= (long)byArray[n2 + 8];
            }
            case 8: {
                state.k1 ^= (long)byArray[n2 + 7] << 56;
            }
            case 7: {
                state.k1 ^= (long)byArray[n2 + 6] << 48;
            }
            case 6: {
                state.k1 ^= (long)byArray[n2 + 5] << 40;
            }
            case 5: {
                state.k1 ^= (long)byArray[n2 + 4] << 32;
            }
            case 4: {
                state.k1 ^= (long)byArray[n2 + 3] << 24;
            }
            case 3: {
                state.k1 ^= (long)byArray[n2 + 2] << 16;
            }
            case 2: {
                state.k1 ^= (long)byArray[n2 + 1] << 8;
            }
            case 1: {
                state.k1 ^= (long)byArray[n2 + 0];
                MurmurHash3.bmix(state);
            }
        }
        state.h2 ^= (long)byArray.length;
        state.h1 += state.h2;
        state.h2 += state.h1;
        state.h1 = MurmurHash3.fmix(state.h1);
        state.h2 = MurmurHash3.fmix(state.h2);
        state.h1 += state.h2;
        state.h2 += state.h1;
        return state.h1;
    }

    public static int MurmurHash3_x64_32(byte[] byArray, int n) {
        return (int)(MurmurHash3.MurmurHash3_x64_64(byArray, n) >>> 32);
    }

    public static long[] MurmurHash3_x64_128(long[] lArray, int n) {
        State state = new State();
        state.h1 = 0x9368E53C2F6AF274L ^ (long)n;
        state.h2 = 0x586DCD208F7CD3FDL ^ (long)n;
        state.c1 = -8663945395140668459L;
        state.c2 = 5545529020109919103L;
        for (int i = 0; i < lArray.length / 2; ++i) {
            state.k1 = lArray[i * 2];
            state.k2 = lArray[i * 2 + 1];
            MurmurHash3.bmix(state);
        }
        long l = lArray[lArray.length - 1];
        if (lArray.length % 2 != 0) {
            state.k1 ^= l;
            MurmurHash3.bmix(state);
        }
        state.h2 ^= (long)(lArray.length * 8);
        state.h1 += state.h2;
        state.h2 += state.h1;
        state.h1 = MurmurHash3.fmix(state.h1);
        state.h2 = MurmurHash3.fmix(state.h2);
        state.h1 += state.h2;
        state.h2 += state.h1;
        return new long[]{state.h1, state.h2};
    }

    public static long MurmurHash3_x64_64(long[] lArray, int n) {
        State state = new State();
        state.h1 = 0x9368E53C2F6AF274L ^ (long)n;
        state.h2 = 0x586DCD208F7CD3FDL ^ (long)n;
        state.c1 = -8663945395140668459L;
        state.c2 = 5545529020109919103L;
        for (int i = 0; i < lArray.length / 2; ++i) {
            state.k1 = lArray[i * 2];
            state.k2 = lArray[i * 2 + 1];
            MurmurHash3.bmix(state);
        }
        long l = lArray[lArray.length - 1];
        if (lArray.length % 2 != 0) {
            state.k1 ^= l;
            MurmurHash3.bmix(state);
        }
        state.h2 ^= (long)(lArray.length * 8);
        state.h1 += state.h2;
        state.h2 += state.h1;
        state.h1 = MurmurHash3.fmix(state.h1);
        state.h2 = MurmurHash3.fmix(state.h2);
        state.h1 += state.h2;
        state.h2 += state.h1;
        return state.h1;
    }

    public static int MurmurHash3_x64_32(long[] lArray, int n) {
        return (int)(MurmurHash3.MurmurHash3_x64_64(lArray, n) >>> 32);
    }

    public int hash(byte[] byArray) {
        return MurmurHash3.MurmurHash3_x64_32(byArray, 9001);
    }

    public static int hash(long[] lArray) {
        return MurmurHash3.MurmurHash3_x64_32(lArray, 9001);
    }

    public int hash(int n) {
        byte by = (byte)n;
        byte by2 = (byte)(n >>> 8);
        byte by3 = (byte)(n >>> 16);
        byte by4 = (byte)(n >>> 24);
        State state = new State();
        state.h1 = -7824752305899908771L;
        state.h2 = 6371974587529097428L;
        state.c1 = -8663945395140668459L;
        state.c2 = 5545529020109919103L;
        state.k1 = 0L;
        state.k2 = 0L;
        state.k1 ^= (long)by4 << 24;
        state.k1 ^= (long)by3 << 16;
        state.k1 ^= (long)by2 << 8;
        state.k1 ^= (long)by;
        MurmurHash3.bmix(state);
        state.h2 ^= 4L;
        state.h1 += state.h2;
        state.h2 += state.h1;
        state.h1 = MurmurHash3.fmix(state.h1);
        state.h2 = MurmurHash3.fmix(state.h2);
        state.h1 += state.h2;
        state.h2 += state.h1;
        return (int)(state.h1 >>> 32);
    }

    public int hash(Object object) {
        if (object instanceof byte[]) {
            return this.hash((byte[])object);
        }
        if (object instanceof long[]) {
            return MurmurHash3.hash((long[])object);
        }
        if (object instanceof String) {
            return this.hash(((String)object).getBytes(UTF8));
        }
        return this.hash(object.hashCode());
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass();
    }

    public String toString() {
        return "MurmurHash3";
    }

    static class State {
        long h1;
        long h2;
        long k1;
        long k2;
        long c1;
        long c2;

        State() {
        }
    }
}

