/*
 * Decompiled with CFR 0.152.
 */
package eu.shiftforward.apso.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.impl.Parseable;
import eu.shiftforward.apso.config.LazyConfigFactory;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;

public final class LazyConfigFactory$ {
    public static LazyConfigFactory$ MODULE$;
    private Config load;
    private volatile boolean bitmap$0;

    static {
        new LazyConfigFactory$();
    }

    private Config load$lzycompute() {
        LazyConfigFactory$ lazyConfigFactory$ = this;
        synchronized (lazyConfigFactory$) {
            if (!this.bitmap$0) {
                this.load = this.load(ConfigParseOptions.defaults(), ConfigResolveOptions.defaults());
                this.bitmap$0 = true;
            }
        }
        return this.load;
    }

    public Config load() {
        return !this.bitmap$0 ? this.load$lzycompute() : this.load;
    }

    public Config load(String resourceBasename) {
        return this.load(ConfigFactory.parseResourcesAnySyntax((String)resourceBasename), ConfigParseOptions.defaults(), ConfigResolveOptions.defaults());
    }

    public Config load(ConfigParseOptions parseOptions, ConfigResolveOptions resolveOptions) {
        return this.load(this.defaultApplication(parseOptions), parseOptions, resolveOptions);
    }

    public Config load(Config config, ConfigParseOptions parseOptions, ConfigResolveOptions resolveOptions) {
        return this.defaultOverrides(parseOptions).withFallback((ConfigMergeable)config).withFallback((ConfigMergeable)this.defaultEnvReference(parseOptions)).withFallback((ConfigMergeable)this.defaultReference(parseOptions)).resolve(resolveOptions);
    }

    public Config defaultOverrides(ConfigParseOptions parseOptions) {
        return ConfigFactory.systemProperties().withFallback((ConfigMergeable)Parseable.newResources((String)"overrides.conf", (ConfigParseOptions)parseOptions).parse().toConfig());
    }

    public Config defaultApplication(ConfigParseOptions parseOptions) {
        Config config;
        String url;
        String file;
        ClassLoader loader = parseOptions.getClassLoader();
        if (loader == null) {
            throw new ConfigException.BugOrBroken("ClassLoader should have been set here; bug in ConfigFactory. (You can probably work around this bug by passing in a class loader or calling currentThread().setContextClassLoader() though.)");
        }
        int specified = 0;
        String resource = System.getProperty("config.resource");
        if (resource != null) {
            ++specified;
        }
        if ((file = System.getProperty("config.file")) != null) {
            ++specified;
        }
        if ((url = System.getProperty("config.url")) != null) {
            ++specified;
        }
        if (specified == 0) {
            config = ConfigFactory.parseResourcesAnySyntax((ClassLoader)loader, (String)"application", (ConfigParseOptions)parseOptions);
        } else {
            if (specified > 1) {
                throw new ConfigException.Generic("You set more than one of config.file='" + file + "', config.url='" + url + "', config.resource='" + resource + "'; don't know which one to use!");
            }
            ConfigParseOptions overrideOptions = parseOptions.setAllowMissing(false);
            if (resource != null) {
                if (resource.startsWith("/")) {
                    resource = resource.substring(1);
                }
                config = ConfigFactory.parseResources((ClassLoader)loader, (String)resource, (ConfigParseOptions)overrideOptions);
            } else if (file != null) {
                config = ConfigFactory.parseFile((File)new File(file), (ConfigParseOptions)overrideOptions);
            } else {
                try {
                    config = ConfigFactory.parseURL((URL)new URL(url), (ConfigParseOptions)overrideOptions);
                }
                catch (MalformedURLException e) {
                    throw new ConfigException.Generic("Bad URL in config.url system property: '" + url + "': " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return config;
    }

    public Config defaultReference(ConfigParseOptions parseOptions) {
        return Parseable.newResources((String)"reference.conf", (ConfigParseOptions)parseOptions).parse().toConfig();
    }

    public Config defaultEnvReference(ConfigParseOptions parseOptions) {
        String configEnv = (String)Option$.MODULE$.apply((Object)System.getProperty("apso.configloader.env")).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)System.getenv("CONFIG_ENV"))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "development");
        return Parseable.newResources((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configEnv})), (ConfigParseOptions)parseOptions).parse().toConfig();
    }

    public Config eu$shiftforward$apso$config$LazyConfigFactory$$stringAsConfig(String str) {
        return ConfigFactory.parseString((String)str);
    }

    public Config eu$shiftforward$apso$config$LazyConfigFactory$$seqKeyValueConfig(Seq<Tuple2<String, Object>> str) {
        return (Config)str.foldLeft((Object)ConfigFactory.empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Config acc;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    acc = (Config)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String path = (String)tuple2._1();
            Object v = tuple2._2();
            Config config = ConfigFactory.parseString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, v}))).withFallback((ConfigMergeable)acc);
            return config;
        });
    }

    public LazyConfigFactory.Builder loadAt(String path) {
        return new LazyConfigFactory.AtPathBuilder(path);
    }

    private LazyConfigFactory$() {
        MODULE$ = this;
    }
}

