/*
 * Decompiled with CFR 0.152.
 */
package eu.shiftforward.apso.io;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import eu.shiftforward.apso.config.FileDescriptorCredentials;
import eu.shiftforward.apso.config.Implicits$;
import eu.shiftforward.apso.config.Implicits$ApsoConfig$;
import eu.shiftforward.apso.io.SftpFileDescriptor;
import io.github.andrebeat.pool.Lease;
import io.github.andrebeat.pool.Pool;
import io.github.andrebeat.pool.Pool$;
import io.github.andrebeat.pool.ReferenceType;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ConcurrentHashMap;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple7;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import scala.util.matching.Regex;

public final class SftpFileDescriptor$
implements scala.Serializable {
    public static SftpFileDescriptor$ MODULE$;
    private final Config config;
    private final int maxConnections;
    private final java.time.Duration maxIdleTime;
    private final ConcurrentHashMap<String, Pool<SftpFileDescriptor.SftpClient>> connectionPools;
    private final Regex idRegex;
    private final FileDescriptorCredentials<Tuple3<String, String, Either<Tuple2<File, Option<String>>, String>>> credentials;

    static {
        new SftpFileDescriptor$();
    }

    public SFTPClient sftpClientToSFTPClient(SftpFileDescriptor.SftpClient c) {
        return c.sftpClient();
    }

    private SSHClient sshClient(String host, int port, String username, Option<String> password, Option<Tuple2<File, Option<String>>> identity) {
        Some some;
        Tuple2 tuple2;
        Option option;
        Option option2;
        SSHClient sshClient = new SSHClient();
        sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        sshClient.useCompression();
        sshClient.connect(host, port);
        Tuple2 tuple22 = new Tuple2(password, identity);
        if (tuple22 != null && (option2 = (Option)tuple22._1()) instanceof Some) {
            sshClient.authPassword(username, (String)password.get());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (tuple22 != null && (option = (Option)tuple22._2()) instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            KeyProvider keyProvider;
            File f = (File)tuple2._1();
            Option p = (Option)tuple2._2();
            Option option3 = p;
            if (option3 instanceof Some) {
                Some some2 = (Some)option3;
                String passphrase = (String)some2.value();
                keyProvider = sshClient.loadKeys(f.getAbsolutePath(), passphrase);
            } else if (None$.MODULE$.equals(option3)) {
                keyProvider = sshClient.loadKeys(f.getAbsolutePath());
            } else {
                throw new MatchError((Object)option3);
            }
            KeyProvider keyProvider2 = keyProvider;
            sshClient.authPublickey(username, new KeyProvider[]{keyProvider2});
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException("Either a password or pub-priv key identity must be provided");
        }
        return sshClient;
    }

    public Lease<SftpFileDescriptor.SftpClient> eu$shiftforward$apso$io$SftpFileDescriptor$$acquireConnection(String host, int port, String username, Option<String> password, Option<Tuple2<File, Option<String>>> identity) {
        Pool pool;
        Pool p = this.connectionPools.get(host);
        if (p == null) {
            SftpFileDescriptor$ sftpFileDescriptor$ = this;
            synchronized (sftpFileDescriptor$) {
                int x$18 = this.maxConnections;
                Function0 & Serializable & scala.Serializable x$19 = (Function0 & Serializable & scala.Serializable)() -> new SftpFileDescriptor.SftpClient(this.sshClient(host, port, username, password, identity));
                Function1 & Serializable & scala.Serializable x$20 = (Function1 & Serializable & scala.Serializable)c -> {
                    c.close();
                    return BoxedUnit.UNIT;
                };
                FiniteDuration x$21 = Implicits$.MODULE$.durationToFiniteDuration(this.maxIdleTime);
                ReferenceType x$22 = Pool$.MODULE$.apply$default$3();
                Function1 x$23 = Pool$.MODULE$.apply$default$5();
                Function1 x$24 = Pool$.MODULE$.apply$default$7();
                Pool pool2 = Pool$.MODULE$.apply(x$18, (Function0)x$19, x$22, (Duration)x$21, x$23, (Function1)x$20, x$24);
                this.connectionPools.put(host, (Pool<SftpFileDescriptor.SftpClient>)pool2);
                Pool pool3 = pool2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var8_7
                pool = pool3;
            }
        } else {
            pool = p;
        }
        Pool pool4 = pool;
        return pool4.acquire();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple3<String, Object, String> eu$shiftforward$apso$io$SftpFileDescriptor$$splitMeta(String url) {
        Option option;
        String string = url;
        Option option2 = this.idRegex.unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(4) == 0) {
            String id = (String)((LinearSeqOptimized)option2.get()).apply(1);
            String string2 = (String)((LinearSeqOptimized)option2.get()).apply(2);
            String path = (String)((LinearSeqOptimized)option2.get()).apply(3);
            if (string2 == null) {
                return new Tuple3((Object)id, (Object)BoxesRunTime.boxToInteger((int)22), (Object)path);
            }
        }
        if ((option = this.idRegex.unapplySeq((CharSequence)string)).isEmpty()) throw new IllegalArgumentException("Error parsing SFTP URI.");
        if (option.get() == null) throw new IllegalArgumentException("Error parsing SFTP URI.");
        if (((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) throw new IllegalArgumentException("Error parsing SFTP URI.");
        String id = (String)((LinearSeqOptimized)option.get()).apply(1);
        String port = (String)((LinearSeqOptimized)option.get()).apply(2);
        String path = (String)((LinearSeqOptimized)option.get()).apply(3);
        return new Tuple3((Object)id, (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(port)).drop(1))).toInt()), (Object)path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SftpFileDescriptor apply(String host, int port, String url, String username, Option<String> password, Option<Tuple2<File, Option<String>>> identity, Predef.DummyImplicit d) {
        Nil$ nil$;
        String path;
        Tuple3<String, Object, String> tuple3 = this.eu$shiftforward$apso$io$SftpFileDescriptor$$splitMeta(url);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String string = path = (String)tuple3._3();
        String path2 = string;
        List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path2.split("/"))).toList();
        if (Nil$.MODULE$.equals(list)) {
            nil$ = Nil$.MODULE$;
        } else {
            if (!(list instanceof .colon.colon)) throw new IllegalArgumentException("Error parsing SFTP URI. Only absolute paths are supported.");
            .colon.colon colon2 = (.colon.colon)list;
            String string2 = (String)colon2.head();
            List list2 = colon2.tl$access$1();
            if (!"".equals(string2) || !(list2 instanceof .colon.colon)) throw new IllegalArgumentException("Error parsing SFTP URI. Only absolute paths are supported.");
            .colon.colon colon3 = (.colon.colon)list2;
            String hd = (String)colon3.head();
            List tail = colon3.tl$access$1();
            String string3 = hd;
            nil$ = tail.$colon$colon((Object)string3);
        }
        Nil$ elements = nil$;
        return new SftpFileDescriptor(host, port, username, password, (List<String>)elements, identity, this.apply$default$7());
    }

    public SftpFileDescriptor apply(String host, int port, String url, String username, Option<String> password, Predef.DummyImplicit d) {
        return this.apply(host, port, url, username, password, (Option<Tuple2<File, Option<String>>>)None$.MODULE$, d);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SftpFileDescriptor apply(String url, Option<Tuple3<String, String, Either<Tuple2<File, Option<String>>, String>>> credentials) {
        int port;
        Tuple3 creds = (Tuple3)credentials.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No credentials found."})).s((Seq)Nil$.MODULE$));
        });
        Tuple3<String, Object, String> tuple3 = this.eu$shiftforward$apso$io$SftpFileDescriptor$$splitMeta(url);
        if (tuple3 == null) throw new MatchError(tuple3);
        int n = port = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int port2 = n;
        Tuple3 tuple32 = creds;
        if (tuple32 != null) {
            String host = (String)tuple32._1();
            String username = (String)tuple32._2();
            Either either = (Either)tuple32._3();
            if (either instanceof Left) {
                Left left = (Left)either;
                Tuple2 identity = (Tuple2)left.value();
                return this.apply(host, port2, url, username, (Option<String>)None$.MODULE$, (Option<Tuple2<File, Option<String>>>)new Some((Object)identity), Predef.DummyImplicit$.MODULE$.dummyImplicit());
            }
        }
        if (tuple32 == null) throw new MatchError((Object)tuple32);
        String host = (String)tuple32._1();
        String username = (String)tuple32._2();
        Either either = (Either)tuple32._3();
        if (!(either instanceof Right)) throw new MatchError((Object)tuple32);
        Right right = (Right)either;
        String password = (String)right.value();
        return this.apply(host, port2, url, username, (Option<String>)new Some((Object)password), (Option<Tuple2<File, Option<String>>>)None$.MODULE$, Predef.DummyImplicit$.MODULE$.dummyImplicit());
    }

    public SftpFileDescriptor apply(String path, Config credentialsConfig) {
        return this.apply(path, this.credentials.read(credentialsConfig, path));
    }

    public Option<FileAttributes> apply$default$7() {
        return None$.MODULE$;
    }

    public SftpFileDescriptor apply(String host, int port, String username, Option<String> password, List<String> elements, Option<Tuple2<File, Option<String>>> identity, Option<FileAttributes> _fileAttributes) {
        return new SftpFileDescriptor(host, port, username, password, elements, identity, _fileAttributes);
    }

    public Option<Tuple7<String, Object, String, Option<String>, List<String>, Option<Tuple2<File, Option<String>>>, Option<FileAttributes>>> unapply(SftpFileDescriptor x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.host(), (Object)BoxesRunTime.boxToInteger((int)x$0.port()), (Object)x$0.username(), x$0.password(), x$0.elements(), x$0.identity(), x$0.eu$shiftforward$apso$io$SftpFileDescriptor$$_fileAttributes()));
    }

    public Option<FileAttributes> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SftpFileDescriptor$() {
        MODULE$ = this;
        this.config = ConfigFactory.load();
        this.maxConnections = this.config.getInt("apso.io.file-descriptor.sftp.max-connections-per-host");
        this.maxIdleTime = this.config.getDuration("apso.io.file-descriptor.sftp.max-idle-time");
        this.connectionPools = new ConcurrentHashMap();
        this.idRegex = new StringOps(Predef$.MODULE$.augmentString("(.*@)?([\\-|\\d|\\w|\\.]+)(:\\d+)?(\\/.*)")).r();
        this.credentials = new FileDescriptorCredentials<Tuple3<String, String, Either<Tuple2<File, Option<String>>, String>>>(){

            public Option<Tuple3<String, String, Either<Tuple2<File, Option<String>>, String>>> read(Config config, String path) {
                return FileDescriptorCredentials.read$(this, config, path);
            }

            public final String protocol() {
                return "sftp";
            }

            public String id(String path) {
                return (String)SftpFileDescriptor$.MODULE$.eu$shiftforward$apso$io$SftpFileDescriptor$$splitMeta(path)._1();
            }

            public Tuple3<String, String, Either<Tuple2<File, Option<String>>, String>> createCredentials(String hostname, Config sftpConfig) {
                String username = sftpConfig.getString("username");
                Either creds = (Either)Implicits$ApsoConfig$.MODULE$.getStringOption$extension(Implicits$.MODULE$.ApsoConfig(sftpConfig), "keypair-file").map((Function1 & Serializable & scala.Serializable)fname -> package$.MODULE$.Left().apply((Object)new Tuple2((Object)new File(Properties$.MODULE$.userHome() + "/.ssh/" + fname), Implicits$ApsoConfig$.MODULE$.getStringOption$extension(Implicits$.MODULE$.ApsoConfig(sftpConfig), "passphrase")))).orElse((Function0 & Serializable & scala.Serializable)() -> Implicits$ApsoConfig$.MODULE$.getStringOption$extension(Implicits$.MODULE$.ApsoConfig(sftpConfig), "password").map((Function1 & Serializable & scala.Serializable)x$16 -> package$.MODULE$.Right().apply(x$16))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalArgumentException("Error parsing SFTP URI. No keypair file or password provided.");
                });
                return new Tuple3((Object)hostname, (Object)username, (Object)creds);
            }
            {
                FileDescriptorCredentials.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createCredentials$1(com.typesafe.config.Config java.lang.String ), $anonfun$createCredentials$2(com.typesafe.config.Config ), $anonfun$createCredentials$4(), $anonfun$createCredentials$3(java.lang.String )}, serializedLambda);
            }
        };
    }
}

