/*
 * Decompiled with CFR 0.152.
 */
package eu.shiftforward.apso.io;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.typesafe.config.Config;
import eu.shiftforward.apso.aws.S3Bucket;
import eu.shiftforward.apso.aws.S3Bucket$;
import eu.shiftforward.apso.aws.SerializableAWSCredentials;
import eu.shiftforward.apso.aws.SerializableAWSCredentials$;
import eu.shiftforward.apso.config.FileDescriptorCredentials;
import eu.shiftforward.apso.io.S3FileDescriptor;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class S3FileDescriptor$
implements scala.Serializable {
    public static S3FileDescriptor$ MODULE$;
    private final FileDescriptorCredentials<SerializableAWSCredentials> credentials;
    private final TrieMap<String, S3Bucket> s3Buckets;

    static {
        new S3FileDescriptor$();
    }

    public S3FileDescriptor apply(String path) {
        return this.apply(path, (Option<SerializableAWSCredentials>)None$.MODULE$);
    }

    public S3FileDescriptor apply(String path, Config credentialsConfig) {
        return this.apply(path, this.credentials().read(credentialsConfig, path));
    }

    public S3FileDescriptor apply(String path, BasicAWSCredentials credentials) {
        return this.apply(path, (Option<SerializableAWSCredentials>)new Some((Object)SerializableAWSCredentials$.MODULE$.apply(credentials)));
    }

    public S3FileDescriptor apply(String path, SerializableAWSCredentials credentials) {
        return this.apply(path, (Option<SerializableAWSCredentials>)new Some((Object)credentials));
    }

    private S3FileDescriptor apply(String path, Option<SerializableAWSCredentials> credentials) {
        List list = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(path)).split('/'))).toList();
        if (!(list instanceof .colon.colon)) {
            throw new IllegalArgumentException("Error parsing S3 URI");
        }
        .colon.colon colon2 = (.colon.colon)list;
        String s3bucket = (String)colon2.head();
        List s3path = colon2.tl$access$1();
        S3Bucket s3BucketRef = (S3Bucket)this.s3Buckets().getOrElseUpdate((Object)s3bucket, (Function0 & Serializable & scala.Serializable)() -> S3FileDescriptor$.newBucket$1(credentials, s3bucket));
        S3FileDescriptor s3FileDescriptor = new S3FileDescriptor(s3BucketRef, (List<String>)((List)s3path.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)S3FileDescriptor$.$anonfun$apply$5(x$3)))), this.apply$default$3());
        return s3FileDescriptor;
    }

    public Option<S3ObjectSummary> apply$default$3() {
        return None$.MODULE$;
    }

    public FileDescriptorCredentials<SerializableAWSCredentials> credentials() {
        return this.credentials;
    }

    private TrieMap<String, S3Bucket> s3Buckets() {
        return this.s3Buckets;
    }

    public S3FileDescriptor apply(S3Bucket bucket, List<String> elements, Option<S3ObjectSummary> summary) {
        return new S3FileDescriptor(bucket, elements, summary);
    }

    public Option<Tuple3<S3Bucket, List<String>, Option<S3ObjectSummary>>> unapply(S3FileDescriptor x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.bucket(), x$0.elements(), x$0.eu$shiftforward$apso$io$S3FileDescriptor$$summary()));
    }

    public Option<S3ObjectSummary> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final S3Bucket newBucket$1(Option credentials$1, String s3bucket$1) {
        return (S3Bucket)credentials$1.fold((Function0 & Serializable & scala.Serializable)() -> new S3Bucket(s3bucket$1, S3Bucket$.MODULE$.$lessinit$greater$default$2()), (Function1 & Serializable & scala.Serializable)s3Cred -> new S3Bucket(s3bucket$1, (Function0<AWSCredentials>)(Function0 & Serializable & scala.Serializable)() -> s3Cred));
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(String x$3) {
        String string = x$3.trim();
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private S3FileDescriptor$() {
        MODULE$ = this;
        this.credentials = new FileDescriptorCredentials<SerializableAWSCredentials>(){
            private final String protocol;

            public Option<SerializableAWSCredentials> read(Config config, String path) {
                return FileDescriptorCredentials.read$(this, config, path);
            }

            public String id(String path) {
                return Option$.MODULE$.option2Iterable(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).headOption()).mkString();
            }

            public String protocol() {
                return this.protocol;
            }

            public SerializableAWSCredentials createCredentials(String id, Config s3Config) {
                return new SerializableAWSCredentials(s3Config.getString("access-key"), s3Config.getString("secret-key"));
            }
            {
                FileDescriptorCredentials.$init$(this);
                this.protocol = "s3";
            }
        };
        this.s3Buckets = TrieMap$.MODULE$.empty();
    }
}

