/*
 * Decompiled with CFR 0.152.
 */
package eu.shiftforward.apso.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import eu.shiftforward.apso.Logging;
import eu.shiftforward.apso.aws.S3Bucket$;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t-e\u0001B\u0001\u0003\u0001-\u0011\u0001bU\u001aCk\u000e\\W\r\u001e\u0006\u0003\u0007\u0011\t1!Y<t\u0015\t)a!\u0001\u0003baN|'BA\u0004\t\u00031\u0019\b.\u001b4uM>\u0014x/\u0019:e\u0015\u0005I\u0011AA3v\u0007\u0001\u0019B\u0001\u0001\u0007\u0013-A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003\u000f1{wmZ5oOB\u0011QbF\u0005\u000319\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\u0007\u0001\u0003\u0006\u0004%\taG\u0001\u000bEV\u001c7.\u001a;OC6,W#\u0001\u000f\u0011\u0005u!cB\u0001\u0010#!\tyb\"D\u0001!\u0015\t\t#\"\u0001\u0004=e>|GOP\u0005\u0003G9\ta\u0001\u0015:fI\u00164\u0017BA\u0013'\u0005\u0019\u0019FO]5oO*\u00111E\u0004\u0005\tQ\u0001\u0011\t\u0011)A\u00059\u0005Y!-^2lKRt\u0015-\\3!\u0011!Q\u0003A!b\u0001\n\u0013Y\u0013AE2sK\u0012,g\u000e^5bYN4\u0015m\u0019;pef,\u0012\u0001\f\t\u0004\u001b5z\u0013B\u0001\u0018\u000f\u0005%1UO\\2uS>t\u0007\u0007\u0005\u00021o5\t\u0011G\u0003\u00023g\u0005!\u0011-\u001e;i\u0015\t!T'A\u0005b[\u0006TxN\\1xg*\ta'A\u0002d_6L!\u0001O\u0019\u0003\u001d\u0005;6k\u0011:fI\u0016tG/[1mg\"A!\b\u0001B\u0001B\u0003%A&A\nde\u0016$WM\u001c;jC2\u001ch)Y2u_JL\b\u0005C\u0003=\u0001\u0011\u0005Q(\u0001\u0004=S:LGO\u0010\u000b\u0004}\u0001\u000b\u0005CA \u0001\u001b\u0005\u0011\u0001\"\u0002\u000e<\u0001\u0004a\u0002b\u0002\u0016<!\u0003\u0005\r\u0001\f\u0005\n\u0007\u0002\u0001\r\u0011!Q!\n=\nAbX2sK\u0012,g\u000e^5bYND#AQ#\u0011\u000551\u0015BA$\u000f\u0005%!(/\u00198tS\u0016tG\u000fC\u0003J\u0001\u0011%!*A\u0006de\u0016$WM\u001c;jC2\u001cX#A\u0018\t\u00111\u0003\u0001R1Q\u0005\n5\u000baaY8oM&<W#\u0001(\u0011\u0005=\u001bV\"\u0001)\u000b\u00051\u000b&B\u0001*6\u0003!!\u0018\u0010]3tC\u001a,\u0017B\u0001+Q\u0005\u0019\u0019uN\u001c4jO\"Aa\u000b\u0001ECB\u0013%q+\u0001\u0007d_:4\u0017n\u001a)sK\u001aL\u00070F\u0001Y!\tIf,D\u0001[\u0015\tYF,\u0001\u0003mC:<'\"A/\u0002\t)\fg/Y\u0005\u0003KiC\u0001\u0002\u0019\u0001\t\u0006\u0004&IaV\u0001\tK:$\u0007o\\5oi\"A!\r\u0001ECB\u0013%q+\u0001\u0004sK\u001eLwN\u001c\u0005\nI\u0002\u0001\r\u0011!Q!\n\u0015\f1aX:4!\t17.D\u0001h\u0015\tA\u0017.\u0001\u0002tg)\u0011!nM\u0001\tg\u0016\u0014h/[2fg&\u0011An\u001a\u0002\u000f\u00036\f'p\u001c8Tg\rc\u0017.\u001a8uQ\t\u0019W\t\u0003\u0004i\u0001\u0001&Ia\\\u000b\u0002K\"I\u0011\u000f\u0001a\u0001\u0002\u0003\u0006KA]\u0001\u0011?R\u0014\u0018M\\:gKJl\u0015M\\1hKJ\u0004\"a\u001d<\u000e\u0003QT!!^4\u0002\u0011Q\u0014\u0018M\\:gKJL!a\u001e;\u0003\u001fQ\u0013\u0018M\\:gKJl\u0015M\\1hKJD#\u0001]#\t\ri\u0004\u0001\u0015\"\u0003|\u0003=!(/\u00198tM\u0016\u0014X*\u00198bO\u0016\u0014X#\u0001:\t\ru\u0004\u0001\u0015\"\u0003\u007f\u0003!\u0019\b\u000f\\5u\u0017\u0016LHcA@\u0002\u0006A1Q\"!\u0001Y1bK1!a\u0001\u000f\u0005\u0019!V\u000f\u001d7fg!1\u0011q\u0001?A\u0002q\t1a[3z\u0011!\tY\u0001\u0001Q\u0005\n\u00055\u0011aC:b]&$\u0018N_3LKf$2\u0001HA\b\u0011\u001d\t9!!\u0003A\u0002qAq!a\u0005\u0001\t\u0003\t)\"\u0001\u0003tSj,G\u0003BA\f\u0003;\u00012!DA\r\u0013\r\tYB\u0004\u0002\u0005\u0019>tw\rC\u0004\u0002\b\u0005E\u0001\u0019\u0001\u000f\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$\u0005ar-\u001a;PE*,7\r^:XSRDW*\u0019;dQ&tw\r\u0015:fM&DHCBA\u0013\u0003\u0007\n9\u0005\u0005\u0004\u0002(\u0005E\u0012q\u0007\b\u0005\u0003S\tiCD\u0002 \u0003WI\u0011aD\u0005\u0004\u0003_q\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003g\t)D\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\tyC\u0004\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011QH4\u0002\u000b5|G-\u001a7\n\t\u0005\u0005\u00131\b\u0002\u0010'Nz%M[3diN+X.\\1ss\"9\u0011QIA\u0010\u0001\u0004a\u0012A\u00029sK\u001aL\u0007\u0010\u0003\u0006\u0002J\u0005}\u0001\u0013!a\u0001\u0003\u0017\n!#\u001b8dYV$W\rR5sK\u000e$xN]5fgB\u0019Q\"!\u0014\n\u0007\u0005=cBA\u0004C_>dW-\u00198\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V\u0005Qr-\u001a;GS2,7oV5uQ6\u000bGo\u00195j]\u001e\u0004&/\u001a4jqR1\u0011qKA-\u00037\u0002R!a\n\u00022qAq!!\u0012\u0002R\u0001\u0007A\u0004\u0003\u0006\u0002J\u0005E\u0003\u0013!a\u0001\u0003\u0017Bq!a\u0018\u0001\t\u0003\t\t'\u0001\u0003qkNDGCBA&\u0003G\n)\u0007C\u0004\u0002\b\u0005u\u0003\u0019\u0001\u000f\t\u0011\u0005\u001d\u0014Q\fa\u0001\u0003S\nAAZ5mKB!\u00111NA9\u001b\t\tiGC\u0002\u0002pq\u000b!![8\n\t\u0005M\u0014Q\u000e\u0002\u0005\r&dW\rC\u0004\u0002`\u0001!\t!a\u001e\u0015\u0011\u0005-\u0013\u0011PA>\u0003\u000bCq!a\u0002\u0002v\u0001\u0007A\u0004\u0003\u0005\u0002~\u0005U\u0004\u0019AA@\u0003-Ig\u000e];u'R\u0014X-Y7\u0011\t\u0005-\u0014\u0011Q\u0005\u0005\u0003\u0007\u000biGA\u0006J]B,Ho\u0015;sK\u0006l\u0007\u0002CAD\u0003k\u0002\r!!#\u0002\r1,gn\u001a;i!\u0015i\u00111RA\f\u0013\r\tiI\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\u00061A-\u001a7fi\u0016$B!a\u0013\u0002\u0016\"9\u0011qAAH\u0001\u0004a\u0002bBAM\u0001\u0011\u0005\u00111T\u0001\u0007KbL7\u000f^:\u0015\t\u0005-\u0013Q\u0014\u0005\b\u0003\u000f\t9\n1\u0001\u001d\u0011\u001d\t\t\u000b\u0001C\u0001\u0003G\u000b1\"[:ESJ,7\r^8ssR!\u00111JAS\u0011\u001d\t9!a(A\u0002qAq!!+\u0001\t\u0003\tY+\u0001\u0004tKR\f5\r\u001c\u000b\u0007\u0003[\u000b\u0019,!.\u0011\u00075\ty+C\u0002\u00022:\u0011A!\u00168ji\"9\u0011qAAT\u0001\u0004a\u0002\u0002CA\\\u0003O\u0003\r!!/\u0002\u0007\u0005\u001cG\u000e\u0005\u0003\u0002:\u0005m\u0016\u0002BA_\u0003w\u0011qcQ1o]\u0016$\u0017iY2fgN\u001cuN\u001c;s_2d\u0015n\u001d;\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0002D\u0006y1M]3bi\u0016$\u0015N]3di>\u0014\u0018\u0010\u0006\u0003\u0002L\u0005\u0015\u0007bBA\u0004\u0003\u007f\u0003\r\u0001\b\u0005\b\u0003\u0013\u0004A\u0011AAf\u0003\u0019\u0011\u0017mY6vaR!\u00111JAg\u0011\u001d\t9!a2A\u0002qAq!!5\u0001\t\u0003\t\u0019.\u0001\u0003qk2dGCBA&\u0003+\f9\u000eC\u0004\u0002\b\u0005=\u0007\u0019\u0001\u000f\t\u000f\u0005e\u0017q\u001aa\u00019\u0005YA-Z:uS:\fG/[8o\u0011\u001d\ti\u000e\u0001C\u0001\u0003?\faa\u001d;sK\u0006lG\u0003BA@\u0003CDq!a\u0002\u0002\\\u0002\u0007A\u0004\u0003\u0005\u0002f\u0002\u0001K\u0011BAt\u0003\u001dA\u0017M\u001c3mKJ,\"!!;\u0011\u000f5\tY/a<\u0002L%\u0019\u0011Q\u001e\b\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004B!a\n\u0002r&!\u00111_A\u001b\u0005%!\u0006N]8xC\ndW\r\u0003\u0005\u0002x\u0002\u0001K\u0011BA}\u0003\u0015\u0011X\r\u001e:z+\u0011\tYPa\u0001\u0015\u0011\u0005u(Q\u0003B\u0010\u0005S\u0001R!DAF\u0003\u007f\u0004BA!\u0001\u0003\u00041\u0001A\u0001\u0003B\u0003\u0003k\u0014\rAa\u0002\u0003\u0003Q\u000bBA!\u0003\u0003\u0010A\u0019QBa\u0003\n\u0007\t5aBA\u0004O_RD\u0017N\\4\u0011\u00075\u0011\t\"C\u0002\u0003\u00149\u00111!\u00118z\u0011%\u00119\"!>\u0005\u0002\u0004\u0011I\"A\u0001g!\u0015i!1DA\u0000\u0013\r\u0011iB\u0004\u0002\ty\tLh.Y7f}!Q!\u0011EA{!\u0003\u0005\rAa\t\u0002\u000bQ\u0014\u0018.Z:\u0011\u00075\u0011)#C\u0002\u0003(9\u00111!\u00138u\u0011)\u0011Y#!>\u0011\u0002\u0003\u0007!1E\u0001\ng2,W\r\u001d+j[\u0016DqAa\f\u0001\t\u0003\u0012\t$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0017\u0012\u0019\u0004\u0003\u0005\u00036\t5\u0002\u0019\u0001B\b\u0003\ry'M\u001b\u0005\n\u0005s\u0001\u0011\u0013!C\u0005\u0005w\tqB]3uef$C-\u001a4bk2$HEM\u000b\u0005\u0005{\u0011\u0019&\u0006\u0002\u0003@)\"!1\u0005B!W\t\u0011\u0019\u0005\u0005\u0003\u0003F\t=SB\u0001B$\u0015\u0011\u0011IEa\u0013\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B'\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tE#q\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G\u0001\u0003B\u0003\u0005o\u0011\rAa\u0002\t\u0013\t]\u0003!%A\u0005\n\te\u0013a\u0004:fiJLH\u0005Z3gCVdG\u000fJ\u001a\u0016\t\tu\"1\f\u0003\t\u0005\u000b\u0011)F1\u0001\u0003\b!I!q\f\u0001\u0012\u0002\u0013\u0005!\u0011M\u0001'O\u0016$xJ\u00196fGR\u001cx+\u001b;i\u001b\u0006$8\r[5oOB\u0013XMZ5yI\u0011,g-Y;mi\u0012\u0012TC\u0001B2U\u0011\tYE!\u0011\t\u0013\t\u001d\u0004!%A\u0005\u0002\t\u0005\u0014\u0001J4fi\u001aKG.Z:XSRDW*\u0019;dQ&tw\r\u0015:fM&DH\u0005Z3gCVdG\u000f\n\u001a\b\u0013\t-$!!A\t\u0002\t5\u0014\u0001C*4\u0005V\u001c7.\u001a;\u0011\u0007}\u0012yG\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B9'\u0011\u0011y\u0007\u0004\f\t\u000fq\u0012y\u0007\"\u0001\u0003vQ\u0011!Q\u000e\u0005\u000b\u0005s\u0012y'%A\u0005\u0002\tm\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0003~)\u001aAF!\u0011\t\u0015\t\u0005%qNA\u0001\n\u0013\u0011\u0019)A\u0006sK\u0006$'+Z:pYZ,GC\u0001BC!\rI&qQ\u0005\u0004\u0005\u0013S&AB(cU\u0016\u001cG\u000f")
public class S3Bucket
implements Logging,
scala.Serializable {
    private Config config;
    private String configPrefix;
    private String endpoint;
    private String region;
    private final String bucketName;
    private final Function0<AWSCredentials> credentialsFactory;
    private transient AWSCredentials _credentials;
    private transient AmazonS3Client _s3;
    private transient TransferManager _transferManager;
    private Logger log;
    private volatile byte bitmap$0;

    public static Function0<AWSCredentials> $lessinit$greater$default$2() {
        return S3Bucket$.MODULE$.$lessinit$greater$default$2();
    }

    private Logger log$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.log = Logging.log$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.log$lzycompute() : this.log;
    }

    public String bucketName() {
        return this.bucketName;
    }

    private Function0<AWSCredentials> credentialsFactory() {
        return this.credentialsFactory;
    }

    private AWSCredentials credentials() {
        block0: {
            if (this._credentials != null) break block0;
            this._credentials = (AWSCredentials)this.credentialsFactory().apply();
        }
        return this._credentials;
    }

    private Config config$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.config = ConfigFactory.load();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.config;
    }

    private Config config() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.config$lzycompute() : this.config;
    }

    private String configPrefix$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.configPrefix = "aws.s3";
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.configPrefix;
    }

    private String configPrefix() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.configPrefix$lzycompute() : this.configPrefix;
    }

    private String endpoint$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.endpoint = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.config().getString(this.configPrefix() + ".endpoint")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "s3.amazonaws.com");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.endpoint;
    }

    private String endpoint() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.endpoint$lzycompute() : this.endpoint;
    }

    private String region$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.region = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.config().getString(this.configPrefix() + ".region")).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.region;
    }

    private String region() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.region$lzycompute() : this.region;
    }

    private AmazonS3Client s3() {
        Object object;
        if (this._s3 == null) {
            ClientConfiguration defaultConfig = new ClientConfiguration().withTcpKeepAlive(true);
            this._s3 = new AmazonS3Client(this.credentials(), defaultConfig);
            this._s3.setEndpoint(this.endpoint());
            object = !this._s3.doesBucketExist(this.bucketName()) ? this._s3.createBucket(this.bucketName(), Region.fromValue((String)this.region())) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return this._s3;
    }

    private TransferManager transferManager() {
        block0: {
            if (this._transferManager != null) break block0;
            ExecutorService executor = Executors.newFixedThreadPool(10, new ThreadFactory(null){
                private int threadCount;

                private int threadCount() {
                    return this.threadCount;
                }

                private void threadCount_$eq(int x$1) {
                    this.threadCount = x$1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Thread newThread(Runnable r) {
                    void var2_2;
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s3-transfer-manager-worker-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.threadCount())})));
                    this.threadCount_$eq(this.threadCount() + 1);
                    return var2_2;
                }
                {
                    this.threadCount = 1;
                }
            });
            this._transferManager = new TransferManager((AmazonS3)this.s3(), executor);
        }
        return this._transferManager;
    }

    private Tuple3<String, String, String> splitKey(String key) {
        int iExtensionPoint = key.lastIndexOf(46);
        int iSlash = key.lastIndexOf(47);
        String mainKey = iSlash != -1 ? key.substring(0, iSlash) : "";
        String extension = iExtensionPoint != -1 ? key.substring(iExtensionPoint) : "";
        String name = iExtensionPoint != -1 ? key.substring(0, iExtensionPoint) : key;
        return new Tuple3((Object)mainKey, (Object)name, (Object)extension);
    }

    private String sanitizeKey(String key) {
        return key.startsWith("./") ? (String)new StringOps(Predef$.MODULE$.augmentString(key)).drop(2) : key;
    }

    public long size(String key) {
        return BoxesRunTime.unboxToLong((Object)this.retry((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.s3().getObjectMetadata(this.bucketName(), key).getContentLength(), this.retry$default$2(), this.retry$default$3()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public Iterator<S3ObjectSummary> getObjectsWithMatchingPrefix(String prefix, boolean includeDirectories) {
        this.log().info("Finding files matching prefix '{}'...", new Object[]{prefix});
        Iterator listings = package$.MODULE$.Iterator().iterate((Object)this.s3().listObjects(this.bucketName(), this.sanitizeKey(prefix)), (Function1 & Serializable & scala.Serializable)listing -> {
            ObjectListing objectListing;
            if (listing.isTruncated()) {
                this.log().debug("Asking for another batch of objects...");
                objectListing = this.s3().listNextBatchOfObjects(listing);
            } else {
                objectListing = null;
            }
            return objectListing;
        });
        Iterator objects = listings.takeWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)S3Bucket.$anonfun$getObjectsWithMatchingPrefix$2(x$1))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(x$2.getObjectSummaries()));
        return includeDirectories ? objects : objects.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)S3Bucket.$anonfun$getObjectsWithMatchingPrefix$4(x$3)));
    }

    public boolean getObjectsWithMatchingPrefix$default$2() {
        return false;
    }

    public Iterator<String> getFilesWithMatchingPrefix(String prefix, boolean includeDirectories) {
        return this.getObjectsWithMatchingPrefix(prefix, includeDirectories).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getKey());
    }

    public boolean getFilesWithMatchingPrefix$default$2() {
        return false;
    }

    public boolean push(String key, File file) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> {
            this.log().info("Pushing '{}' to 's3://{}/{}'", new Object[]{file.getPath(), this.bucketName(), key});
            return this.transferManager().upload(new PutObjectRequest(this.bucketName(), this.sanitizeKey(key), file)).waitForUploadResult();
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean push(String key, InputStream inputStream, Option<Object> length) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> {
            this.log().info("Pushing to 's3://{}/{}'", (Object)this.bucketName(), (Object)key);
            ObjectMetadata metadata = new ObjectMetadata();
            length.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$1 -> metadata.setContentLength(x$1));
            return this.transferManager().upload(new PutObjectRequest(this.bucketName(), this.sanitizeKey(key), inputStream, metadata)).waitForUploadResult();
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean delete(String key) {
        return this.retry((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.s3().deleteObject(this.bucketName(), this.sanitizeKey(key)), this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean exists(String key) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> this.s3().getObjectMetadata(this.bucketName(), key), this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean isDirectory(String key) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> this.s3().listObjects(new ListObjectsRequest().withBucketName(this.bucketName()).withMaxKeys(Predef$.MODULE$.int2Integer(2)).withPrefix(key)).getObjectSummaries(), this.retry$default$2(), this.retry$default$3()).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)S3Bucket.$anonfun$isDirectory$2(key, x$5)));
    }

    public void setAcl(String key, CannedAccessControlList acl) {
        this.log().info("Setting 's3://{}/{}' permissions to '{}'", new Object[]{this.bucketName(), key, acl});
        this.s3().setObjectAcl(this.bucketName(), key, acl);
    }

    public boolean createDirectory(String key) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> {
            this.log().info("Creating directory in 's3://{}/{}'", new Object[]{this.bucketName(), key, null});
            ByteArrayInputStream emptyContent = new ByteArrayInputStream((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(0L);
            return this.s3().putObject(new PutObjectRequest(this.bucketName(), this.sanitizeKey(key) + "/", (InputStream)emptyContent, metadata));
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean backup(String key) {
        return this.retry((Function0 & Serializable & scala.Serializable)() -> {
            String sanitizedKey = this.sanitizeKey(key);
            Tuple3<String, String, String> tuple3 = this.splitKey(sanitizedKey);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String mainKey = (String)tuple3._1();
            String name = (String)tuple3._2();
            String extension = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)mainKey, (Object)name, (Object)extension);
            Tuple3 tuple33 = tuple32;
            String mainKey2 = (String)tuple33._1();
            String name2 = (String)tuple33._2();
            String extension2 = (String)tuple33._3();
            return this.s3().copyObject(new CopyObjectRequest(this.bucketName(), sanitizedKey, this.bucketName(), mainKey2 + "/backup/" + name2.substring(mainKey2.length() + 1) + extension2));
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean pull(String key, String destination) {
        return this.retry((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.log().info("Pulling 's3://{}/{}' to '{}'", new Object[]{this.bucketName(), key, destination});
            S3Object s3Object = this.s3().getObject(new GetObjectRequest(this.bucketName(), this.sanitizeKey(key)));
            S3ObjectInputStream inputStream = s3Object.getObjectContent();
            File f = new File(destination).getCanonicalFile();
            f.getParentFile().mkdirs();
            FileOutputStream outputStream = new FileOutputStream(f);
            int read = 0;
            byte[] bytes = new byte[1024];
            read = inputStream.read(bytes);
            while (read != -1) {
                outputStream.write(bytes, 0, read);
                read = inputStream.read(bytes);
            }
            this.log().info("Downloaded 's3://{}/{}' to '{}'. Closing files.", new Object[]{this.bucketName(), key, destination});
            inputStream.close();
            outputStream.flush();
            outputStream.close();
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public InputStream stream(String key) {
        this.log().info("Streaming 's3://{}/{}'", (Object)this.bucketName(), (Object)key);
        return this.s3().getObject(new GetObjectRequest(this.bucketName(), this.sanitizeKey(key))).getObjectContent();
    }

    private PartialFunction<Throwable, Object> handler() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                AmazonClientException amazonClientException = null;
                A1 A1 = x1;
                if (A1 instanceof AmazonS3Exception) {
                    Boolean bl2;
                    AmazonS3Exception amazonS3Exception = (AmazonS3Exception)A1;
                    int n = amazonS3Exception.getStatusCode();
                    switch (n) {
                        case 404: {
                            this.$outer.log().error("The specified file does not exist", (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                            break;
                        }
                        case 403: {
                            this.$outer.log().error("No permission to access the file", (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                            break;
                        }
                        default: {
                            this.$outer.log().error(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|S3 service error: ", ". Extended request id: ", "\n                      |Additional details: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{amazonS3Exception.getMessage(), amazonS3Exception.getExtendedRequestId(), amazonS3Exception.getAdditionalDetails()})))).stripMargin(), (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)false);
                            break;
                        }
                    }
                    object = bl2;
                    return (B1)object;
                }
                if (A1 instanceof AmazonServiceException) {
                    AmazonServiceException amazonServiceException = (AmazonServiceException)A1;
                    this.$outer.log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Service error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{amazonServiceException.getMessage()})), (Throwable)amazonServiceException);
                    object = BoxesRunTime.boxToBoolean((boolean)amazonServiceException.isRetryable());
                    return (B1)object;
                }
                if (A1 instanceof AmazonClientException) {
                    bl = true;
                    amazonClientException = (AmazonClientException)A1;
                    String string = amazonClientException.getMessage();
                    String string2 = "Unable to load AWS credentials from any provider in the chain";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.$outer.log().error("Unable to load AWS credentials", (Throwable)amazonClientException);
                        object = BoxesRunTime.boxToBoolean((boolean)true);
                        return (B1)object;
                    }
                }
                if (bl) {
                    this.$outer.log().error("Client error pulling file", (Throwable)amazonClientException);
                    object = BoxesRunTime.boxToBoolean((boolean)amazonClientException.isRetryable());
                    return (B1)object;
                }
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.log().error("An error occurred", (Throwable)exception);
                    object = BoxesRunTime.boxToBoolean((boolean)false);
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Throwable x1) {
                boolean bl = false;
                AmazonClientException amazonClientException = null;
                Throwable throwable = x1;
                if (throwable instanceof AmazonS3Exception) {
                    return true;
                }
                if (throwable instanceof AmazonServiceException) {
                    return true;
                }
                if (throwable instanceof AmazonClientException) {
                    bl = true;
                    amazonClientException = (AmazonClientException)throwable;
                    String string = amazonClientException.getMessage();
                    String string2 = "Unable to load AWS credentials from any provider in the chain";
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) {
                        return true;
                    }
                }
                if (bl) {
                    return true;
                }
                if (!(throwable instanceof Exception)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private <T> Option<T> retry(Function0<T> f, int tries, int sleepTime) {
        None$ none$;
        block4: {
            None$ none$2;
            block5: {
                while (true) {
                    if (tries == 0) {
                        this.log().error("Max retries reached. Aborting S3 operation");
                        none$ = None$.MODULE$;
                        break block4;
                    }
                    Try try_ = Try$.MODULE$.apply(f);
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        Object res = success.value();
                        none$2 = new Some(res);
                        break block5;
                    }
                    if (!(try_ instanceof Failure)) break;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (BoxesRunTime.unboxToBoolean((Object)this.handler().apply((Object)e))) break;
                    if (tries > 1) {
                        this.log().warn("Error during S3 operation. Retrying in {}ms ({} more times)", (Object)BoxesRunTime.boxToInteger((int)sleepTime), (Object)BoxesRunTime.boxToInteger((int)(tries - 1)));
                        Thread.sleep(sleepTime);
                    }
                    --tries;
                }
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        return none$;
    }

    private <T> int retry$default$2() {
        return 3;
    }

    private <T> int retry$default$3() {
        return 5000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof S3Bucket)) return false;
        S3Bucket s3Bucket = (S3Bucket)object;
        String string = s3Bucket.bucketName();
        String string2 = this.bucketName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = s3Bucket.credentials().getAWSAccessKeyId();
        String string4 = this.credentials().getAWSAccessKeyId();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = s3Bucket.credentials().getAWSSecretKey();
        String string6 = this.credentials().getAWSSecretKey();
        if (string5 == null) {
            if (string6 == null) return true;
            return false;
        } else {
            if (!string5.equals(string6)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getObjectsWithMatchingPrefix$2(ObjectListing x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getObjectsWithMatchingPrefix$4(S3ObjectSummary x$3) {
        return x$3.getKey().endsWith("/");
    }

    public static final /* synthetic */ boolean $anonfun$isDirectory$3(String key$6, S3ObjectSummary x$6) {
        return x$6.getKey().startsWith(key$6 + "/");
    }

    public static final /* synthetic */ boolean $anonfun$isDirectory$2(String key$6, List x$5) {
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(x$5).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)S3Bucket.$anonfun$isDirectory$3(key$6, x$6)));
    }

    public S3Bucket(String bucketName, Function0<AWSCredentials> credentialsFactory) {
        this.bucketName = bucketName;
        this.credentialsFactory = credentialsFactory;
        Logging.$init$(this);
    }
}

