/*
 * Decompiled with CFR 0.152.
 */
package eu.shiftforward.apso.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import eu.shiftforward.apso.Logging;
import eu.shiftforward.apso.Logging$class;
import eu.shiftforward.apso.aws.S3Bucket$;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tee\u0001B\u0001\u0003\u0001-\u0011\u0001bU\u001aCk\u000e\\W\r\u001e\u0006\u0003\u0007\u0011\t1!Y<t\u0015\t)a!\u0001\u0003baN|'BA\u0004\t\u00031\u0019\b.\u001b4uM>\u0014x/\u0019:e\u0015\u0005I\u0011AA3v\u0007\u0001\u0019B\u0001\u0001\u0007\u0013-A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003\u000f1{wmZ5oOB\u0011QbF\u0005\u000319\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\u0007\u0001\u0003\u0006\u0004%\taG\u0001\u000bEV\u001c7.\u001a;OC6,W#\u0001\u000f\u0011\u0005u\u0001cBA\u0007\u001f\u0013\tyb\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\t\u0012aa\u0015;sS:<'BA\u0010\u000f\u0011!!\u0003A!A!\u0002\u0013a\u0012a\u00032vG.,GOT1nK\u0002B\u0001B\n\u0001\u0003\u0006\u0004%IaJ\u0001\u0013GJ,G-\u001a8uS\u0006d7OR1di>\u0014\u00180F\u0001)!\ri\u0011fK\u0005\u0003U9\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u00051\u001aT\"A\u0017\u000b\u00059z\u0013\u0001B1vi\"T!\u0001M\u0019\u0002\u0013\u0005l\u0017M_8oC^\u001c(\"\u0001\u001a\u0002\u0007\r|W.\u0003\u00025[\tq\u0011iV*De\u0016$WM\u001c;jC2\u001c\b\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002'\r\u0014X\rZ3oi&\fGn\u001d$bGR|'/\u001f\u0011\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\rQD(\u0010\t\u0003w\u0001i\u0011A\u0001\u0005\u00065]\u0002\r\u0001\b\u0005\bM]\u0002\n\u00111\u0001)\u0011%y\u0004\u00011A\u0001B\u0003&1&\u0001\u0007`GJ,G-\u001a8uS\u0006d7\u000f\u000b\u0002?\u0003B\u0011QBQ\u0005\u0003\u0007:\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u000b\u0015\u0003A\u0011\u0002$\u0002\u0017\r\u0014X\rZ3oi&\fGn]\u000b\u0002W!A\u0001\n\u0001ECB\u0013%\u0011*\u0001\u0004d_:4\u0017nZ\u000b\u0002\u0015B\u00111jT\u0007\u0002\u0019*\u0011\u0001*\u0014\u0006\u0003\u001dF\n\u0001\u0002^=qKN\fg-Z\u0005\u0003!2\u0013aaQ8oM&<\u0007\u0002\u0003*\u0001\u0011\u0003\u0005\u000b\u0015\u0002&\u0002\u000f\r|gNZ5hA!AA\u000b\u0001ECB\u0013%Q+\u0001\u0007d_:4\u0017n\u001a)sK\u001aL\u00070F\u0001W!\t9F,D\u0001Y\u0015\tI&,\u0001\u0003mC:<'\"A.\u0002\t)\fg/Y\u0005\u0003CaC\u0001B\u0018\u0001\t\u0002\u0003\u0006KAV\u0001\u000eG>tg-[4Qe\u00164\u0017\u000e\u001f\u0011\t\u0011\u0001\u0004\u0001R1Q\u0005\nU\u000b\u0001\"\u001a8ea>Lg\u000e\u001e\u0005\tE\u0002A\t\u0011)Q\u0005-\u0006IQM\u001c3q_&tG\u000f\t\u0005\tI\u0002A)\u0019)C\u0005+\u00061!/Z4j_:D\u0001B\u001a\u0001\t\u0002\u0003\u0006KAV\u0001\be\u0016<\u0017n\u001c8!\u0011%A\u0007\u00011A\u0001B\u0003&\u0011.A\u0002`gN\u0002\"A[8\u000e\u0003-T!\u0001\\7\u0002\u0005M\u001c$B\u000180\u0003!\u0019XM\u001d<jG\u0016\u001c\u0018B\u00019l\u00059\tU.\u0019>p]N\u001b4\t\\5f]RD#aZ!\t\r1\u0004\u0001\u0015\"\u0003t+\u0005I\u0007\"C;\u0001\u0001\u0004\u0005\t\u0015)\u0003w\u0003AyFO]1og\u001a,'/T1oC\u001e,'\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002zW\u0006AAO]1og\u001a,'/\u0003\u0002|q\nyAK]1og\u001a,'/T1oC\u001e,'\u000f\u000b\u0002u\u0003\"1a\u0010\u0001Q\u0005\n}\fq\u0002\u001e:b]N4WM]'b]\u0006<WM]\u000b\u0002m\"A\u00111\u0001\u0001!\n\u0013\t)!\u0001\u0005ta2LGoS3z)\u0011\t9!!\u0004\u0011\r5\tIA\u0016,W\u0013\r\tYA\u0004\u0002\u0007)V\u0004H.Z\u001a\t\u000f\u0005=\u0011\u0011\u0001a\u00019\u0005\u00191.Z=\t\u0011\u0005M\u0001\u0001)C\u0005\u0003+\t1b]1oSRL'0Z&fsR\u0019A$a\u0006\t\u000f\u0005=\u0011\u0011\u0003a\u00019!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0011\u0001B:ju\u0016$B!a\b\u0002&A\u0019Q\"!\t\n\u0007\u0005\rbB\u0001\u0003M_:<\u0007bBA\b\u00033\u0001\r\u0001\b\u0005\b\u0003S\u0001A\u0011AA\u0016\u0003q9W\r^(cU\u0016\u001cGo],ji\"l\u0015\r^2iS:<\u0007K]3gSb$b!!\f\u0002R\u0005U\u0003CBA\u0018\u0003\u007f\t)E\u0004\u0003\u00022\u0005mb\u0002BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]\"\"\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0019\u0011Q\b\b\u0002\u000fA\f7m[1hK&!\u0011\u0011IA\"\u0005!IE/\u001a:bi>\u0014(bAA\u001f\u001dA!\u0011qIA'\u001b\t\tIEC\u0002\u0002L-\fQ!\\8eK2LA!a\u0014\u0002J\ty1kM(cU\u0016\u001cGoU;n[\u0006\u0014\u0018\u0010C\u0004\u0002T\u0005\u001d\u0002\u0019\u0001\u000f\u0002\rA\u0014XMZ5y\u0011)\t9&a\n\u0011\u0002\u0003\u0007\u0011\u0011L\u0001\u0013S:\u001cG.\u001e3f\t&\u0014Xm\u0019;pe&,7\u000fE\u0002\u000e\u00037J1!!\u0018\u000f\u0005\u001d\u0011un\u001c7fC:Dq!!\u0019\u0001\t\u0003\t\u0019'\u0001\u000ehKR4\u0015\u000e\\3t/&$\b.T1uG\"Lgn\u001a)sK\u001aL\u0007\u0010\u0006\u0004\u0002f\u0005\u001d\u0014\u0011\u000e\t\u0006\u0003_\ty\u0004\b\u0005\b\u0003'\ny\u00061\u0001\u001d\u0011)\t9&a\u0018\u0011\u0002\u0003\u0007\u0011\u0011\f\u0005\b\u0003[\u0002A\u0011AA8\u0003\u0011\u0001Xo\u001d5\u0015\r\u0005e\u0013\u0011OA:\u0011\u001d\ty!a\u001bA\u0002qA\u0001\"!\u001e\u0002l\u0001\u0007\u0011qO\u0001\u0005M&dW\r\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\tiHW\u0001\u0003S>LA!!!\u0002|\t!a)\u001b7f\u0011\u001d\ti\u0007\u0001C\u0001\u0003\u000b#\u0002\"!\u0017\u0002\b\u0006%\u00151\u0013\u0005\b\u0003\u001f\t\u0019\t1\u0001\u001d\u0011!\tY)a!A\u0002\u00055\u0015aC5oaV$8\u000b\u001e:fC6\u0004B!!\u001f\u0002\u0010&!\u0011\u0011SA>\u0005-Ie\u000e];u'R\u0014X-Y7\t\u0011\u0005U\u00151\u0011a\u0001\u0003/\u000ba\u0001\\3oORD\u0007#B\u0007\u0002\u001a\u0006}\u0011bAAN\u001d\t1q\n\u001d;j_:Dq!a(\u0001\t\u0003\t\t+\u0001\u0004eK2,G/\u001a\u000b\u0005\u00033\n\u0019\u000bC\u0004\u0002\u0010\u0005u\u0005\u0019\u0001\u000f\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\u00061Q\r_5tiN$B!!\u0017\u0002,\"9\u0011qBAS\u0001\u0004a\u0002bBAX\u0001\u0011\u0005\u0011\u0011W\u0001\fSN$\u0015N]3di>\u0014\u0018\u0010\u0006\u0003\u0002Z\u0005M\u0006bBA\b\u0003[\u0003\r\u0001\b\u0005\b\u0003o\u0003A\u0011AA]\u0003\u0019\u0019X\r^!dYR1\u00111XAa\u0003\u0007\u00042!DA_\u0013\r\tyL\u0004\u0002\u0005+:LG\u000fC\u0004\u0002\u0010\u0005U\u0006\u0019\u0001\u000f\t\u0011\u0005\u0015\u0017Q\u0017a\u0001\u0003\u000f\f1!Y2m!\u0011\t9%!3\n\t\u0005-\u0017\u0011\n\u0002\u0018\u0007\u0006tg.\u001a3BG\u000e,7o]\"p]R\u0014x\u000e\u001c'jgRDq!a4\u0001\t\u0003\t\t.A\bde\u0016\fG/\u001a#je\u0016\u001cGo\u001c:z)\u0011\tI&a5\t\u000f\u0005=\u0011Q\u001aa\u00019!9\u0011q\u001b\u0001\u0005\u0002\u0005e\u0017A\u00022bG.,\b\u000f\u0006\u0003\u0002Z\u0005m\u0007bBA\b\u0003+\u0004\r\u0001\b\u0005\b\u0003?\u0004A\u0011AAq\u0003\u0011\u0001X\u000f\u001c7\u0015\r\u0005e\u00131]As\u0011\u001d\ty!!8A\u0002qAq!a:\u0002^\u0002\u0007A$A\u0006eKN$\u0018N\\1uS>t\u0007bBAv\u0001\u0011\u0005\u0011Q^\u0001\u0007gR\u0014X-Y7\u0015\t\u00055\u0015q\u001e\u0005\b\u0003\u001f\tI\u000f1\u0001\u001d\u0011!\t\u0019\u0010\u0001Q\u0005\n\u0005U\u0018a\u00025b]\u0012dWM]\u000b\u0003\u0003o\u0004r!DA}\u0003{\fI&C\u0002\u0002|:\u0011q\u0002U1si&\fGNR;oGRLwN\u001c\t\u0005\u0003_\ty0\u0003\u0003\u0003\u0002\u0005\r#!\u0003+ie><\u0018M\u00197f\u0011!\u0011)\u0001\u0001Q\u0005\n\t\u001d\u0011!\u0002:fiJLX\u0003\u0002B\u0005\u0005#!\u0002Ba\u0003\u0003$\t5\"q\u0007\t\u0006\u001b\u0005e%Q\u0002\t\u0005\u0005\u001f\u0011\t\u0002\u0004\u0001\u0005\u0011\tM!1\u0001b\u0001\u0005+\u0011\u0011\u0001V\t\u0005\u0005/\u0011i\u0002E\u0002\u000e\u00053I1Aa\u0007\u000f\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!\u0004B\u0010\u0013\r\u0011\tC\u0004\u0002\u0004\u0003:L\b\"\u0003B\u0013\u0005\u0007!\t\u0019\u0001B\u0014\u0003\u00051\u0007#B\u0007\u0003*\t5\u0011b\u0001B\u0016\u001d\tAAHY=oC6,g\b\u0003\u0006\u00030\t\r\u0001\u0013!a\u0001\u0005c\tQ\u0001\u001e:jKN\u00042!\u0004B\u001a\u0013\r\u0011)D\u0004\u0002\u0004\u0013:$\bB\u0003B\u001d\u0005\u0007\u0001\n\u00111\u0001\u00032\u0005I1\u000f\\3faRKW.\u001a\u0005\b\u0005{\u0001A\u0011\tB \u0003\u0019)\u0017/^1mgR!\u0011\u0011\fB!\u0011!\u0011\u0019Ea\u000fA\u0002\tu\u0011aA8cU\"I!q\t\u0001\u0012\u0002\u0013%!\u0011J\u0001\u0010e\u0016$(/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU!!1\nB1+\t\u0011iE\u000b\u0003\u00032\t=3F\u0001B)!\u0011\u0011\u0019F!\u0018\u000e\u0005\tU#\u0002\u0002B,\u00053\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tmc\"\u0001\u0006b]:|G/\u0019;j_:LAAa\u0018\u0003V\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u0011\tM!Q\tb\u0001\u0005+A\u0011B!\u001a\u0001#\u0003%IAa\u001a\u0002\u001fI,GO]=%I\u00164\u0017-\u001e7uIM*BAa\u0013\u0003j\u0011A!1\u0003B2\u0005\u0004\u0011)\u0002C\u0005\u0003n\u0001\t\n\u0011\"\u0001\u0003p\u00051s-\u001a;PE*,7\r^:XSRDW*\u0019;dQ&tw\r\u0015:fM&DH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tE$\u0006BA-\u0005\u001fB\u0011B!\u001e\u0001#\u0003%\tAa\u001c\u0002I\u001d,GOR5mKN<\u0016\u000e\u001e5NCR\u001c\u0007.\u001b8h!J,g-\u001b=%I\u00164\u0017-\u001e7uII:\u0011B!\u001f\u0003\u0003\u0003E\tAa\u001f\u0002\u0011M\u001b$)^2lKR\u00042a\u000fB?\r!\t!!!A\t\u0002\t}4\u0003\u0002B?\u0019YAq\u0001\u000fB?\t\u0003\u0011\u0019\t\u0006\u0002\u0003|!Q!q\u0011B?#\u0003%\tA!#\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011YIK\u0002)\u0005\u001fB!Ba$\u0003~\u0005\u0005I\u0011\u0002BI\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tM\u0005cA,\u0003\u0016&\u0019!q\u0013-\u0003\r=\u0013'.Z2u\u0001")
public class S3Bucket
implements Logging,
Serializable {
    private final String bucketName;
    private final Function0<AWSCredentials> credentialsFactory;
    private transient AWSCredentials _credentials;
    private Config eu$shiftforward$apso$aws$S3Bucket$$config;
    private String eu$shiftforward$apso$aws$S3Bucket$$configPrefix;
    private String endpoint;
    private String region;
    private transient AmazonS3Client _s3;
    private transient TransferManager _transferManager;
    private final Logger log;
    private volatile byte bitmap$0;

    public static Function0<AWSCredentials> $lessinit$greater$default$2() {
        return S3Bucket$.MODULE$.$lessinit$greater$default$2();
    }

    private Config eu$shiftforward$apso$aws$S3Bucket$$config$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.eu$shiftforward$apso$aws$S3Bucket$$config = ConfigFactory.load();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.eu$shiftforward$apso$aws$S3Bucket$$config;
        }
    }

    private String eu$shiftforward$apso$aws$S3Bucket$$configPrefix$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.eu$shiftforward$apso$aws$S3Bucket$$configPrefix = "aws.s3";
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.eu$shiftforward$apso$aws$S3Bucket$$configPrefix;
        }
    }

    private String endpoint$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.endpoint = (String)Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ S3Bucket $outer;

                    public final String apply() {
                        return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$config().getString(new StringBuilder().append((Object)this.$outer.eu$shiftforward$apso$aws$S3Bucket$$configPrefix()).append((Object)".endpoint").toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "s3.amazonaws.com";
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.endpoint;
        }
    }

    private String region$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.region = (String)Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ S3Bucket $outer;

                    public final String apply() {
                        return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$config().getString(new StringBuilder().append((Object)this.$outer.eu$shiftforward$apso$aws$S3Bucket$$configPrefix()).append((Object)".region").toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.region;
        }
    }

    private Logger log$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.log$lzycompute() : this.log;
    }

    public String bucketName() {
        return this.bucketName;
    }

    private Function0<AWSCredentials> credentialsFactory() {
        return this.credentialsFactory;
    }

    private AWSCredentials credentials() {
        if (this._credentials == null) {
            this._credentials = (AWSCredentials)this.credentialsFactory().apply();
        }
        return this._credentials;
    }

    public Config eu$shiftforward$apso$aws$S3Bucket$$config() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.eu$shiftforward$apso$aws$S3Bucket$$config$lzycompute() : this.eu$shiftforward$apso$aws$S3Bucket$$config;
    }

    public String eu$shiftforward$apso$aws$S3Bucket$$configPrefix() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.eu$shiftforward$apso$aws$S3Bucket$$configPrefix$lzycompute() : this.eu$shiftforward$apso$aws$S3Bucket$$configPrefix;
    }

    private String endpoint() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.endpoint$lzycompute() : this.endpoint;
    }

    private String region() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.region$lzycompute() : this.region;
    }

    public AmazonS3Client eu$shiftforward$apso$aws$S3Bucket$$s3() {
        Object object;
        if (this._s3 == null) {
            ClientConfiguration defaultConfig = new ClientConfiguration().withTcpKeepAlive(true);
            this._s3 = new AmazonS3Client(this.credentials(), defaultConfig);
            this._s3.setEndpoint(this.endpoint());
            object = this._s3.doesBucketExist(this.bucketName()) ? BoxedUnit.UNIT : this._s3.createBucket(this.bucketName(), Region.fromValue((String)this.region()));
        } else {
            object = BoxedUnit.UNIT;
        }
        return this._s3;
    }

    public TransferManager eu$shiftforward$apso$aws$S3Bucket$$transferManager() {
        if (this._transferManager == null) {
            ExecutorService executor = Executors.newFixedThreadPool(10, new ThreadFactory(this){
                private int threadCount;

                private int threadCount() {
                    return this.threadCount;
                }

                private void threadCount_$eq(int x$1) {
                    this.threadCount = x$1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Thread newThread(Runnable r) {
                    void var2_2;
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s3-transfer-manager-worker-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.threadCount())})));
                    this.threadCount_$eq(this.threadCount() + 1);
                    return var2_2;
                }
                {
                    this.threadCount = 1;
                }
            });
            this._transferManager = new TransferManager((AmazonS3)this.eu$shiftforward$apso$aws$S3Bucket$$s3(), executor);
        }
        return this._transferManager;
    }

    public Tuple3<String, String, String> eu$shiftforward$apso$aws$S3Bucket$$splitKey(String key) {
        int iExtensionPoint = key.lastIndexOf(46);
        int iSlash = key.lastIndexOf(47);
        String mainKey = iSlash != -1 ? key.substring(0, iSlash) : "";
        String extension2 = iExtensionPoint != -1 ? key.substring(iExtensionPoint) : "";
        String name2 = iExtensionPoint != -1 ? key.substring(0, iExtensionPoint) : key;
        return new Tuple3((Object)mainKey, (Object)name2, (Object)extension2);
    }

    public String eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(String key) {
        return key.startsWith("./") ? (String)new StringOps(Predef$.MODULE$.augmentString(key)).drop(2) : key;
    }

    public long size(String key) {
        return BoxesRunTime.unboxToLong((Object)this.retry((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().getObjectMetadata(this.$outer.bucketName(), this.key$1).getContentLength();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$1 = key$1;
            }
        }, this.retry$default$2(), this.retry$default$3()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public Iterator<S3ObjectSummary> getObjectsWithMatchingPrefix(String prefix, boolean includeDirectories) {
        this.log().info("Finding files matching prefix '{}'...", new Object[]{prefix});
        Iterator listings = package$.MODULE$.Iterator().iterate((Object)this.eu$shiftforward$apso$aws$S3Bucket$$s3().listObjects(this.bucketName(), this.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(prefix)), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;

            public final ObjectListing apply(ObjectListing listing) {
                ObjectListing objectListing;
                if (listing.isTruncated()) {
                    this.$outer.log().debug("Asking for another batch of objects...");
                    objectListing = this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().listNextBatchOfObjects(listing);
                } else {
                    objectListing = null;
                }
                return objectListing;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Iterator objects = listings.takeWhile((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ObjectListing x$1) {
                return x$1 != null;
            }
        }).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Buffer<S3ObjectSummary> apply(ObjectListing x$2) {
                return JavaConversions$.MODULE$.asScalaBuffer(x$2.getObjectSummaries());
            }
        });
        return includeDirectories ? objects : objects.filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(S3ObjectSummary x$3) {
                return x$3.getKey().endsWith("/");
            }
        });
    }

    public boolean getObjectsWithMatchingPrefix$default$2() {
        return false;
    }

    public Iterator<String> getFilesWithMatchingPrefix(String prefix, boolean includeDirectories) {
        return this.getObjectsWithMatchingPrefix(prefix, includeDirectories).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(S3ObjectSummary x$4) {
                return x$4.getKey();
            }
        });
    }

    public boolean getFilesWithMatchingPrefix$default$2() {
        return false;
    }

    public boolean push(String key, File file) {
        return this.retry((Function0)new Serializable(this, key, file){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$2;
            private final File file$1;

            public final UploadResult apply() {
                this.$outer.log().info("Pushing '{}' to 's3://{}/{}'", new Object[]{this.file$1.getPath(), this.$outer.bucketName(), this.key$2});
                return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$transferManager().upload(new PutObjectRequest(this.$outer.bucketName(), this.$outer.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(this.key$2), this.file$1)).waitForUploadResult();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$2 = key$2;
                this.file$1 = file$1;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean push(String key, InputStream inputStream, Option<Object> length) {
        return this.retry((Function0)new Serializable(this, key, inputStream, length){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$3;
            private final InputStream inputStream$1;
            private final Option length$1;

            public final UploadResult apply() {
                this.$outer.log().info("Pushing to 's3://{}/{}'", (Object)this.$outer.bucketName(), (Object)this.key$3);
                ObjectMetadata metadata = new ObjectMetadata();
                this.length$1.foreach((Function1)new Serializable(this, metadata){
                    public static final long serialVersionUID = 0L;
                    private final ObjectMetadata metadata$1;

                    public final void apply(long x$1) {
                        this.apply$mcVJ$sp(x$1);
                    }

                    public void apply$mcVJ$sp(long x$1) {
                        this.metadata$1.setContentLength(x$1);
                    }
                    {
                        this.metadata$1 = metadata$1;
                    }
                });
                return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$transferManager().upload(new PutObjectRequest(this.$outer.bucketName(), this.$outer.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(this.key$3), this.inputStream$1, metadata)).waitForUploadResult();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$3 = key$3;
                this.inputStream$1 = inputStream$1;
                this.length$1 = length$1;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean delete(String key) {
        return this.retry((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().deleteObject(this.$outer.bucketName(), this.$outer.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(this.key$4));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$4 = key$4;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean exists(String key) {
        return this.retry((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$5;

            public final ObjectMetadata apply() {
                return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().getObjectMetadata(this.$outer.bucketName(), this.key$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$5 = key$5;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean isDirectory(String key) {
        return this.retry((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$6;

            public final List<S3ObjectSummary> apply() {
                return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().listObjects(new ListObjectsRequest().withBucketName(this.$outer.bucketName()).withMaxKeys(Predef$.MODULE$.int2Integer(2)).withPrefix(this.key$6)).getObjectSummaries();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$6 = key$6;
            }
        }, this.retry$default$2(), this.retry$default$3()).exists((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            public final String key$6;

            public final boolean apply(List<S3ObjectSummary> x$5) {
                return JavaConversions$.MODULE$.asScalaBuffer(x$5).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$isDirectory$2 $outer;

                    public final boolean apply(S3ObjectSummary x$6) {
                        return x$6.getKey().startsWith(new StringBuilder().append((Object)this.$outer.key$6).append((Object)"/").toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.key$6 = key$6;
            }
        });
    }

    public void setAcl(String key, CannedAccessControlList acl) {
        this.log().info("Setting 's3://{}/{}' permissions to '{}'", new Object[]{this.bucketName(), key, acl});
        this.eu$shiftforward$apso$aws$S3Bucket$$s3().setObjectAcl(this.bucketName(), key, acl);
    }

    public boolean createDirectory(String key) {
        return this.retry((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$7;

            public final PutObjectResult apply() {
                this.$outer.log().info("Creating directory in 's3://{}/{}'", new Object[]{this.$outer.bucketName(), this.key$7, null});
                ByteArrayInputStream emptyContent = new ByteArrayInputStream((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentLength(0L);
                return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().putObject(new PutObjectRequest(this.$outer.bucketName(), new StringBuilder().append((Object)this.$outer.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(this.key$7)).append((Object)"/").toString(), (InputStream)emptyContent, metadata));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$7 = key$7;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean backup(String key) {
        return this.retry((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$8;

            public final CopyObjectResult apply() {
                String sanitizedKey = this.$outer.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(this.key$8);
                Tuple3<String, String, String> tuple3 = this.$outer.eu$shiftforward$apso$aws$S3Bucket$$splitKey(sanitizedKey);
                if (tuple3 != null) {
                    Tuple3 tuple32;
                    String mainKey = (String)tuple3._1();
                    String name2 = (String)tuple3._2();
                    String extension2 = (String)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)mainKey, (Object)name2, (Object)extension2);
                    String mainKey2 = (String)tuple33._1();
                    String name3 = (String)tuple33._2();
                    String extension3 = (String)tuple33._3();
                    return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().copyObject(new CopyObjectRequest(this.$outer.bucketName(), sanitizedKey, this.$outer.bucketName(), new StringBuilder().append((Object)mainKey2).append((Object)"/backup/").append((Object)name3.substring(mainKey2.length() + 1)).append((Object)extension3).toString()));
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$8 = key$8;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean pull(String key, String destination) {
        return this.retry((Function0)new Serializable(this, key, destination){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$9;
            private final String destination$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().info("Pulling 's3://{}/{}' to '{}'", new Object[]{this.$outer.bucketName(), this.key$9, this.destination$1});
                S3Object s3Object = this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().getObject(new GetObjectRequest(this.$outer.bucketName(), this.$outer.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(this.key$9)));
                S3ObjectInputStream inputStream = s3Object.getObjectContent();
                File f = new File(this.destination$1).getCanonicalFile();
                f.getParentFile().mkdirs();
                FileOutputStream outputStream = new FileOutputStream(f);
                int read2 = 0;
                byte[] bytes = new byte[1024];
                read2 = inputStream.read(bytes);
                while (read2 != -1) {
                    outputStream.write(bytes, 0, read2);
                    read2 = inputStream.read(bytes);
                }
                this.$outer.log().info("Downloaded 's3://{}/{}' to '{}'. Closing files.", new Object[]{this.$outer.bucketName(), this.key$9, this.destination$1});
                inputStream.close();
                outputStream.flush();
                outputStream.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$9 = key$9;
                this.destination$1 = destination$1;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public InputStream stream(String key) {
        this.log().info("Streaming 's3://{}/{}'", (Object)this.bucketName(), (Object)key);
        return this.eu$shiftforward$apso$aws$S3Bucket$$s3().getObject(new GetObjectRequest(this.bucketName(), this.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(key))).getObjectContent();
    }

    private PartialFunction<Throwable, Object> handler() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                AmazonClientException amazonClientException = null;
                A1 A1 = x1;
                if (A1 instanceof AmazonS3Exception) {
                    Boolean bl2;
                    AmazonS3Exception amazonS3Exception = (AmazonS3Exception)A1;
                    int n = amazonS3Exception.getStatusCode();
                    switch (n) {
                        default: {
                            this.$outer.log().error(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|S3 service error: ", ". Extended request id: ", "\n                      |Additional details: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{amazonS3Exception.getMessage(), amazonS3Exception.getExtendedRequestId(), amazonS3Exception.getAdditionalDetails()})))).stripMargin(), (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)false);
                            break;
                        }
                        case 403: {
                            this.$outer.log().error("No permission to access the file", (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                            break;
                        }
                        case 404: {
                            this.$outer.log().error("The specified file does not exist", (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                        }
                    }
                    object = bl2;
                    return (B1)object;
                }
                if (A1 instanceof AmazonServiceException) {
                    AmazonServiceException amazonServiceException = (AmazonServiceException)A1;
                    this.$outer.log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Service error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{amazonServiceException.getMessage()})), (Throwable)amazonServiceException);
                    object = BoxesRunTime.boxToBoolean((boolean)amazonServiceException.isRetryable());
                    return (B1)object;
                }
                if (A1 instanceof AmazonClientException) {
                    bl = true;
                    amazonClientException = (AmazonClientException)A1;
                    String string = amazonClientException.getMessage();
                    String string2 = "Unable to load AWS credentials from any provider in the chain";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.$outer.log().error("Unable to load AWS credentials", (Throwable)amazonClientException);
                        object = BoxesRunTime.boxToBoolean((boolean)true);
                        return (B1)object;
                    }
                }
                if (bl) {
                    this.$outer.log().error("Client error pulling file", (Throwable)amazonClientException);
                    object = BoxesRunTime.boxToBoolean((boolean)amazonClientException.isRetryable());
                    return (B1)object;
                }
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.log().error("An error occurred", (Throwable)exception);
                    object = BoxesRunTime.boxToBoolean((boolean)false);
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Throwable x1) {
                boolean bl = false;
                AmazonClientException amazonClientException = null;
                Throwable throwable = x1;
                if (throwable instanceof AmazonS3Exception) {
                    return true;
                }
                if (throwable instanceof AmazonServiceException) {
                    return true;
                }
                if (throwable instanceof AmazonClientException) {
                    bl = true;
                    amazonClientException = (AmazonClientException)throwable;
                    String string = amazonClientException.getMessage();
                    String string2 = "Unable to load AWS credentials from any provider in the chain";
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) {
                        return true;
                    }
                }
                if (bl) {
                    return true;
                }
                if (!(throwable instanceof Exception)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private <T> Option<T> retry(Function0<T> f, int tries, int sleepTime) {
        None$ none$;
        block4: {
            None$ none$2;
            block5: {
                while (true) {
                    if (tries == 0) {
                        this.log().error("Max retries reached. Aborting S3 operation");
                        none$ = None$.MODULE$;
                        break block4;
                    }
                    Try try_ = Try$.MODULE$.apply(f);
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        Object res = success.value();
                        none$2 = new Some(res);
                        break block5;
                    }
                    if (!(try_ instanceof Failure)) break;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (BoxesRunTime.unboxToBoolean((Object)this.handler().apply((Object)e))) break;
                    if (tries > 1) {
                        this.log().warn("Error during S3 operation. Retrying in {}ms ({} more times)", (Object)BoxesRunTime.boxToInteger((int)sleepTime), (Object)BoxesRunTime.boxToInteger((int)(tries - 1)));
                        Thread.sleep(sleepTime);
                    }
                    --tries;
                }
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        return none$;
    }

    private <T> int retry$default$2() {
        return 3;
    }

    private <T> int retry$default$3() {
        return 5000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof S3Bucket)) return false;
        S3Bucket s3Bucket = (S3Bucket)object;
        String string = s3Bucket.bucketName();
        String string2 = this.bucketName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = s3Bucket.credentials().getAWSAccessKeyId();
        String string4 = this.credentials().getAWSAccessKeyId();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = s3Bucket.credentials().getAWSSecretKey();
        String string6 = this.credentials().getAWSSecretKey();
        if (string5 == null) {
            if (string6 == null) return true;
            return false;
        } else {
            if (!string5.equals(string6)) return false;
            return true;
        }
    }

    public S3Bucket(String bucketName, Function0<AWSCredentials> credentialsFactory) {
        this.bucketName = bucketName;
        this.credentialsFactory = credentialsFactory;
        Logging$class.$init$(this);
    }
}

