/*
 * Decompiled with CFR 0.152.
 */
package eu.shiftforward.apso.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.ExecutorFactory;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CreateBucketRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import eu.shiftforward.apso.Logging;
import eu.shiftforward.apso.Logging$class;
import eu.shiftforward.apso.aws.S3Bucket$;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t}e\u0001B\u0001\u0003\u0001-\u0011\u0001bU\u001aCk\u000e\\W\r\u001e\u0006\u0003\u0007\u0011\t1!Y<t\u0015\t)a!\u0001\u0003baN|'BA\u0004\t\u00031\u0019\b.\u001b4uM>\u0014x/\u0019:e\u0015\u0005I\u0011AA3v\u0007\u0001\u0019B\u0001\u0001\u0007\u0013-A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003\u000f1{wmZ5oOB\u0011QbF\u0005\u000319\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\u0007\u0001\u0003\u0006\u0004%\taG\u0001\u000bEV\u001c7.\u001a;OC6,W#\u0001\u000f\u0011\u0005u\u0001cBA\u0007\u001f\u0013\tyb\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\t\u0012aa\u0015;sS:<'BA\u0010\u000f\u0011!!\u0003A!A!\u0002\u0013a\u0012a\u00032vG.,GOT1nK\u0002B\u0001B\n\u0001\u0003\u0006\u0004%IaJ\u0001\u0014GJ,G-\u001a8uS\u0006d7\u000f\u0015:pm&$WM]\u000b\u0002QA\u0019Q\"K\u0016\n\u0005)r!!\u0003$v]\u000e$\u0018n\u001c81!\ta3'D\u0001.\u0015\tqs&\u0001\u0003bkRD'B\u0001\u00192\u0003%\tW.\u0019>p]\u0006<8OC\u00013\u0003\r\u0019w.\\\u0005\u0003i5\u0012a#Q,T\u0007J,G-\u001a8uS\u0006d7\u000f\u0015:pm&$WM\u001d\u0005\tm\u0001\u0011\t\u0011)A\u0005Q\u0005!2M]3eK:$\u0018.\u00197t!J|g/\u001b3fe\u0002BQ\u0001\u000f\u0001\u0005\u0002e\na\u0001P5oSRtDc\u0001\u001e={A\u00111\bA\u0007\u0002\u0005!)!d\u000ea\u00019!9ae\u000eI\u0001\u0002\u0004A\u0003\u0002C \u0001\u0011\u000b\u0007K\u0011\u0002!\u0002\r\r|gNZ5h+\u0005\t\u0005C\u0001\"G\u001b\u0005\u0019%BA E\u0015\t)\u0015'\u0001\u0005usB,7/\u00194f\u0013\t95I\u0001\u0004D_:4\u0017n\u001a\u0005\t\u0013\u0002A\t\u0011)Q\u0005\u0003\u000691m\u001c8gS\u001e\u0004\u0003\u0002C&\u0001\u0011\u000b\u0007K\u0011\u0002'\u0002\u0019\r|gNZ5h!J,g-\u001b=\u0016\u00035\u0003\"AT*\u000e\u0003=S!\u0001U)\u0002\t1\fgn\u001a\u0006\u0002%\u0006!!.\u0019<b\u0013\t\ts\n\u0003\u0005V\u0001!\u0005\t\u0015)\u0003N\u00035\u0019wN\u001c4jOB\u0013XMZ5yA!Aq\u000b\u0001ECB\u0013%\u0001,\u0001\u0004sK\u001eLwN\\\u000b\u00023B\u0019!,X'\u000e\u0003mS!\u0001\u0018\b\u0002\tU$\u0018\u000e\\\u0005\u0003=n\u00131\u0001\u0016:z\u0011!\u0001\u0007\u0001#A!B\u0013I\u0016a\u0002:fO&|g\u000e\t\u0005\nE\u0002\u0001\r\u0011!Q!\n\r\f1aX:4!\t!\u0017.D\u0001f\u0015\t1w-\u0001\u0002tg)\u0011\u0001nL\u0001\tg\u0016\u0014h/[2fg&\u0011!.\u001a\u0002\t\u00036\f'p\u001c8Tg!\u0012\u0011\r\u001c\t\u0003\u001b5L!A\u001c\b\u0003\u0013Q\u0014\u0018M\\:jK:$\bB\u00024\u0001A\u0013%\u0001/F\u0001d\u0011%\u0011\b\u00011A\u0001B\u0003&1/\u0001\t`iJ\fgn\u001d4fe6\u000bg.Y4feB\u0011Ao^\u0007\u0002k*\u0011a/Z\u0001\tiJ\fgn\u001d4fe&\u0011\u00010\u001e\u0002\u0010)J\fgn\u001d4fe6\u000bg.Y4fe\"\u0012\u0011\u000f\u001c\u0005\u0007w\u0002\u0001K\u0011\u0002?\u0002\u001fQ\u0014\u0018M\\:gKJl\u0015M\\1hKJ,\u0012a\u001d\u0005\u0007}\u0002\u0001K\u0011B@\u0002\u0011M\u0004H.\u001b;LKf$B!!\u0001\u0002\bA1Q\"a\u0001N\u001b6K1!!\u0002\u000f\u0005\u0019!V\u000f\u001d7fg!1\u0011\u0011B?A\u0002q\t1a[3z\u0011!\ti\u0001\u0001Q\u0005\n\u0005=\u0011aC:b]&$\u0018N_3LKf$2\u0001HA\t\u0011\u001d\tI!a\u0003A\u0002qAq!!\u0006\u0001\t\u0003\t9\"\u0001\u0003tSj,G\u0003BA\r\u0003?\u00012!DA\u000e\u0013\r\tiB\u0004\u0002\u0005\u0019>tw\rC\u0004\u0002\n\u0005M\u0001\u0019\u0001\u000f\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u0005ar-\u001a;PE*,7\r^:XSRDW*\u0019;dQ&tw\r\u0015:fM&DHCBA\u0014\u0003\u0017\ny\u0005\u0005\u0004\u0002*\u0005e\u0012q\b\b\u0005\u0003W\t)D\u0004\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\tDC\u0001\u0007yI|w\u000e\u001e \n\u0003=I1!a\u000e\u000f\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u000f\u0002>\tA\u0011\n^3sCR|'OC\u0002\u000289\u0001B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000b*\u0017!B7pI\u0016d\u0017\u0002BA%\u0003\u0007\u0012qbU\u001aPE*,7\r^*v[6\f'/\u001f\u0005\b\u0003\u001b\n\t\u00031\u0001\u001d\u0003\u0019\u0001(/\u001a4jq\"Q\u0011\u0011KA\u0011!\u0003\u0005\r!a\u0015\u0002%%t7\r\\;eK\u0012K'/Z2u_JLWm\u001d\t\u0004\u001b\u0005U\u0013bAA,\u001d\t9!i\\8mK\u0006t\u0007bBA.\u0001\u0011\u0005\u0011QL\u0001\u001bO\u0016$h)\u001b7fg^KG\u000f['bi\u000eD\u0017N\\4Qe\u00164\u0017\u000e\u001f\u000b\u0007\u0003?\n\t'a\u0019\u0011\u000b\u0005%\u0012\u0011\b\u000f\t\u000f\u00055\u0013\u0011\fa\u00019!Q\u0011\u0011KA-!\u0003\u0005\r!a\u0015\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j\u0005!\u0001/^:i)\u0019\t\u0019&a\u001b\u0002n!9\u0011\u0011BA3\u0001\u0004a\u0002\u0002CA8\u0003K\u0002\r!!\u001d\u0002\t\u0019LG.\u001a\t\u0005\u0003g\nI(\u0004\u0002\u0002v)\u0019\u0011qO)\u0002\u0005%|\u0017\u0002BA>\u0003k\u0012AAR5mK\"9\u0011q\r\u0001\u0005\u0002\u0005}D\u0003CA*\u0003\u0003\u000b\u0019)!$\t\u000f\u0005%\u0011Q\u0010a\u00019!A\u0011QQA?\u0001\u0004\t9)A\u0006j]B,Ho\u0015;sK\u0006l\u0007\u0003BA:\u0003\u0013KA!a#\u0002v\tY\u0011J\u001c9viN#(/Z1n\u0011!\ty)! A\u0002\u0005E\u0015A\u00027f]\u001e$\b\u000eE\u0003\u000e\u0003'\u000bI\"C\u0002\u0002\u0016:\u0011aa\u00149uS>t\u0007bBAM\u0001\u0011\u0005\u00111T\u0001\u0007I\u0016dW\r^3\u0015\t\u0005M\u0013Q\u0014\u0005\b\u0003\u0013\t9\n1\u0001\u001d\u0011\u001d\t\t\u000b\u0001C\u0001\u0003G\u000ba!\u001a=jgR\u001cH\u0003BA*\u0003KCq!!\u0003\u0002 \u0002\u0007A\u0004C\u0004\u0002*\u0002!\t!a+\u0002\u0017%\u001cH)\u001b:fGR|'/\u001f\u000b\u0005\u0003'\ni\u000bC\u0004\u0002\n\u0005\u001d\u0006\u0019\u0001\u000f\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\u000611/\u001a;BG2$b!!.\u0002<\u0006u\u0006cA\u0007\u00028&\u0019\u0011\u0011\u0018\b\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0013\ty\u000b1\u0001\u001d\u0011!\ty,a,A\u0002\u0005\u0005\u0017aA1dYB!\u0011\u0011IAb\u0013\u0011\t)-a\u0011\u0003/\r\u000bgN\\3e\u0003\u000e\u001cWm]:D_:$(o\u001c7MSN$\bbBAe\u0001\u0011\u0005\u00111Z\u0001\u0010GJ,\u0017\r^3ESJ,7\r^8ssR!\u00111KAg\u0011\u001d\tI!a2A\u0002qAq!!5\u0001\t\u0003\t\u0019.\u0001\u0004cC\u000e\\W\u000f\u001d\u000b\u0005\u0003'\n)\u000eC\u0004\u0002\n\u0005=\u0007\u0019\u0001\u000f\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\u0006!\u0001/\u001e7m)\u0019\t\u0019&!8\u0002`\"9\u0011\u0011BAl\u0001\u0004a\u0002bBAq\u0003/\u0004\r\u0001H\u0001\fI\u0016\u001cH/\u001b8bi&|g\u000eC\u0004\u0002f\u0002!\t!a:\u0002\rM$(/Z1n)\u0019\t9)!;\u0002l\"9\u0011\u0011BAr\u0001\u0004a\u0002BCAw\u0003G\u0004\n\u00111\u0001\u0002\u001a\u00051qN\u001a4tKRD\u0001\"!=\u0001A\u0013%\u00111_\u0001\bQ\u0006tG\r\\3s+\t\t)\u0010E\u0004\u000e\u0003o\fY0a\u0015\n\u0007\u0005ehBA\bQCJ$\u0018.\u00197Gk:\u001cG/[8o!\u0011\tI#!@\n\t\u0005}\u0018Q\b\u0002\n)\"\u0014xn^1cY\u0016D\u0001Ba\u0001\u0001A\u0013%!QA\u0001\u0006e\u0016$(/_\u000b\u0005\u0005\u000f\u0011y\u0001\u0006\u0005\u0003\n\t\u0005\"1\u0006B\u001b!\u0015i\u00111\u0013B\u0006!\u0011\u0011iAa\u0004\r\u0001\u0011A!\u0011\u0003B\u0001\u0005\u0004\u0011\u0019BA\u0001U#\u0011\u0011)Ba\u0007\u0011\u00075\u00119\"C\u0002\u0003\u001a9\u0011qAT8uQ&tw\rE\u0002\u000e\u0005;I1Aa\b\u000f\u0005\r\te.\u001f\u0005\n\u0005G\u0011\t\u0001\"a\u0001\u0005K\t\u0011A\u001a\t\u0006\u001b\t\u001d\"1B\u0005\u0004\u0005Sq!\u0001\u0003\u001fcs:\fW.\u001a \t\u0015\t5\"\u0011\u0001I\u0001\u0002\u0004\u0011y#A\u0003ue&,7\u000fE\u0002\u000e\u0005cI1Aa\r\u000f\u0005\rIe\u000e\u001e\u0005\u000b\u0005o\u0011\t\u0001%AA\u0002\t=\u0012!C:mK\u0016\u0004H+[7f\u0011\u001d\u0011Y\u0004\u0001C!\u0005{\ta!Z9vC2\u001cH\u0003BA*\u0005\u007fA\u0001B!\u0011\u0003:\u0001\u0007!1D\u0001\u0004_\nT\u0007\"\u0003B#\u0001E\u0005I\u0011\u0002B$\u0003=\u0011X\r\u001e:zI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002B%\u0005?*\"Aa\u0013+\t\t=\"QJ\u0016\u0003\u0005\u001f\u0002BA!\u0015\u0003\\5\u0011!1\u000b\u0006\u0005\u0005+\u00129&A\u0005v]\u000eDWmY6fI*\u0019!\u0011\f\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003^\tM#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012A!\u0011\u0003B\"\u0005\u0004\u0011\u0019\u0002C\u0005\u0003d\u0001\t\n\u0011\"\u0003\u0003f\u0005y!/\u001a;ss\u0012\"WMZ1vYR$3'\u0006\u0003\u0003J\t\u001dD\u0001\u0003B\t\u0005C\u0012\rAa\u0005\t\u0013\t-\u0004!%A\u0005\u0002\t5\u0014AJ4fi>\u0013'.Z2ug^KG\u000f['bi\u000eD\u0017N\\4Qe\u00164\u0017\u000e\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u000e\u0016\u0005\u0003'\u0012i\u0005C\u0005\u0003t\u0001\t\n\u0011\"\u0001\u0003n\u0005!s-\u001a;GS2,7oV5uQ6\u000bGo\u00195j]\u001e\u0004&/\u001a4jq\u0012\"WMZ1vYR$#\u0007C\u0005\u0003x\u0001\t\n\u0011\"\u0001\u0003z\u0005\u00012\u000f\u001e:fC6$C-\u001a4bk2$HEM\u000b\u0003\u0005wRC!!\u0007\u0003N\u001dI!q\u0010\u0002\u0002\u0002#\u0005!\u0011Q\u0001\t'N\u0012UoY6fiB\u00191Ha!\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0005\u000b\u001bBAa!\r-!9\u0001Ha!\u0005\u0002\t%EC\u0001BA\u0011)\u0011iIa!\u0012\u0002\u0013\u0005!qR\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tE%f\u0001\u0015\u0003N!Q!Q\u0013BB\u0003\u0003%IAa&\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00053\u00032A\u0014BN\u0013\r\u0011ij\u0014\u0002\u0007\u001f\nTWm\u0019;")
public class S3Bucket
implements Logging,
Serializable {
    private final String bucketName;
    private final Function0<AWSCredentialsProvider> credentialsProvider;
    private Config eu$shiftforward$apso$aws$S3Bucket$$config;
    private String eu$shiftforward$apso$aws$S3Bucket$$configPrefix;
    private Try<String> region;
    private transient AmazonS3 _s3;
    private transient TransferManager _transferManager;
    private final Logger log;
    private volatile byte bitmap$0;

    public static Function0<AWSCredentialsProvider> $lessinit$greater$default$2() {
        return S3Bucket$.MODULE$.$lessinit$greater$default$2();
    }

    private Config eu$shiftforward$apso$aws$S3Bucket$$config$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.eu$shiftforward$apso$aws$S3Bucket$$config = ConfigFactory.load();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.eu$shiftforward$apso$aws$S3Bucket$$config;
        }
    }

    private String eu$shiftforward$apso$aws$S3Bucket$$configPrefix$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.eu$shiftforward$apso$aws$S3Bucket$$configPrefix = "aws.s3";
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.eu$shiftforward$apso$aws$S3Bucket$$configPrefix;
        }
    }

    private Try region$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.region = Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ S3Bucket $outer;

                    public final String apply() {
                        return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$config().getString(new StringBuilder().append((Object)this.$outer.eu$shiftforward$apso$aws$S3Bucket$$configPrefix()).append((Object)".region").toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.region;
        }
    }

    private Logger log$lzycompute() {
        S3Bucket s3Bucket = this;
        synchronized (s3Bucket) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.log = Logging$class.log(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.log$lzycompute() : this.log;
    }

    public String bucketName() {
        return this.bucketName;
    }

    private Function0<AWSCredentialsProvider> credentialsProvider() {
        return this.credentialsProvider;
    }

    public Config eu$shiftforward$apso$aws$S3Bucket$$config() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.eu$shiftforward$apso$aws$S3Bucket$$config$lzycompute() : this.eu$shiftforward$apso$aws$S3Bucket$$config;
    }

    public String eu$shiftforward$apso$aws$S3Bucket$$configPrefix() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.eu$shiftforward$apso$aws$S3Bucket$$configPrefix$lzycompute() : this.eu$shiftforward$apso$aws$S3Bucket$$configPrefix;
    }

    private Try<String> region() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.region$lzycompute() : this.region;
    }

    public AmazonS3 eu$shiftforward$apso$aws$S3Bucket$$s3() {
        Object object;
        if (this._s3 == null) {
            ClientConfiguration defaultConfig = new ClientConfiguration().withTcpKeepAlive(true);
            this._s3 = (AmazonS3)((AmazonS3Builder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)this.credentialsProvider().apply()).withClientConfiguration(defaultConfig)).withForceGlobalBucketAccessEnabled(Predef$.MODULE$.boolean2Boolean(true)).build();
            object = this._s3.doesBucketExistV2(this.bucketName()) ? BoxedUnit.UNIT : this._s3.createBucket(new CreateBucketRequest(this.bucketName(), (Region)this.region().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Region apply(String x$1) {
                    return Region.fromValue((String)x$1);
                }
            }).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Region apply() {
                    return Region.US_Standard;
                }
            })));
        } else {
            object = BoxedUnit.UNIT;
        }
        return this._s3;
    }

    public TransferManager eu$shiftforward$apso$aws$S3Bucket$$transferManager() {
        if (this._transferManager == null) {
            ExecutorService executor = Executors.newFixedThreadPool(10, new ThreadFactory(this){
                private int threadCount;

                private int threadCount() {
                    return this.threadCount;
                }

                private void threadCount_$eq(int x$1) {
                    this.threadCount = x$1;
                }

                /*
                 * WARNING - void declaration
                 */
                public Thread newThread(Runnable r) {
                    void var2_2;
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s3-transfer-manager-worker-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.threadCount())})));
                    this.threadCount_$eq(this.threadCount() + 1);
                    return var2_2;
                }
                {
                    this.threadCount = 1;
                }
            });
            ExecutorFactory executorFactory = new ExecutorFactory(this, executor){
                private final ExecutorService executor$1;

                public ExecutorService newExecutor() {
                    return this.executor$1;
                }
                {
                    this.executor$1 = executor$1;
                }
            };
            this._transferManager = TransferManagerBuilder.standard().withS3Client(this.eu$shiftforward$apso$aws$S3Bucket$$s3()).withExecutorFactory(executorFactory).build();
        }
        return this._transferManager;
    }

    public Tuple3<String, String, String> eu$shiftforward$apso$aws$S3Bucket$$splitKey(String key) {
        int iExtensionPoint = key.lastIndexOf(46);
        int iSlash = key.lastIndexOf(47);
        String mainKey = iSlash != -1 ? key.substring(0, iSlash) : "";
        String extension2 = iExtensionPoint != -1 ? key.substring(iExtensionPoint) : "";
        String name2 = iExtensionPoint != -1 ? key.substring(0, iExtensionPoint) : key;
        return new Tuple3((Object)mainKey, (Object)name2, (Object)extension2);
    }

    public String eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(String key) {
        return key.startsWith("./") ? (String)new StringOps(Predef$.MODULE$.augmentString(key)).drop(2) : key;
    }

    public long size(String key) {
        return BoxesRunTime.unboxToLong((Object)this.retry((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().getObjectMetadata(this.$outer.bucketName(), this.key$1).getContentLength();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$1 = key$1;
            }
        }, this.retry$default$2(), this.retry$default$3()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public Iterator<S3ObjectSummary> getObjectsWithMatchingPrefix(String prefix, boolean includeDirectories) {
        this.log().info("Finding files matching prefix '{}'...", new Object[]{prefix});
        Iterator listings = package$.MODULE$.Iterator().iterate((Object)this.eu$shiftforward$apso$aws$S3Bucket$$s3().listObjects(this.bucketName(), this.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(prefix)), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;

            public final ObjectListing apply(ObjectListing listing) {
                ObjectListing objectListing;
                if (listing.isTruncated()) {
                    this.$outer.log().debug("Asking for another batch of objects...");
                    objectListing = this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().listNextBatchOfObjects(listing);
                } else {
                    objectListing = null;
                }
                return objectListing;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Iterator objects = listings.takeWhile((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ObjectListing x$1) {
                return x$1 != null;
            }
        }).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Buffer<S3ObjectSummary> apply(ObjectListing x$2) {
                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$2.getObjectSummaries()).asScala();
            }
        });
        return includeDirectories ? objects : objects.filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(S3ObjectSummary x$3) {
                return x$3.getKey().endsWith("/");
            }
        });
    }

    public boolean getObjectsWithMatchingPrefix$default$2() {
        return false;
    }

    public Iterator<String> getFilesWithMatchingPrefix(String prefix, boolean includeDirectories) {
        return this.getObjectsWithMatchingPrefix(prefix, includeDirectories).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(S3ObjectSummary x$4) {
                return x$4.getKey();
            }
        });
    }

    public boolean getFilesWithMatchingPrefix$default$2() {
        return false;
    }

    public boolean push(String key, File file) {
        return this.retry((Function0)new Serializable(this, key, file){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$2;
            private final File file$1;

            public final UploadResult apply() {
                this.$outer.log().info("Pushing '{}' to 's3://{}/{}'", new Object[]{this.file$1.getPath(), this.$outer.bucketName(), this.key$2});
                return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$transferManager().upload(new PutObjectRequest(this.$outer.bucketName(), this.$outer.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(this.key$2), this.file$1)).waitForUploadResult();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$2 = key$2;
                this.file$1 = file$1;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean push(String key, InputStream inputStream, Option<Object> length) {
        return this.retry((Function0)new Serializable(this, key, inputStream, length){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$3;
            private final InputStream inputStream$1;
            private final Option length$1;

            public final UploadResult apply() {
                this.$outer.log().info("Pushing to 's3://{}/{}'", (Object)this.$outer.bucketName(), (Object)this.key$3);
                ObjectMetadata metadata = new ObjectMetadata();
                this.length$1.foreach((Function1)new Serializable(this, metadata){
                    public static final long serialVersionUID = 0L;
                    private final ObjectMetadata metadata$1;

                    public final void apply(long x$1) {
                        this.apply$mcVJ$sp(x$1);
                    }

                    public void apply$mcVJ$sp(long x$1) {
                        this.metadata$1.setContentLength(x$1);
                    }
                    {
                        this.metadata$1 = metadata$1;
                    }
                });
                return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$transferManager().upload(new PutObjectRequest(this.$outer.bucketName(), this.$outer.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(this.key$3), this.inputStream$1, metadata)).waitForUploadResult();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$3 = key$3;
                this.inputStream$1 = inputStream$1;
                this.length$1 = length$1;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean delete(String key) {
        return this.retry((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().deleteObject(this.$outer.bucketName(), this.$outer.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(this.key$4));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$4 = key$4;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean exists(String key) {
        return this.retry((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$5;

            public final ObjectMetadata apply() {
                return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().getObjectMetadata(this.$outer.bucketName(), this.key$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$5 = key$5;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean isDirectory(String key) {
        return this.retry((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$6;

            public final Buffer<S3ObjectSummary> apply() {
                return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().listObjects(new ListObjectsRequest().withBucketName(this.$outer.bucketName()).withMaxKeys(Predef$.MODULE$.int2Integer(2)).withPrefix(this.key$6)).getObjectSummaries()).asScala();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$6 = key$6;
            }
        }, this.retry$default$2(), this.retry$default$3()).exists((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            public final String key$6;

            public final boolean apply(Buffer<S3ObjectSummary> x$5) {
                return x$5.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$isDirectory$2 $outer;

                    public final boolean apply(S3ObjectSummary x$6) {
                        return x$6.getKey().startsWith(new StringBuilder().append((Object)this.$outer.key$6).append((Object)"/").toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.key$6 = key$6;
            }
        });
    }

    public void setAcl(String key, CannedAccessControlList acl) {
        this.log().info("Setting 's3://{}/{}' permissions to '{}'", new Object[]{this.bucketName(), key, acl});
        this.eu$shiftforward$apso$aws$S3Bucket$$s3().setObjectAcl(this.bucketName(), key, acl);
    }

    public boolean createDirectory(String key) {
        return this.retry((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$7;

            public final PutObjectResult apply() {
                this.$outer.log().info("Creating directory in 's3://{}/{}'", new Object[]{this.$outer.bucketName(), this.key$7, null});
                ByteArrayInputStream emptyContent = new ByteArrayInputStream((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentLength(0L);
                return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().putObject(new PutObjectRequest(this.$outer.bucketName(), new StringBuilder().append((Object)this.$outer.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(this.key$7)).append((Object)"/").toString(), (InputStream)emptyContent, metadata));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$7 = key$7;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean backup(String key) {
        return this.retry((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$8;

            public final CopyObjectResult apply() {
                String sanitizedKey = this.$outer.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(this.key$8);
                Tuple3<String, String, String> tuple3 = this.$outer.eu$shiftforward$apso$aws$S3Bucket$$splitKey(sanitizedKey);
                if (tuple3 != null) {
                    Tuple3 tuple32;
                    String mainKey = (String)tuple3._1();
                    String name2 = (String)tuple3._2();
                    String extension2 = (String)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)mainKey, (Object)name2, (Object)extension2);
                    String mainKey2 = (String)tuple33._1();
                    String name3 = (String)tuple33._2();
                    String extension3 = (String)tuple33._3();
                    return this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().copyObject(new CopyObjectRequest(this.$outer.bucketName(), sanitizedKey, this.$outer.bucketName(), new StringBuilder().append((Object)mainKey2).append((Object)"/backup/").append((Object)name3.substring(mainKey2.length() + 1)).append((Object)extension3).toString()));
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$8 = key$8;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public boolean pull(String key, String destination) {
        return this.retry((Function0)new Serializable(this, key, destination){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;
            private final String key$9;
            private final String destination$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().info("Pulling 's3://{}/{}' to '{}'", new Object[]{this.$outer.bucketName(), this.key$9, this.destination$1});
                S3Object s3Object = this.$outer.eu$shiftforward$apso$aws$S3Bucket$$s3().getObject(new GetObjectRequest(this.$outer.bucketName(), this.$outer.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(this.key$9)));
                S3ObjectInputStream inputStream = s3Object.getObjectContent();
                File f = new File(this.destination$1).getCanonicalFile();
                f.getParentFile().mkdirs();
                FileOutputStream outputStream = new FileOutputStream(f);
                int read2 = 0;
                byte[] bytes = new byte[1024];
                read2 = inputStream.read(bytes);
                while (read2 != -1) {
                    outputStream.write(bytes, 0, read2);
                    read2 = inputStream.read(bytes);
                }
                this.$outer.log().info("Downloaded 's3://{}/{}' to '{}'. Closing files.", new Object[]{this.$outer.bucketName(), this.key$9, this.destination$1});
                inputStream.close();
                outputStream.flush();
                outputStream.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$9 = key$9;
                this.destination$1 = destination$1;
            }
        }, this.retry$default$2(), this.retry$default$3()).isDefined();
    }

    public InputStream stream(String key, long offset) {
        this.log().info("Streaming 's3://{}/{}' starting at {}", new Object[]{this.bucketName(), key, ((Object)BoxesRunTime.boxToLong((long)offset)).toString()});
        GetObjectRequest req = offset > 0L ? new GetObjectRequest(this.bucketName(), this.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(key)).withRange(offset) : new GetObjectRequest(this.bucketName(), this.eu$shiftforward$apso$aws$S3Bucket$$sanitizeKey(key));
        return this.eu$shiftforward$apso$aws$S3Bucket$$s3().getObject(req).getObjectContent();
    }

    public long stream$default$2() {
        return 0L;
    }

    private PartialFunction<Throwable, Object> handler() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ S3Bucket $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                AmazonClientException amazonClientException = null;
                A1 A1 = x1;
                if (A1 instanceof AmazonS3Exception) {
                    Boolean bl2;
                    AmazonS3Exception amazonS3Exception = (AmazonS3Exception)A1;
                    int n = amazonS3Exception.getStatusCode();
                    switch (n) {
                        default: {
                            this.$outer.log().error(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|S3 service error: ", ". Extended request id: ", "\n                      |Additional details: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{amazonS3Exception.getMessage(), amazonS3Exception.getExtendedRequestId(), amazonS3Exception.getAdditionalDetails()})))).stripMargin(), (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)false);
                            break;
                        }
                        case 403: {
                            this.$outer.log().error("No permission to access the file", (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                            break;
                        }
                        case 404: {
                            this.$outer.log().error("The specified file does not exist", (Throwable)amazonS3Exception);
                            bl2 = BoxesRunTime.boxToBoolean((boolean)true);
                        }
                    }
                    object = bl2;
                    return (B1)object;
                }
                if (A1 instanceof AmazonServiceException) {
                    AmazonServiceException amazonServiceException = (AmazonServiceException)A1;
                    this.$outer.log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Service error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{amazonServiceException.getMessage()})), (Throwable)amazonServiceException);
                    object = BoxesRunTime.boxToBoolean((boolean)amazonServiceException.isRetryable());
                    return (B1)object;
                }
                if (A1 instanceof AmazonClientException) {
                    bl = true;
                    amazonClientException = (AmazonClientException)A1;
                    String string = amazonClientException.getMessage();
                    String string2 = "Unable to load AWS credentials from any provider in the chain";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.$outer.log().error("Unable to load AWS credentials", (Throwable)amazonClientException);
                        object = BoxesRunTime.boxToBoolean((boolean)true);
                        return (B1)object;
                    }
                }
                if (bl) {
                    this.$outer.log().error("Client error pulling file", (Throwable)amazonClientException);
                    object = BoxesRunTime.boxToBoolean((boolean)amazonClientException.isRetryable());
                    return (B1)object;
                }
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.log().error("An error occurred", (Throwable)exception);
                    object = BoxesRunTime.boxToBoolean((boolean)false);
                    return (B1)object;
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Throwable x1) {
                boolean bl = false;
                AmazonClientException amazonClientException = null;
                Throwable throwable = x1;
                if (throwable instanceof AmazonS3Exception) {
                    return true;
                }
                if (throwable instanceof AmazonServiceException) {
                    return true;
                }
                if (throwable instanceof AmazonClientException) {
                    bl = true;
                    amazonClientException = (AmazonClientException)throwable;
                    String string = amazonClientException.getMessage();
                    String string2 = "Unable to load AWS credentials from any provider in the chain";
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) {
                        return true;
                    }
                }
                if (bl) {
                    return true;
                }
                if (!(throwable instanceof Exception)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private <T> Option<T> retry(Function0<T> f, int tries, int sleepTime) {
        None$ none$;
        block4: {
            None$ none$2;
            block5: {
                while (true) {
                    if (tries == 0) {
                        this.log().error("Max retries reached. Aborting S3 operation");
                        none$ = None$.MODULE$;
                        break block4;
                    }
                    Try try_ = Try$.MODULE$.apply(f);
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        Object res = success.value();
                        none$2 = new Some(res);
                        break block5;
                    }
                    if (!(try_ instanceof Failure)) break;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    if (BoxesRunTime.unboxToBoolean((Object)this.handler().apply((Object)e))) break;
                    if (tries > 1) {
                        this.log().warn("Error during S3 operation. Retrying in {}ms ({} more times)", (Object)BoxesRunTime.boxToInteger((int)sleepTime), (Object)BoxesRunTime.boxToInteger((int)(tries - 1)));
                        Thread.sleep(sleepTime);
                    }
                    --tries;
                }
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        return none$;
    }

    private <T> int retry$default$2() {
        return 3;
    }

    private <T> int retry$default$3() {
        return 5000;
    }

    public boolean equals(Object obj) {
        boolean bl;
        Object object = obj;
        if (object instanceof S3Bucket) {
            S3Bucket s3Bucket = (S3Bucket)object;
            String string = s3Bucket.bucketName();
            String string2 = this.bucketName();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public S3Bucket(String bucketName, Function0<AWSCredentialsProvider> credentialsProvider) {
        this.bucketName = bucketName;
        this.credentialsProvider = credentialsProvider;
        Logging$class.$init$(this);
    }
}

