package eu.shiftforward.adstax.ups.api

/**
 * Domain exception for UpdateUser errors
 * @param error the domain error
 */
case class UpdateUserException(error: UpdateUserError) extends Exception(error.message)

/**
 * UpdateUser domain error
 */
sealed trait UpdateUserError {

  /**
   * Description message for the error
   */
  def message: String
}

/**
 * A error for when a UserId is invalid
 * @param userId the userId to validate
 */
case class InvalidUserId(userId: UserId) extends UpdateUserError {
  def message = s"Invalid UserId with id type ${userId.idType} and id ${userId.id} found."
}
