package eu.shiftforward.adstax.ups.api

import io.circe._
import io.circe.generic.semiauto._

/**
 * A fully qualified user identifier.
 *
 * @param idType the type of identifier
 * @param id the identifier
 */
case class UserId(idType: String, id: String)

object UserId {
  implicit val userIdJsonEncoder: Encoder[UserId] = deriveEncoder[UserId]
  implicit val userIdJsonDecoder: Decoder[UserId] = deriveDecoder[UserId]
}
